/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class InitiateVaultLockRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<StructuredPojo> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).build();
    private static final InitiateVaultLockRequestModelMarshaller instance = new InitiateVaultLockRequestModelMarshaller();

    public static InitiateVaultLockRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(InitiateVaultLockRequest initiateVaultLockRequest, ProtocolMarshaller protocolMarshaller) {
        if (initiateVaultLockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)initiateVaultLockRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)initiateVaultLockRequest.vaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)initiateVaultLockRequest.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

