/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.transform.PartListElementMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PartListElement
implements StructuredPojo,
ToCopyableBuilder<Builder, PartListElement> {
    private final String rangeInBytes;
    private final String sha256TreeHash;

    private PartListElement(BuilderImpl builder) {
        this.rangeInBytes = builder.rangeInBytes;
        this.sha256TreeHash = builder.sha256TreeHash;
    }

    public String rangeInBytes() {
        return this.rangeInBytes;
    }

    public String sha256TreeHash() {
        return this.sha256TreeHash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rangeInBytes() == null ? 0 : this.rangeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.sha256TreeHash() == null ? 0 : this.sha256TreeHash().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartListElement)) {
            return false;
        }
        PartListElement other = (PartListElement)obj;
        if (other.rangeInBytes() == null ^ this.rangeInBytes() == null) {
            return false;
        }
        if (other.rangeInBytes() != null && !other.rangeInBytes().equals(this.rangeInBytes())) {
            return false;
        }
        if (other.sha256TreeHash() == null ^ this.sha256TreeHash() == null) {
            return false;
        }
        return other.sha256TreeHash() == null || other.sha256TreeHash().equals(this.sha256TreeHash());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rangeInBytes() != null) {
            sb.append("RangeInBytes: ").append(this.rangeInBytes()).append(",");
        }
        if (this.sha256TreeHash() != null) {
            sb.append("SHA256TreeHash: ").append(this.sha256TreeHash()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartListElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String rangeInBytes;
        private String sha256TreeHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PartListElement model) {
            this.setRangeInBytes(model.rangeInBytes);
            this.setSHA256TreeHash(model.sha256TreeHash);
        }

        public final String getRangeInBytes() {
            return this.rangeInBytes;
        }

        @Override
        public final Builder rangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
            return this;
        }

        public final void setRangeInBytes(String rangeInBytes) {
            this.rangeInBytes = rangeInBytes;
        }

        public final String getSHA256TreeHash() {
            return this.sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSHA256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        public PartListElement build() {
            return new PartListElement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PartListElement> {
        public Builder rangeInBytes(String var1);

        public Builder sha256TreeHash(String var1);
    }
}

