/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.glacier.model.ActionCode;
import software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription;
import software.amazon.awssdk.services.glacier.model.StatusCode;
import software.amazon.awssdk.services.glacier.transform.GlacierJobDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GlacierJobDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, GlacierJobDescription> {
    private final String jobId;
    private final String jobDescription;
    private final String action;
    private final String archiveId;
    private final String vaultARN;
    private final String creationDate;
    private final Boolean completed;
    private final String statusCode;
    private final String statusMessage;
    private final Long archiveSizeInBytes;
    private final Long inventorySizeInBytes;
    private final String snsTopic;
    private final String completionDate;
    private final String sha256TreeHash;
    private final String archiveSHA256TreeHash;
    private final String retrievalByteRange;
    private final String tier;
    private final InventoryRetrievalJobDescription inventoryRetrievalParameters;

    private GlacierJobDescription(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobDescription = builder.jobDescription;
        this.action = builder.action;
        this.archiveId = builder.archiveId;
        this.vaultARN = builder.vaultARN;
        this.creationDate = builder.creationDate;
        this.completed = builder.completed;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.archiveSizeInBytes = builder.archiveSizeInBytes;
        this.inventorySizeInBytes = builder.inventorySizeInBytes;
        this.snsTopic = builder.snsTopic;
        this.completionDate = builder.completionDate;
        this.sha256TreeHash = builder.sha256TreeHash;
        this.archiveSHA256TreeHash = builder.archiveSHA256TreeHash;
        this.retrievalByteRange = builder.retrievalByteRange;
        this.tier = builder.tier;
        this.inventoryRetrievalParameters = builder.inventoryRetrievalParameters;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobDescription() {
        return this.jobDescription;
    }

    public String action() {
        return this.action;
    }

    public String archiveId() {
        return this.archiveId;
    }

    public String vaultARN() {
        return this.vaultARN;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public Boolean completed() {
        return this.completed;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Long archiveSizeInBytes() {
        return this.archiveSizeInBytes;
    }

    public Long inventorySizeInBytes() {
        return this.inventorySizeInBytes;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    public String completionDate() {
        return this.completionDate;
    }

    public String sha256TreeHash() {
        return this.sha256TreeHash;
    }

    public String archiveSHA256TreeHash() {
        return this.archiveSHA256TreeHash;
    }

    public String retrievalByteRange() {
        return this.retrievalByteRange;
    }

    public String tier() {
        return this.tier;
    }

    public InventoryRetrievalJobDescription inventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.jobDescription() == null ? 0 : this.jobDescription().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.archiveId() == null ? 0 : this.archiveId().hashCode());
        hashCode = 31 * hashCode + (this.vaultARN() == null ? 0 : this.vaultARN().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.completed() == null ? 0 : this.completed().hashCode());
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.archiveSizeInBytes() == null ? 0 : this.archiveSizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.inventorySizeInBytes() == null ? 0 : this.inventorySizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.snsTopic() == null ? 0 : this.snsTopic().hashCode());
        hashCode = 31 * hashCode + (this.completionDate() == null ? 0 : this.completionDate().hashCode());
        hashCode = 31 * hashCode + (this.sha256TreeHash() == null ? 0 : this.sha256TreeHash().hashCode());
        hashCode = 31 * hashCode + (this.archiveSHA256TreeHash() == null ? 0 : this.archiveSHA256TreeHash().hashCode());
        hashCode = 31 * hashCode + (this.retrievalByteRange() == null ? 0 : this.retrievalByteRange().hashCode());
        hashCode = 31 * hashCode + (this.tier() == null ? 0 : this.tier().hashCode());
        hashCode = 31 * hashCode + (this.inventoryRetrievalParameters() == null ? 0 : this.inventoryRetrievalParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlacierJobDescription)) {
            return false;
        }
        GlacierJobDescription other = (GlacierJobDescription)obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.jobDescription() == null ^ this.jobDescription() == null) {
            return false;
        }
        if (other.jobDescription() != null && !other.jobDescription().equals(this.jobDescription())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.archiveId() == null ^ this.archiveId() == null) {
            return false;
        }
        if (other.archiveId() != null && !other.archiveId().equals(this.archiveId())) {
            return false;
        }
        if (other.vaultARN() == null ^ this.vaultARN() == null) {
            return false;
        }
        if (other.vaultARN() != null && !other.vaultARN().equals(this.vaultARN())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.completed() == null ^ this.completed() == null) {
            return false;
        }
        if (other.completed() != null && !other.completed().equals(this.completed())) {
            return false;
        }
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.archiveSizeInBytes() == null ^ this.archiveSizeInBytes() == null) {
            return false;
        }
        if (other.archiveSizeInBytes() != null && !other.archiveSizeInBytes().equals(this.archiveSizeInBytes())) {
            return false;
        }
        if (other.inventorySizeInBytes() == null ^ this.inventorySizeInBytes() == null) {
            return false;
        }
        if (other.inventorySizeInBytes() != null && !other.inventorySizeInBytes().equals(this.inventorySizeInBytes())) {
            return false;
        }
        if (other.snsTopic() == null ^ this.snsTopic() == null) {
            return false;
        }
        if (other.snsTopic() != null && !other.snsTopic().equals(this.snsTopic())) {
            return false;
        }
        if (other.completionDate() == null ^ this.completionDate() == null) {
            return false;
        }
        if (other.completionDate() != null && !other.completionDate().equals(this.completionDate())) {
            return false;
        }
        if (other.sha256TreeHash() == null ^ this.sha256TreeHash() == null) {
            return false;
        }
        if (other.sha256TreeHash() != null && !other.sha256TreeHash().equals(this.sha256TreeHash())) {
            return false;
        }
        if (other.archiveSHA256TreeHash() == null ^ this.archiveSHA256TreeHash() == null) {
            return false;
        }
        if (other.archiveSHA256TreeHash() != null && !other.archiveSHA256TreeHash().equals(this.archiveSHA256TreeHash())) {
            return false;
        }
        if (other.retrievalByteRange() == null ^ this.retrievalByteRange() == null) {
            return false;
        }
        if (other.retrievalByteRange() != null && !other.retrievalByteRange().equals(this.retrievalByteRange())) {
            return false;
        }
        if (other.tier() == null ^ this.tier() == null) {
            return false;
        }
        if (other.tier() != null && !other.tier().equals(this.tier())) {
            return false;
        }
        if (other.inventoryRetrievalParameters() == null ^ this.inventoryRetrievalParameters() == null) {
            return false;
        }
        return other.inventoryRetrievalParameters() == null || other.inventoryRetrievalParameters().equals(this.inventoryRetrievalParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.jobDescription() != null) {
            sb.append("JobDescription: ").append(this.jobDescription()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.archiveId() != null) {
            sb.append("ArchiveId: ").append(this.archiveId()).append(",");
        }
        if (this.vaultARN() != null) {
            sb.append("VaultARN: ").append(this.vaultARN()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.completed() != null) {
            sb.append("Completed: ").append(this.completed()).append(",");
        }
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.archiveSizeInBytes() != null) {
            sb.append("ArchiveSizeInBytes: ").append(this.archiveSizeInBytes()).append(",");
        }
        if (this.inventorySizeInBytes() != null) {
            sb.append("InventorySizeInBytes: ").append(this.inventorySizeInBytes()).append(",");
        }
        if (this.snsTopic() != null) {
            sb.append("SNSTopic: ").append(this.snsTopic()).append(",");
        }
        if (this.completionDate() != null) {
            sb.append("CompletionDate: ").append(this.completionDate()).append(",");
        }
        if (this.sha256TreeHash() != null) {
            sb.append("SHA256TreeHash: ").append(this.sha256TreeHash()).append(",");
        }
        if (this.archiveSHA256TreeHash() != null) {
            sb.append("ArchiveSHA256TreeHash: ").append(this.archiveSHA256TreeHash()).append(",");
        }
        if (this.retrievalByteRange() != null) {
            sb.append("RetrievalByteRange: ").append(this.retrievalByteRange()).append(",");
        }
        if (this.tier() != null) {
            sb.append("Tier: ").append(this.tier()).append(",");
        }
        if (this.inventoryRetrievalParameters() != null) {
            sb.append("InventoryRetrievalParameters: ").append(this.inventoryRetrievalParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlacierJobDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobDescription;
        private String action;
        private String archiveId;
        private String vaultARN;
        private String creationDate;
        private Boolean completed;
        private String statusCode;
        private String statusMessage;
        private Long archiveSizeInBytes;
        private Long inventorySizeInBytes;
        private String snsTopic;
        private String completionDate;
        private String sha256TreeHash;
        private String archiveSHA256TreeHash;
        private String retrievalByteRange;
        private String tier;
        private InventoryRetrievalJobDescription inventoryRetrievalParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(GlacierJobDescription model) {
            this.setJobId(model.jobId);
            this.setJobDescription(model.jobDescription);
            this.setAction(model.action);
            this.setArchiveId(model.archiveId);
            this.setVaultARN(model.vaultARN);
            this.setCreationDate(model.creationDate);
            this.setCompleted(model.completed);
            this.setStatusCode(model.statusCode);
            this.setStatusMessage(model.statusMessage);
            this.setArchiveSizeInBytes(model.archiveSizeInBytes);
            this.setInventorySizeInBytes(model.inventorySizeInBytes);
            this.setSNSTopic(model.snsTopic);
            this.setCompletionDate(model.completionDate);
            this.setSHA256TreeHash(model.sha256TreeHash);
            this.setArchiveSHA256TreeHash(model.archiveSHA256TreeHash);
            this.setRetrievalByteRange(model.retrievalByteRange);
            this.setTier(model.tier);
            this.setInventoryRetrievalParameters(model.inventoryRetrievalParameters);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionCode action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ActionCode action) {
            this.action(action.toString());
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        public final String getVaultARN() {
            return this.vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getCompleted() {
            return this.completed;
        }

        @Override
        public final Builder completed(Boolean completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(Boolean completed) {
            this.completed = completed;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(StatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final void setStatusCode(StatusCode statusCode) {
            this.statusCode(statusCode.toString());
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getArchiveSizeInBytes() {
            return this.archiveSizeInBytes;
        }

        @Override
        public final Builder archiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
            return this;
        }

        public final void setArchiveSizeInBytes(Long archiveSizeInBytes) {
            this.archiveSizeInBytes = archiveSizeInBytes;
        }

        public final Long getInventorySizeInBytes() {
            return this.inventorySizeInBytes;
        }

        @Override
        public final Builder inventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
            return this;
        }

        public final void setInventorySizeInBytes(Long inventorySizeInBytes) {
            this.inventorySizeInBytes = inventorySizeInBytes;
        }

        public final String getSNSTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSNSTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        public final String getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        public final String getSHA256TreeHash() {
            return this.sha256TreeHash;
        }

        @Override
        public final Builder sha256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
            return this;
        }

        public final void setSHA256TreeHash(String sha256TreeHash) {
            this.sha256TreeHash = sha256TreeHash;
        }

        public final String getArchiveSHA256TreeHash() {
            return this.archiveSHA256TreeHash;
        }

        @Override
        public final Builder archiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
            return this;
        }

        public final void setArchiveSHA256TreeHash(String archiveSHA256TreeHash) {
            this.archiveSHA256TreeHash = archiveSHA256TreeHash;
        }

        public final String getRetrievalByteRange() {
            return this.retrievalByteRange;
        }

        @Override
        public final Builder retrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
            return this;
        }

        public final void setRetrievalByteRange(String retrievalByteRange) {
            this.retrievalByteRange = retrievalByteRange;
        }

        public final String getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final InventoryRetrievalJobDescription getInventoryRetrievalParameters() {
            return this.inventoryRetrievalParameters;
        }

        @Override
        public final Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
            return this;
        }

        public final void setInventoryRetrievalParameters(InventoryRetrievalJobDescription inventoryRetrievalParameters) {
            this.inventoryRetrievalParameters = inventoryRetrievalParameters;
        }

        public GlacierJobDescription build() {
            return new GlacierJobDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlacierJobDescription> {
        public Builder jobId(String var1);

        public Builder jobDescription(String var1);

        public Builder action(String var1);

        public Builder action(ActionCode var1);

        public Builder archiveId(String var1);

        public Builder vaultARN(String var1);

        public Builder creationDate(String var1);

        public Builder completed(Boolean var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StatusCode var1);

        public Builder statusMessage(String var1);

        public Builder archiveSizeInBytes(Long var1);

        public Builder inventorySizeInBytes(Long var1);

        public Builder snsTopic(String var1);

        public Builder completionDate(String var1);

        public Builder sha256TreeHash(String var1);

        public Builder archiveSHA256TreeHash(String var1);

        public Builder retrievalByteRange(String var1);

        public Builder tier(String var1);

        public Builder inventoryRetrievalParameters(InventoryRetrievalJobDescription var1);
    }
}

