/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationOptimizedWaypoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationOptimizedWaypoint> {
    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArrivalTime").getter(WaypointOptimizationOptimizedWaypoint.getter(WaypointOptimizationOptimizedWaypoint::arrivalTime)).setter(WaypointOptimizationOptimizedWaypoint.setter(Builder::arrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()}).build();
    private static final SdkField<Integer> CLUSTER_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClusterIndex").getter(WaypointOptimizationOptimizedWaypoint.getter(WaypointOptimizationOptimizedWaypoint::clusterIndex)).setter(WaypointOptimizationOptimizedWaypoint.setter(Builder::clusterIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIndex").build()}).build();
    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DepartureTime").getter(WaypointOptimizationOptimizedWaypoint.getter(WaypointOptimizationOptimizedWaypoint::departureTime)).setter(WaypointOptimizationOptimizedWaypoint.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(WaypointOptimizationOptimizedWaypoint.getter(WaypointOptimizationOptimizedWaypoint::id)).setter(WaypointOptimizationOptimizedWaypoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(WaypointOptimizationOptimizedWaypoint.getter(WaypointOptimizationOptimizedWaypoint::position)).setter(WaypointOptimizationOptimizedWaypoint.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_TIME_FIELD, CLUSTER_INDEX_FIELD, DEPARTURE_TIME_FIELD, ID_FIELD, POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WaypointOptimizationOptimizedWaypoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arrivalTime;
    private final Integer clusterIndex;
    private final String departureTime;
    private final String id;
    private final List<Double> position;

    private WaypointOptimizationOptimizedWaypoint(BuilderImpl builder) {
        this.arrivalTime = builder.arrivalTime;
        this.clusterIndex = builder.clusterIndex;
        this.departureTime = builder.departureTime;
        this.id = builder.id;
        this.position = builder.position;
    }

    public final String arrivalTime() {
        return this.arrivalTime;
    }

    public final Integer clusterIndex() {
        return this.clusterIndex;
    }

    public final String departureTime() {
        return this.departureTime;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationOptimizedWaypoint)) {
            return false;
        }
        WaypointOptimizationOptimizedWaypoint other = (WaypointOptimizationOptimizedWaypoint)obj;
        return Objects.equals(this.arrivalTime(), other.arrivalTime()) && Objects.equals(this.clusterIndex(), other.clusterIndex()) && Objects.equals(this.departureTime(), other.departureTime()) && Objects.equals(this.id(), other.id()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationOptimizedWaypoint").add("ArrivalTime", (Object)this.arrivalTime()).add("ClusterIndex", (Object)this.clusterIndex()).add("DepartureTime", (Object)this.departureTime()).add("Id", (Object)this.id()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.arrivalTime()));
            }
            case "ClusterIndex": {
                return Optional.ofNullable(clazz.cast(this.clusterIndex()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("ClusterIndex", CLUSTER_INDEX_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationOptimizedWaypoint, T> g) {
        return obj -> g.apply((WaypointOptimizationOptimizedWaypoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arrivalTime;
        private Integer clusterIndex;
        private String departureTime;
        private String id;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationOptimizedWaypoint model) {
            this.arrivalTime(model.arrivalTime);
            this.clusterIndex(model.clusterIndex);
            this.departureTime(model.departureTime);
            this.id(model.id);
            this.position(model.position);
        }

        public final String getArrivalTime() {
            return this.arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final Integer getClusterIndex() {
            return this.clusterIndex;
        }

        public final void setClusterIndex(Integer clusterIndex) {
            this.clusterIndex = clusterIndex;
        }

        @Override
        public final Builder clusterIndex(Integer clusterIndex) {
            this.clusterIndex = clusterIndex;
            return this;
        }

        public final String getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public WaypointOptimizationOptimizedWaypoint build() {
            return new WaypointOptimizationOptimizedWaypoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationOptimizedWaypoint> {
        public Builder arrivalTime(String var1);

        public Builder clusterIndex(Integer var1);

        public Builder departureTime(String var1);

        public Builder id(String var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);
    }
}

