/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.IndexListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteTollPaymentSite;
import software.amazon.awssdk.services.georoutes.model.RouteTollPaymentSiteListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteTollRate;
import software.amazon.awssdk.services.georoutes.model.RouteTollRateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteToll
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteToll> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(RouteToll.getter(RouteToll::country)).setter(RouteToll.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<List<RouteTollPaymentSite>> PAYMENT_SITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PaymentSites").getter(RouteToll.getter(RouteToll::paymentSites)).setter(RouteToll.setter(Builder::paymentSites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentSites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteTollPaymentSite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteTollRate>> RATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rates").getter(RouteToll.getter(RouteToll::rates)).setter(RouteToll.setter(Builder::rates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteTollRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Systems").getter(RouteToll.getter(RouteToll::systems)).setter(RouteToll.setter(Builder::systems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Systems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, PAYMENT_SITES_FIELD, RATES_FIELD, SYSTEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteToll.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String country;
    private final List<RouteTollPaymentSite> paymentSites;
    private final List<RouteTollRate> rates;
    private final List<Integer> systems;

    private RouteToll(BuilderImpl builder) {
        this.country = builder.country;
        this.paymentSites = builder.paymentSites;
        this.rates = builder.rates;
        this.systems = builder.systems;
    }

    public final String country() {
        return this.country;
    }

    public final boolean hasPaymentSites() {
        return this.paymentSites != null && !(this.paymentSites instanceof SdkAutoConstructList);
    }

    public final List<RouteTollPaymentSite> paymentSites() {
        return this.paymentSites;
    }

    public final boolean hasRates() {
        return this.rates != null && !(this.rates instanceof SdkAutoConstructList);
    }

    public final List<RouteTollRate> rates() {
        return this.rates;
    }

    public final boolean hasSystems() {
        return this.systems != null && !(this.systems instanceof SdkAutoConstructList);
    }

    public final List<Integer> systems() {
        return this.systems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaymentSites() ? this.paymentSites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRates() ? this.rates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystems() ? this.systems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteToll)) {
            return false;
        }
        RouteToll other = (RouteToll)obj;
        return Objects.equals(this.country(), other.country()) && this.hasPaymentSites() == other.hasPaymentSites() && Objects.equals(this.paymentSites(), other.paymentSites()) && this.hasRates() == other.hasRates() && Objects.equals(this.rates(), other.rates()) && this.hasSystems() == other.hasSystems() && Objects.equals(this.systems(), other.systems());
    }

    public final String toString() {
        return ToString.builder((String)"RouteToll").add("Country", (Object)this.country()).add("PaymentSites", this.hasPaymentSites() ? this.paymentSites() : null).add("Rates", this.hasRates() ? this.rates() : null).add("Systems", this.hasSystems() ? this.systems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "PaymentSites": {
                return Optional.ofNullable(clazz.cast(this.paymentSites()));
            }
            case "Rates": {
                return Optional.ofNullable(clazz.cast(this.rates()));
            }
            case "Systems": {
                return Optional.ofNullable(clazz.cast(this.systems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Country", COUNTRY_FIELD);
        map.put("PaymentSites", PAYMENT_SITES_FIELD);
        map.put("Rates", RATES_FIELD);
        map.put("Systems", SYSTEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteToll, T> g) {
        return obj -> g.apply((RouteToll)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private List<RouteTollPaymentSite> paymentSites = DefaultSdkAutoConstructList.getInstance();
        private List<RouteTollRate> rates = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> systems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteToll model) {
            this.country(model.country);
            this.paymentSites(model.paymentSites);
            this.rates(model.rates);
            this.systems(model.systems);
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final List<RouteTollPaymentSite.Builder> getPaymentSites() {
            List<RouteTollPaymentSite.Builder> result = RouteTollPaymentSiteListCopier.copyToBuilder(this.paymentSites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPaymentSites(Collection<RouteTollPaymentSite.BuilderImpl> paymentSites) {
            this.paymentSites = RouteTollPaymentSiteListCopier.copyFromBuilder(paymentSites);
        }

        @Override
        public final Builder paymentSites(Collection<RouteTollPaymentSite> paymentSites) {
            this.paymentSites = RouteTollPaymentSiteListCopier.copy(paymentSites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentSites(RouteTollPaymentSite ... paymentSites) {
            this.paymentSites(Arrays.asList(paymentSites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentSites(Consumer<RouteTollPaymentSite.Builder> ... paymentSites) {
            this.paymentSites(Stream.of(paymentSites).map(c -> (RouteTollPaymentSite)((RouteTollPaymentSite.Builder)RouteTollPaymentSite.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteTollRate.Builder> getRates() {
            List<RouteTollRate.Builder> result = RouteTollRateListCopier.copyToBuilder(this.rates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRates(Collection<RouteTollRate.BuilderImpl> rates) {
            this.rates = RouteTollRateListCopier.copyFromBuilder(rates);
        }

        @Override
        public final Builder rates(Collection<RouteTollRate> rates) {
            this.rates = RouteTollRateListCopier.copy(rates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rates(RouteTollRate ... rates) {
            this.rates(Arrays.asList(rates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rates(Consumer<RouteTollRate.Builder> ... rates) {
            this.rates(Stream.of(rates).map(c -> (RouteTollRate)((RouteTollRate.Builder)RouteTollRate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getSystems() {
            if (this.systems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.systems;
        }

        public final void setSystems(Collection<Integer> systems) {
            this.systems = IndexListCopier.copy(systems);
        }

        @Override
        public final Builder systems(Collection<Integer> systems) {
            this.systems = IndexListCopier.copy(systems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systems(Integer ... systems) {
            this.systems(Arrays.asList(systems));
            return this;
        }

        public RouteToll build() {
            return new RouteToll(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteToll> {
        public Builder country(String var1);

        public Builder paymentSites(Collection<RouteTollPaymentSite> var1);

        public Builder paymentSites(RouteTollPaymentSite ... var1);

        public Builder paymentSites(Consumer<RouteTollPaymentSite.Builder> ... var1);

        public Builder rates(Collection<RouteTollRate> var1);

        public Builder rates(RouteTollRate ... var1);

        public Builder rates(Consumer<RouteTollRate.Builder> ... var1);

        public Builder systems(Collection<Integer> var1);

        public Builder systems(Integer ... var1);
    }
}

