/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.IndexListCopier;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteNumber;
import software.amazon.awssdk.services.georoutes.model.RouteNumberListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanDynamicSpeedDetails;
import software.amazon.awssdk.services.georoutes.model.RouteSpanPedestrianAccessAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanPedestrianAccessAttributeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanRoadAttribute;
import software.amazon.awssdk.services.georoutes.model.RouteSpanRoadAttributeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSpanSpeedLimitDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutePedestrianSpan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutePedestrianSpan> {
    private static final SdkField<Long> BEST_CASE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BestCaseDuration").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::bestCaseDuration)).setter(RoutePedestrianSpan.setter(Builder::bestCaseDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCaseDuration").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::country)).setter(RoutePedestrianSpan.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::distance)).setter(RoutePedestrianSpan.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::duration)).setter(RoutePedestrianSpan.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<RouteSpanDynamicSpeedDetails> DYNAMIC_SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicSpeed").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::dynamicSpeed)).setter(RoutePedestrianSpan.setter(Builder::dynamicSpeed)).constructor(RouteSpanDynamicSpeedDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicSpeed").build()}).build();
    private static final SdkField<Integer> FUNCTIONAL_CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FunctionalClassification").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::functionalClassification)).setter(RoutePedestrianSpan.setter(Builder::functionalClassification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionalClassification").build()}).build();
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeometryOffset").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::geometryOffset)).setter(RoutePedestrianSpan.setter(Builder::geometryOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()}).build();
    private static final SdkField<List<Integer>> INCIDENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Incidents").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::incidents)).setter(RoutePedestrianSpan.setter(Builder::incidents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Incidents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalizedString>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::names)).setter(RoutePedestrianSpan.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PEDESTRIAN_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PedestrianAccess").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::pedestrianAccessAsStrings)).setter(RoutePedestrianSpan.setter(Builder::pedestrianAccessWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PedestrianAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::region)).setter(RoutePedestrianSpan.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<List<String>> ROAD_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoadAttributes").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::roadAttributesAsStrings)).setter(RoutePedestrianSpan.setter(Builder::roadAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoadAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteNumber>> ROUTE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteNumbers").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::routeNumbers)).setter(RoutePedestrianSpan.setter(Builder::routeNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteSpanSpeedLimitDetails> SPEED_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpeedLimit").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::speedLimit)).setter(RoutePedestrianSpan.setter(Builder::speedLimit)).constructor(RouteSpanSpeedLimitDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeedLimit").build()}).build();
    private static final SdkField<Long> TYPICAL_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TypicalDuration").getter(RoutePedestrianSpan.getter(RoutePedestrianSpan::typicalDuration)).setter(RoutePedestrianSpan.setter(Builder::typicalDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypicalDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_CASE_DURATION_FIELD, COUNTRY_FIELD, DISTANCE_FIELD, DURATION_FIELD, DYNAMIC_SPEED_FIELD, FUNCTIONAL_CLASSIFICATION_FIELD, GEOMETRY_OFFSET_FIELD, INCIDENTS_FIELD, NAMES_FIELD, PEDESTRIAN_ACCESS_FIELD, REGION_FIELD, ROAD_ATTRIBUTES_FIELD, ROUTE_NUMBERS_FIELD, SPEED_LIMIT_FIELD, TYPICAL_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutePedestrianSpan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long bestCaseDuration;
    private final String country;
    private final Long distance;
    private final Long duration;
    private final RouteSpanDynamicSpeedDetails dynamicSpeed;
    private final Integer functionalClassification;
    private final Integer geometryOffset;
    private final List<Integer> incidents;
    private final List<LocalizedString> names;
    private final List<String> pedestrianAccess;
    private final String region;
    private final List<String> roadAttributes;
    private final List<RouteNumber> routeNumbers;
    private final RouteSpanSpeedLimitDetails speedLimit;
    private final Long typicalDuration;

    private RoutePedestrianSpan(BuilderImpl builder) {
        this.bestCaseDuration = builder.bestCaseDuration;
        this.country = builder.country;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.dynamicSpeed = builder.dynamicSpeed;
        this.functionalClassification = builder.functionalClassification;
        this.geometryOffset = builder.geometryOffset;
        this.incidents = builder.incidents;
        this.names = builder.names;
        this.pedestrianAccess = builder.pedestrianAccess;
        this.region = builder.region;
        this.roadAttributes = builder.roadAttributes;
        this.routeNumbers = builder.routeNumbers;
        this.speedLimit = builder.speedLimit;
        this.typicalDuration = builder.typicalDuration;
    }

    public final Long bestCaseDuration() {
        return this.bestCaseDuration;
    }

    public final String country() {
        return this.country;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final RouteSpanDynamicSpeedDetails dynamicSpeed() {
        return this.dynamicSpeed;
    }

    public final Integer functionalClassification() {
        return this.functionalClassification;
    }

    public final Integer geometryOffset() {
        return this.geometryOffset;
    }

    public final boolean hasIncidents() {
        return this.incidents != null && !(this.incidents instanceof SdkAutoConstructList);
    }

    public final List<Integer> incidents() {
        return this.incidents;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> names() {
        return this.names;
    }

    public final List<RouteSpanPedestrianAccessAttribute> pedestrianAccess() {
        return RouteSpanPedestrianAccessAttributeListCopier.copyStringToEnum(this.pedestrianAccess);
    }

    public final boolean hasPedestrianAccess() {
        return this.pedestrianAccess != null && !(this.pedestrianAccess instanceof SdkAutoConstructList);
    }

    public final List<String> pedestrianAccessAsStrings() {
        return this.pedestrianAccess;
    }

    public final String region() {
        return this.region;
    }

    public final List<RouteSpanRoadAttribute> roadAttributes() {
        return RouteSpanRoadAttributeListCopier.copyStringToEnum(this.roadAttributes);
    }

    public final boolean hasRoadAttributes() {
        return this.roadAttributes != null && !(this.roadAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> roadAttributesAsStrings() {
        return this.roadAttributes;
    }

    public final boolean hasRouteNumbers() {
        return this.routeNumbers != null && !(this.routeNumbers instanceof SdkAutoConstructList);
    }

    public final List<RouteNumber> routeNumbers() {
        return this.routeNumbers;
    }

    public final RouteSpanSpeedLimitDetails speedLimit() {
        return this.speedLimit;
    }

    public final Long typicalDuration() {
        return this.typicalDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bestCaseDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionalClassification());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidents() ? this.incidents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPedestrianAccess() ? this.pedestrianAccessAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoadAttributes() ? this.roadAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteNumbers() ? this.routeNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.speedLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.typicalDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePedestrianSpan)) {
            return false;
        }
        RoutePedestrianSpan other = (RoutePedestrianSpan)obj;
        return Objects.equals(this.bestCaseDuration(), other.bestCaseDuration()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.dynamicSpeed(), other.dynamicSpeed()) && Objects.equals(this.functionalClassification(), other.functionalClassification()) && Objects.equals(this.geometryOffset(), other.geometryOffset()) && this.hasIncidents() == other.hasIncidents() && Objects.equals(this.incidents(), other.incidents()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && this.hasPedestrianAccess() == other.hasPedestrianAccess() && Objects.equals(this.pedestrianAccessAsStrings(), other.pedestrianAccessAsStrings()) && Objects.equals(this.region(), other.region()) && this.hasRoadAttributes() == other.hasRoadAttributes() && Objects.equals(this.roadAttributesAsStrings(), other.roadAttributesAsStrings()) && this.hasRouteNumbers() == other.hasRouteNumbers() && Objects.equals(this.routeNumbers(), other.routeNumbers()) && Objects.equals(this.speedLimit(), other.speedLimit()) && Objects.equals(this.typicalDuration(), other.typicalDuration());
    }

    public final String toString() {
        return ToString.builder((String)"RoutePedestrianSpan").add("BestCaseDuration", (Object)this.bestCaseDuration()).add("Country", (Object)this.country()).add("Distance", (Object)this.distance()).add("Duration", (Object)this.duration()).add("DynamicSpeed", (Object)this.dynamicSpeed()).add("FunctionalClassification", (Object)this.functionalClassification()).add("GeometryOffset", (Object)this.geometryOffset()).add("Incidents", this.hasIncidents() ? this.incidents() : null).add("Names", this.hasNames() ? this.names() : null).add("PedestrianAccess", this.hasPedestrianAccess() ? this.pedestrianAccessAsStrings() : null).add("Region", (Object)this.region()).add("RoadAttributes", this.hasRoadAttributes() ? this.roadAttributesAsStrings() : null).add("RouteNumbers", this.hasRouteNumbers() ? this.routeNumbers() : null).add("SpeedLimit", (Object)this.speedLimit()).add("TypicalDuration", (Object)this.typicalDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BestCaseDuration": {
                return Optional.ofNullable(clazz.cast(this.bestCaseDuration()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DynamicSpeed": {
                return Optional.ofNullable(clazz.cast(this.dynamicSpeed()));
            }
            case "FunctionalClassification": {
                return Optional.ofNullable(clazz.cast(this.functionalClassification()));
            }
            case "GeometryOffset": {
                return Optional.ofNullable(clazz.cast(this.geometryOffset()));
            }
            case "Incidents": {
                return Optional.ofNullable(clazz.cast(this.incidents()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "PedestrianAccess": {
                return Optional.ofNullable(clazz.cast(this.pedestrianAccessAsStrings()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "RoadAttributes": {
                return Optional.ofNullable(clazz.cast(this.roadAttributesAsStrings()));
            }
            case "RouteNumbers": {
                return Optional.ofNullable(clazz.cast(this.routeNumbers()));
            }
            case "SpeedLimit": {
                return Optional.ofNullable(clazz.cast(this.speedLimit()));
            }
            case "TypicalDuration": {
                return Optional.ofNullable(clazz.cast(this.typicalDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BestCaseDuration", BEST_CASE_DURATION_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("DynamicSpeed", DYNAMIC_SPEED_FIELD);
        map.put("FunctionalClassification", FUNCTIONAL_CLASSIFICATION_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Incidents", INCIDENTS_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("PedestrianAccess", PEDESTRIAN_ACCESS_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("RoadAttributes", ROAD_ATTRIBUTES_FIELD);
        map.put("RouteNumbers", ROUTE_NUMBERS_FIELD);
        map.put("SpeedLimit", SPEED_LIMIT_FIELD);
        map.put("TypicalDuration", TYPICAL_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePedestrianSpan, T> g) {
        return obj -> g.apply((RoutePedestrianSpan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long bestCaseDuration;
        private String country;
        private Long distance;
        private Long duration;
        private RouteSpanDynamicSpeedDetails dynamicSpeed;
        private Integer functionalClassification;
        private Integer geometryOffset;
        private List<Integer> incidents = DefaultSdkAutoConstructList.getInstance();
        private List<LocalizedString> names = DefaultSdkAutoConstructList.getInstance();
        private List<String> pedestrianAccess = DefaultSdkAutoConstructList.getInstance();
        private String region;
        private List<String> roadAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<RouteNumber> routeNumbers = DefaultSdkAutoConstructList.getInstance();
        private RouteSpanSpeedLimitDetails speedLimit;
        private Long typicalDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePedestrianSpan model) {
            this.bestCaseDuration(model.bestCaseDuration);
            this.country(model.country);
            this.distance(model.distance);
            this.duration(model.duration);
            this.dynamicSpeed(model.dynamicSpeed);
            this.functionalClassification(model.functionalClassification);
            this.geometryOffset(model.geometryOffset);
            this.incidents(model.incidents);
            this.names(model.names);
            this.pedestrianAccessWithStrings(model.pedestrianAccess);
            this.region(model.region);
            this.roadAttributesWithStrings(model.roadAttributes);
            this.routeNumbers(model.routeNumbers);
            this.speedLimit(model.speedLimit);
            this.typicalDuration(model.typicalDuration);
        }

        public final Long getBestCaseDuration() {
            return this.bestCaseDuration;
        }

        public final void setBestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
        }

        @Override
        public final Builder bestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final RouteSpanDynamicSpeedDetails.Builder getDynamicSpeed() {
            return this.dynamicSpeed != null ? this.dynamicSpeed.toBuilder() : null;
        }

        public final void setDynamicSpeed(RouteSpanDynamicSpeedDetails.BuilderImpl dynamicSpeed) {
            this.dynamicSpeed = dynamicSpeed != null ? dynamicSpeed.build() : null;
        }

        @Override
        public final Builder dynamicSpeed(RouteSpanDynamicSpeedDetails dynamicSpeed) {
            this.dynamicSpeed = dynamicSpeed;
            return this;
        }

        public final Integer getFunctionalClassification() {
            return this.functionalClassification;
        }

        public final void setFunctionalClassification(Integer functionalClassification) {
            this.functionalClassification = functionalClassification;
        }

        @Override
        public final Builder functionalClassification(Integer functionalClassification) {
            this.functionalClassification = functionalClassification;
            return this;
        }

        public final Integer getGeometryOffset() {
            return this.geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final Collection<Integer> getIncidents() {
            if (this.incidents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.incidents;
        }

        public final void setIncidents(Collection<Integer> incidents) {
            this.incidents = IndexListCopier.copy(incidents);
        }

        @Override
        public final Builder incidents(Collection<Integer> incidents) {
            this.incidents = IndexListCopier.copy(incidents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(Integer ... incidents) {
            this.incidents(Arrays.asList(incidents));
            return this;
        }

        public final List<LocalizedString.Builder> getNames() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.names);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNames(Collection<LocalizedString.BuilderImpl> names) {
            this.names = LocalizedStringListCopier.copyFromBuilder(names);
        }

        @Override
        public final Builder names(Collection<LocalizedString> names) {
            this.names = LocalizedStringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(LocalizedString ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(Consumer<LocalizedString.Builder> ... names) {
            this.names(Stream.of(names).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPedestrianAccess() {
            if (this.pedestrianAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pedestrianAccess;
        }

        public final void setPedestrianAccess(Collection<String> pedestrianAccess) {
            this.pedestrianAccess = RouteSpanPedestrianAccessAttributeListCopier.copy(pedestrianAccess);
        }

        @Override
        public final Builder pedestrianAccessWithStrings(Collection<String> pedestrianAccess) {
            this.pedestrianAccess = RouteSpanPedestrianAccessAttributeListCopier.copy(pedestrianAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pedestrianAccessWithStrings(String ... pedestrianAccess) {
            this.pedestrianAccessWithStrings(Arrays.asList(pedestrianAccess));
            return this;
        }

        @Override
        public final Builder pedestrianAccess(Collection<RouteSpanPedestrianAccessAttribute> pedestrianAccess) {
            this.pedestrianAccess = RouteSpanPedestrianAccessAttributeListCopier.copyEnumToString(pedestrianAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pedestrianAccess(RouteSpanPedestrianAccessAttribute ... pedestrianAccess) {
            this.pedestrianAccess(Arrays.asList(pedestrianAccess));
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getRoadAttributes() {
            if (this.roadAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roadAttributes;
        }

        public final void setRoadAttributes(Collection<String> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copy(roadAttributes);
        }

        @Override
        public final Builder roadAttributesWithStrings(Collection<String> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copy(roadAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadAttributesWithStrings(String ... roadAttributes) {
            this.roadAttributesWithStrings(Arrays.asList(roadAttributes));
            return this;
        }

        @Override
        public final Builder roadAttributes(Collection<RouteSpanRoadAttribute> roadAttributes) {
            this.roadAttributes = RouteSpanRoadAttributeListCopier.copyEnumToString(roadAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadAttributes(RouteSpanRoadAttribute ... roadAttributes) {
            this.roadAttributes(Arrays.asList(roadAttributes));
            return this;
        }

        public final List<RouteNumber.Builder> getRouteNumbers() {
            List<RouteNumber.Builder> result = RouteNumberListCopier.copyToBuilder(this.routeNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteNumbers(Collection<RouteNumber.BuilderImpl> routeNumbers) {
            this.routeNumbers = RouteNumberListCopier.copyFromBuilder(routeNumbers);
        }

        @Override
        public final Builder routeNumbers(Collection<RouteNumber> routeNumbers) {
            this.routeNumbers = RouteNumberListCopier.copy(routeNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumbers(RouteNumber ... routeNumbers) {
            this.routeNumbers(Arrays.asList(routeNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumbers(Consumer<RouteNumber.Builder> ... routeNumbers) {
            this.routeNumbers(Stream.of(routeNumbers).map(c -> (RouteNumber)((RouteNumber.Builder)RouteNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteSpanSpeedLimitDetails.Builder getSpeedLimit() {
            return this.speedLimit != null ? this.speedLimit.toBuilder() : null;
        }

        public final void setSpeedLimit(RouteSpanSpeedLimitDetails.BuilderImpl speedLimit) {
            this.speedLimit = speedLimit != null ? speedLimit.build() : null;
        }

        @Override
        public final Builder speedLimit(RouteSpanSpeedLimitDetails speedLimit) {
            this.speedLimit = speedLimit;
            return this;
        }

        public final Long getTypicalDuration() {
            return this.typicalDuration;
        }

        public final void setTypicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
        }

        @Override
        public final Builder typicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
            return this;
        }

        public RoutePedestrianSpan build() {
            return new RoutePedestrianSpan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutePedestrianSpan> {
        public Builder bestCaseDuration(Long var1);

        public Builder country(String var1);

        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder dynamicSpeed(RouteSpanDynamicSpeedDetails var1);

        default public Builder dynamicSpeed(Consumer<RouteSpanDynamicSpeedDetails.Builder> dynamicSpeed) {
            return this.dynamicSpeed((RouteSpanDynamicSpeedDetails)((RouteSpanDynamicSpeedDetails.Builder)RouteSpanDynamicSpeedDetails.builder().applyMutation(dynamicSpeed)).build());
        }

        public Builder functionalClassification(Integer var1);

        public Builder geometryOffset(Integer var1);

        public Builder incidents(Collection<Integer> var1);

        public Builder incidents(Integer ... var1);

        public Builder names(Collection<LocalizedString> var1);

        public Builder names(LocalizedString ... var1);

        public Builder names(Consumer<LocalizedString.Builder> ... var1);

        public Builder pedestrianAccessWithStrings(Collection<String> var1);

        public Builder pedestrianAccessWithStrings(String ... var1);

        public Builder pedestrianAccess(Collection<RouteSpanPedestrianAccessAttribute> var1);

        public Builder pedestrianAccess(RouteSpanPedestrianAccessAttribute ... var1);

        public Builder region(String var1);

        public Builder roadAttributesWithStrings(Collection<String> var1);

        public Builder roadAttributesWithStrings(String ... var1);

        public Builder roadAttributes(Collection<RouteSpanRoadAttribute> var1);

        public Builder roadAttributes(RouteSpanRoadAttribute ... var1);

        public Builder routeNumbers(Collection<RouteNumber> var1);

        public Builder routeNumbers(RouteNumber ... var1);

        public Builder routeNumbers(Consumer<RouteNumber.Builder> ... var1);

        public Builder speedLimit(RouteSpanSpeedLimitDetails var1);

        default public Builder speedLimit(Consumer<RouteSpanSpeedLimitDetails.Builder> speedLimit) {
            return this.speedLimit((RouteSpanSpeedLimitDetails)((RouteSpanSpeedLimitDetails.Builder)RouteSpanSpeedLimitDetails.builder().applyMutation(speedLimit)).build());
        }

        public Builder typicalDuration(Long var1);
    }
}

