/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.geoplaces.endpoints.GeoPlacesEndpointParams;
import software.amazon.awssdk.services.geoplaces.endpoints.GeoPlacesEndpointProvider;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Condition;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.DefaultEndpointAuthSchemeStrategyFactory;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.EndpointAuthSchemeStrategy;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Expr;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.FnNode;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Identifier;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Parameter;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Parameters;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Rule;
import software.amazon.awssdk.services.geoplaces.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultGeoPlacesEndpointProvider
implements GeoPlacesEndpointProvider {
    private static final Logger LOG = Logger.loggerFor(DefaultGeoPlacesEndpointProvider.class);
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultGeoPlacesEndpointProvider.ruleSet();
    private final EndpointAuthSchemeStrategy endpointAuthSchemeStrategy;

    public DefaultGeoPlacesEndpointProvider() {
        DefaultEndpointAuthSchemeStrategyFactory endpointAuthSchemeStrategyFactory = new DefaultEndpointAuthSchemeStrategyFactory();
        this.endpointAuthSchemeStrategy = endpointAuthSchemeStrategyFactory.endpointAuthSchemeStrategy();
    }

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(GeoPlacesEndpointParams endpointParams) {
        Validate.notNull((Object)endpointParams.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)endpointParams.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultGeoPlacesEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(this.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(GeoPlacesEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        return paramsMap;
    }

    Endpoint valueAsEndpointOrThrow(Value value) {
        if (value instanceof Value.Endpoint) {
            Value.Endpoint endpoint = value.expectEndpoint();
            Endpoint.Builder builder = Endpoint.builder();
            builder.url(URI.create(endpoint.getUrl()));
            Map<String, List<String>> headers = endpoint.getHeaders();
            if (headers != null) {
                headers.forEach((name, values) -> values.forEach(v -> builder.putHeader(name, v)));
            }
            this.addKnownProperties(builder, endpoint.getProperties());
            return builder.build();
        }
        if (value instanceof Value.Str) {
            String errorMsg = value.expectString();
            if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
            }
            throw SdkClientException.create((String)errorMsg);
        }
        throw SdkClientException.create((String)("Rule engine return neither an endpoint result or error value. Returned value was: " + value));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_3(), DefaultGeoPlacesEndpointProvider.endpointRule_4()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_1(), DefaultGeoPlacesEndpointProvider.endpointRule_2()));
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo.{Region}.{PartitionResult#dnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo-fips.{Region}.{PartitionResult#dualStackDnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo-fips.{Region}.{PartitionResult#dnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo.{Region}.{PartitionResult#dualStackDnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo.{Region}.{PartitionResult#dnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo-fips.{Region}.{PartitionResult#dualStackDnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo-fips.{Region}.{PartitionResult#dnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-us-gov"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://places.geo.{Region}.{PartitionResult#dualStackDnsSuffix}/v2")).build());
    }

    private static Rule endpointRule_18() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://geo-places-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_17() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_17(), DefaultGeoPlacesEndpointProvider.endpointRule_19()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://geo-places-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_21() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate(), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_23() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_21(), DefaultGeoPlacesEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://geo-places.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_26()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_25(), DefaultGeoPlacesEndpointProvider.endpointRule_27()));
    }

    private static Rule endpointRule_28() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://geo-places.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_8(), DefaultGeoPlacesEndpointProvider.endpointRule_9(), DefaultGeoPlacesEndpointProvider.endpointRule_10(), DefaultGeoPlacesEndpointProvider.endpointRule_11(), DefaultGeoPlacesEndpointProvider.endpointRule_12(), DefaultGeoPlacesEndpointProvider.endpointRule_13(), DefaultGeoPlacesEndpointProvider.endpointRule_14(), DefaultGeoPlacesEndpointProvider.endpointRule_15(), DefaultGeoPlacesEndpointProvider.endpointRule_16(), DefaultGeoPlacesEndpointProvider.endpointRule_20(), DefaultGeoPlacesEndpointProvider.endpointRule_24(), DefaultGeoPlacesEndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_7()));
    }

    private static Rule endpointRule_29() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGeoPlacesEndpointProvider.endpointRule_6(), DefaultGeoPlacesEndpointProvider.endpointRule_29()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("string")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("string")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).build()).addRule(DefaultGeoPlacesEndpointProvider.endpointRule_0()).addRule(DefaultGeoPlacesEndpointProvider.endpointRule_5()).build();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private void addKnownProperties(Endpoint.Builder builder, Map<String, Value> properties) {
        properties.forEach((n, v) -> {
            switch (n) {
                case "authSchemes": {
                    builder.putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, this.endpointAuthSchemeStrategy.createAuthSchemes((Value)v));
                    break;
                }
                default: {
                    LOG.debug(() -> "Ignoring unknown endpoint property: " + n);
                }
            }
        });
    }
}

