/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesResponse;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeResultItem;
import software.amazon.awssdk.services.geoplaces.model.ReverseGeocodeResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReverseGeocodeResponse
extends GeoPlacesResponse
implements ToCopyableBuilder<Builder, ReverseGeocodeResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(ReverseGeocodeResponse.getter(ReverseGeocodeResponse::pricingBucket)).setter(ReverseGeocodeResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<ReverseGeocodeResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(ReverseGeocodeResponse.getter(ReverseGeocodeResponse::resultItems)).setter(ReverseGeocodeResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReverseGeocodeResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD, RESULT_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
            this.put("ResultItems", RESULT_ITEMS_FIELD);
        }
    });
    private final String pricingBucket;
    private final List<ReverseGeocodeResultItem> resultItems;

    private ReverseGeocodeResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<ReverseGeocodeResultItem> resultItems() {
        return this.resultItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReverseGeocodeResponse)) {
            return false;
        }
        ReverseGeocodeResponse other = (ReverseGeocodeResponse)((Object)obj);
        return Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems());
    }

    public final String toString() {
        return ToString.builder((String)"ReverseGeocodeResponse").add("PricingBucket", (Object)this.pricingBucket()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReverseGeocodeResponse, T> g) {
        return obj -> g.apply((ReverseGeocodeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesResponse.BuilderImpl
    implements Builder {
        private String pricingBucket;
        private List<ReverseGeocodeResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReverseGeocodeResponse model) {
            super(model);
            this.pricingBucket(model.pricingBucket);
            this.resultItems(model.resultItems);
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<ReverseGeocodeResultItem.Builder> getResultItems() {
            List<ReverseGeocodeResultItem.Builder> result = ReverseGeocodeResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<ReverseGeocodeResultItem.BuilderImpl> resultItems) {
            this.resultItems = ReverseGeocodeResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<ReverseGeocodeResultItem> resultItems) {
            this.resultItems = ReverseGeocodeResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(ReverseGeocodeResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<ReverseGeocodeResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (ReverseGeocodeResultItem)((ReverseGeocodeResultItem.Builder)ReverseGeocodeResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReverseGeocodeResponse build() {
            return new ReverseGeocodeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoPlacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReverseGeocodeResponse> {
        public Builder pricingBucket(String var1);

        public Builder resultItems(Collection<ReverseGeocodeResultItem> var1);

        public Builder resultItems(ReverseGeocodeResultItem ... var1);

        public Builder resultItems(Consumer<ReverseGeocodeResultItem.Builder> ... var1);
    }
}

