/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.AddressComponentPhonemes;
import software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription;
import software.amazon.awssdk.services.geoplaces.model.PhonemeTranscriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhonemeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhonemeDetails> {
    private static final SdkField<List<PhonemeTranscription>> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Title").getter(PhonemeDetails.getter(PhonemeDetails::title)).setter(PhonemeDetails.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AddressComponentPhonemes> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(PhonemeDetails.getter(PhonemeDetails::address)).setter(PhonemeDetails.setter(Builder::address)).constructor(AddressComponentPhonemes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PhonemeTranscription> title;
    private final AddressComponentPhonemes address;

    private PhonemeDetails(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    public final boolean hasTitle() {
        return this.title != null && !(this.title instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> title() {
        return this.title;
    }

    public final AddressComponentPhonemes address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTitle() ? this.title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhonemeDetails)) {
            return false;
        }
        PhonemeDetails other = (PhonemeDetails)obj;
        return this.hasTitle() == other.hasTitle() && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address());
    }

    public final String toString() {
        return ToString.builder((String)"PhonemeDetails").add("Title", this.hasTitle() ? this.title() : null).add("Address", (Object)this.address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhonemeDetails, T> g) {
        return obj -> g.apply((PhonemeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PhonemeTranscription> title = DefaultSdkAutoConstructList.getInstance();
        private AddressComponentPhonemes address;

        private BuilderImpl() {
        }

        private BuilderImpl(PhonemeDetails model) {
            this.title(model.title);
            this.address(model.address);
        }

        public final List<PhonemeTranscription.Builder> getTitle() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<PhonemeTranscription.BuilderImpl> title) {
            this.title = PhonemeTranscriptionListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<PhonemeTranscription> title) {
            this.title = PhonemeTranscriptionListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(PhonemeTranscription ... title) {
            this.title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<PhonemeTranscription.Builder> ... title) {
            this.title(Stream.of(title).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AddressComponentPhonemes.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(AddressComponentPhonemes.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressComponentPhonemes address) {
            this.address = address;
            return this;
        }

        public PhonemeDetails build() {
            return new PhonemeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhonemeDetails> {
        public Builder title(Collection<PhonemeTranscription> var1);

        public Builder title(PhonemeTranscription ... var1);

        public Builder title(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder address(AddressComponentPhonemes var1);

        default public Builder address(Consumer<AddressComponentPhonemes.Builder> address) {
            return this.address((AddressComponentPhonemes)((AddressComponentPhonemes.Builder)AddressComponentPhonemes.builder().applyMutation(address)).build());
        }
    }
}

