/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeocodeQueryComponents
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeocodeQueryComponents> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::country)).setter(GeocodeQueryComponents.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::region)).setter(GeocodeQueryComponents.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubRegion").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::subRegion)).setter(GeocodeQueryComponents.setter(Builder::subRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()}).build();
    private static final SdkField<String> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locality").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::locality)).setter(GeocodeQueryComponents.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()}).build();
    private static final SdkField<String> DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("District").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::district)).setter(GeocodeQueryComponents.setter(Builder::district)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build()}).build();
    private static final SdkField<String> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Street").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::street)).setter(GeocodeQueryComponents.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()}).build();
    private static final SdkField<String> ADDRESS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressNumber").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::addressNumber)).setter(GeocodeQueryComponents.setter(Builder::addressNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(GeocodeQueryComponents.getter(GeocodeQueryComponents::postalCode)).setter(GeocodeQueryComponents.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD, SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, STREET_FIELD, ADDRESS_NUMBER_FIELD, POSTAL_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String country;
    private final String region;
    private final String subRegion;
    private final String locality;
    private final String district;
    private final String street;
    private final String addressNumber;
    private final String postalCode;

    private GeocodeQueryComponents(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.street = builder.street;
        this.addressNumber = builder.addressNumber;
        this.postalCode = builder.postalCode;
    }

    public final String country() {
        return this.country;
    }

    public final String region() {
        return this.region;
    }

    public final String subRegion() {
        return this.subRegion;
    }

    public final String locality() {
        return this.locality;
    }

    public final String district() {
        return this.district;
    }

    public final String street() {
        return this.street;
    }

    public final String addressNumber() {
        return this.addressNumber;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locality());
        hashCode = 31 * hashCode + Objects.hashCode(this.district());
        hashCode = 31 * hashCode + Objects.hashCode(this.street());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeQueryComponents)) {
            return false;
        }
        GeocodeQueryComponents other = (GeocodeQueryComponents)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.subRegion(), other.subRegion()) && Objects.equals(this.locality(), other.locality()) && Objects.equals(this.district(), other.district()) && Objects.equals(this.street(), other.street()) && Objects.equals(this.addressNumber(), other.addressNumber()) && Objects.equals(this.postalCode(), other.postalCode());
    }

    public final String toString() {
        return ToString.builder((String)"GeocodeQueryComponents").add("Country", (Object)(this.country() == null ? null : "*** Sensitive Data Redacted ***")).add("Region", (Object)(this.region() == null ? null : "*** Sensitive Data Redacted ***")).add("SubRegion", (Object)(this.subRegion() == null ? null : "*** Sensitive Data Redacted ***")).add("Locality", (Object)(this.locality() == null ? null : "*** Sensitive Data Redacted ***")).add("District", (Object)(this.district() == null ? null : "*** Sensitive Data Redacted ***")).add("Street", (Object)(this.street() == null ? null : "*** Sensitive Data Redacted ***")).add("AddressNumber", (Object)(this.addressNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "District": {
                return Optional.ofNullable(clazz.cast(this.district()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "AddressNumber": {
                return Optional.ofNullable(clazz.cast(this.addressNumber()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeocodeQueryComponents, T> g) {
        return obj -> g.apply((GeocodeQueryComponents)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private String region;
        private String subRegion;
        private String locality;
        private String district;
        private String street;
        private String addressNumber;
        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeQueryComponents model) {
            this.country(model.country);
            this.region(model.region);
            this.subRegion(model.subRegion);
            this.locality(model.locality);
            this.district(model.district);
            this.street(model.street);
            this.addressNumber(model.addressNumber);
            this.postalCode(model.postalCode);
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getSubRegion() {
            return this.subRegion;
        }

        public final void setSubRegion(String subRegion) {
            this.subRegion = subRegion;
        }

        @Override
        public final Builder subRegion(String subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final String getLocality() {
            return this.locality;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final String getDistrict() {
            return this.district;
        }

        public final void setDistrict(String district) {
            this.district = district;
        }

        @Override
        public final Builder district(String district) {
            this.district = district;
            return this;
        }

        public final String getStreet() {
            return this.street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getAddressNumber() {
            return this.addressNumber;
        }

        public final void setAddressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
        }

        @Override
        public final Builder addressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public GeocodeQueryComponents build() {
            return new GeocodeQueryComponents(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeocodeQueryComponents> {
        public Builder country(String var1);

        public Builder region(String var1);

        public Builder subRegion(String var1);

        public Builder locality(String var1);

        public Builder district(String var1);

        public Builder street(String var1);

        public Builder addressNumber(String var1);

        public Builder postalCode(String var1);
    }
}

