/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.AutocompleteAddressHighlights;
import software.amazon.awssdk.services.geoplaces.model.Highlight;
import software.amazon.awssdk.services.geoplaces.model.HighlightListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutocompleteHighlights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutocompleteHighlights> {
    private static final SdkField<List<Highlight>> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Title").getter(AutocompleteHighlights.getter(AutocompleteHighlights::title)).setter(AutocompleteHighlights.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutocompleteAddressHighlights> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(AutocompleteHighlights.getter(AutocompleteHighlights::address)).setter(AutocompleteHighlights.setter(Builder::address)).constructor(AutocompleteAddressHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Highlight> title;
    private final AutocompleteAddressHighlights address;

    private AutocompleteHighlights(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    public final boolean hasTitle() {
        return this.title != null && !(this.title instanceof SdkAutoConstructList);
    }

    public final List<Highlight> title() {
        return this.title;
    }

    public final AutocompleteAddressHighlights address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTitle() ? this.title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteHighlights)) {
            return false;
        }
        AutocompleteHighlights other = (AutocompleteHighlights)obj;
        return this.hasTitle() == other.hasTitle() && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address());
    }

    public final String toString() {
        return ToString.builder((String)"AutocompleteHighlights").add("Title", this.hasTitle() ? this.title() : null).add("Address", (Object)this.address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteHighlights, T> g) {
        return obj -> g.apply((AutocompleteHighlights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Highlight> title = DefaultSdkAutoConstructList.getInstance();
        private AutocompleteAddressHighlights address;

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteHighlights model) {
            this.title(model.title);
            this.address(model.address);
        }

        public final List<Highlight.Builder> getTitle() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<Highlight.BuilderImpl> title) {
            this.title = HighlightListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<Highlight> title) {
            this.title = HighlightListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Highlight ... title) {
            this.title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<Highlight.Builder> ... title) {
            this.title(Stream.of(title).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutocompleteAddressHighlights.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(AutocompleteAddressHighlights.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AutocompleteAddressHighlights address) {
            this.address = address;
            return this;
        }

        public AutocompleteHighlights build() {
            return new AutocompleteHighlights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutocompleteHighlights> {
        public Builder title(Collection<Highlight> var1);

        public Builder title(Highlight ... var1);

        public Builder title(Consumer<Highlight.Builder> ... var1);

        public Builder address(AutocompleteAddressHighlights var1);

        default public Builder address(Consumer<AutocompleteAddressHighlights.Builder> address) {
            return this.address((AutocompleteAddressHighlights)((AutocompleteAddressHighlights.Builder)AutocompleteAddressHighlights.builder().applyMutation(address)).build());
        }
    }
}

