/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.AddressComponentMatchScoresIntersectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressComponentMatchScores
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressComponentMatchScores> {
    private static final SdkField<Double> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Country").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::country)).setter(AddressComponentMatchScores.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<Double> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Region").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::region)).setter(AddressComponentMatchScores.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Double> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SubRegion").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::subRegion)).setter(AddressComponentMatchScores.setter(Builder::subRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()}).build();
    private static final SdkField<Double> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Locality").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::locality)).setter(AddressComponentMatchScores.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()}).build();
    private static final SdkField<Double> DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("District").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::district)).setter(AddressComponentMatchScores.setter(Builder::district)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build()}).build();
    private static final SdkField<Double> SUB_DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SubDistrict").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::subDistrict)).setter(AddressComponentMatchScores.setter(Builder::subDistrict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build()}).build();
    private static final SdkField<Double> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PostalCode").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::postalCode)).setter(AddressComponentMatchScores.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<Double> BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Block").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::block)).setter(AddressComponentMatchScores.setter(Builder::block)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()}).build();
    private static final SdkField<Double> SUB_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SubBlock").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::subBlock)).setter(AddressComponentMatchScores.setter(Builder::subBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build()}).build();
    private static final SdkField<List<Double>> INTERSECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Intersection").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::intersection)).setter(AddressComponentMatchScores.setter(Builder::intersection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> ADDRESS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AddressNumber").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::addressNumber)).setter(AddressComponentMatchScores.setter(Builder::addressNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()}).build();
    private static final SdkField<Double> BUILDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Building").getter(AddressComponentMatchScores.getter(AddressComponentMatchScores::building)).setter(AddressComponentMatchScores.setter(Builder::building)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Building").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD, SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, POSTAL_CODE_FIELD, BLOCK_FIELD, SUB_BLOCK_FIELD, INTERSECTION_FIELD, ADDRESS_NUMBER_FIELD, BUILDING_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double country;
    private final Double region;
    private final Double subRegion;
    private final Double locality;
    private final Double district;
    private final Double subDistrict;
    private final Double postalCode;
    private final Double block;
    private final Double subBlock;
    private final List<Double> intersection;
    private final Double addressNumber;
    private final Double building;

    private AddressComponentMatchScores(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.postalCode = builder.postalCode;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.intersection = builder.intersection;
        this.addressNumber = builder.addressNumber;
        this.building = builder.building;
    }

    public final Double country() {
        return this.country;
    }

    public final Double region() {
        return this.region;
    }

    public final Double subRegion() {
        return this.subRegion;
    }

    public final Double locality() {
        return this.locality;
    }

    public final Double district() {
        return this.district;
    }

    public final Double subDistrict() {
        return this.subDistrict;
    }

    public final Double postalCode() {
        return this.postalCode;
    }

    public final Double block() {
        return this.block;
    }

    public final Double subBlock() {
        return this.subBlock;
    }

    public final boolean hasIntersection() {
        return this.intersection != null && !(this.intersection instanceof SdkAutoConstructList);
    }

    public final List<Double> intersection() {
        return this.intersection;
    }

    public final Double addressNumber() {
        return this.addressNumber;
    }

    public final Double building() {
        return this.building;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locality());
        hashCode = 31 * hashCode + Objects.hashCode(this.district());
        hashCode = 31 * hashCode + Objects.hashCode(this.subDistrict());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.block());
        hashCode = 31 * hashCode + Objects.hashCode(this.subBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntersection() ? this.intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.building());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressComponentMatchScores)) {
            return false;
        }
        AddressComponentMatchScores other = (AddressComponentMatchScores)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.subRegion(), other.subRegion()) && Objects.equals(this.locality(), other.locality()) && Objects.equals(this.district(), other.district()) && Objects.equals(this.subDistrict(), other.subDistrict()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.block(), other.block()) && Objects.equals(this.subBlock(), other.subBlock()) && this.hasIntersection() == other.hasIntersection() && Objects.equals(this.intersection(), other.intersection()) && Objects.equals(this.addressNumber(), other.addressNumber()) && Objects.equals(this.building(), other.building());
    }

    public final String toString() {
        return ToString.builder((String)"AddressComponentMatchScores").add("Country", (Object)this.country()).add("Region", (Object)this.region()).add("SubRegion", (Object)this.subRegion()).add("Locality", (Object)this.locality()).add("District", (Object)this.district()).add("SubDistrict", (Object)this.subDistrict()).add("PostalCode", (Object)this.postalCode()).add("Block", (Object)this.block()).add("SubBlock", (Object)this.subBlock()).add("Intersection", this.hasIntersection() ? this.intersection() : null).add("AddressNumber", (Object)this.addressNumber()).add("Building", (Object)this.building()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "District": {
                return Optional.ofNullable(clazz.cast(this.district()));
            }
            case "SubDistrict": {
                return Optional.ofNullable(clazz.cast(this.subDistrict()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "Block": {
                return Optional.ofNullable(clazz.cast(this.block()));
            }
            case "SubBlock": {
                return Optional.ofNullable(clazz.cast(this.subBlock()));
            }
            case "Intersection": {
                return Optional.ofNullable(clazz.cast(this.intersection()));
            }
            case "AddressNumber": {
                return Optional.ofNullable(clazz.cast(this.addressNumber()));
            }
            case "Building": {
                return Optional.ofNullable(clazz.cast(this.building()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddressComponentMatchScores, T> g) {
        return obj -> g.apply((AddressComponentMatchScores)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double country;
        private Double region;
        private Double subRegion;
        private Double locality;
        private Double district;
        private Double subDistrict;
        private Double postalCode;
        private Double block;
        private Double subBlock;
        private List<Double> intersection = DefaultSdkAutoConstructList.getInstance();
        private Double addressNumber;
        private Double building;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressComponentMatchScores model) {
            this.country(model.country);
            this.region(model.region);
            this.subRegion(model.subRegion);
            this.locality(model.locality);
            this.district(model.district);
            this.subDistrict(model.subDistrict);
            this.postalCode(model.postalCode);
            this.block(model.block);
            this.subBlock(model.subBlock);
            this.intersection(model.intersection);
            this.addressNumber(model.addressNumber);
            this.building(model.building);
        }

        public final Double getCountry() {
            return this.country;
        }

        public final void setCountry(Double country) {
            this.country = country;
        }

        @Override
        public final Builder country(Double country) {
            this.country = country;
            return this;
        }

        public final Double getRegion() {
            return this.region;
        }

        public final void setRegion(Double region) {
            this.region = region;
        }

        @Override
        public final Builder region(Double region) {
            this.region = region;
            return this;
        }

        public final Double getSubRegion() {
            return this.subRegion;
        }

        public final void setSubRegion(Double subRegion) {
            this.subRegion = subRegion;
        }

        @Override
        public final Builder subRegion(Double subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final Double getLocality() {
            return this.locality;
        }

        public final void setLocality(Double locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(Double locality) {
            this.locality = locality;
            return this;
        }

        public final Double getDistrict() {
            return this.district;
        }

        public final void setDistrict(Double district) {
            this.district = district;
        }

        @Override
        public final Builder district(Double district) {
            this.district = district;
            return this;
        }

        public final Double getSubDistrict() {
            return this.subDistrict;
        }

        public final void setSubDistrict(Double subDistrict) {
            this.subDistrict = subDistrict;
        }

        @Override
        public final Builder subDistrict(Double subDistrict) {
            this.subDistrict = subDistrict;
            return this;
        }

        public final Double getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(Double postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(Double postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final Double getBlock() {
            return this.block;
        }

        public final void setBlock(Double block) {
            this.block = block;
        }

        @Override
        public final Builder block(Double block) {
            this.block = block;
            return this;
        }

        public final Double getSubBlock() {
            return this.subBlock;
        }

        public final void setSubBlock(Double subBlock) {
            this.subBlock = subBlock;
        }

        @Override
        public final Builder subBlock(Double subBlock) {
            this.subBlock = subBlock;
            return this;
        }

        public final Collection<Double> getIntersection() {
            if (this.intersection instanceof SdkAutoConstructList) {
                return null;
            }
            return this.intersection;
        }

        public final void setIntersection(Collection<Double> intersection) {
            this.intersection = AddressComponentMatchScoresIntersectionListCopier.copy(intersection);
        }

        @Override
        public final Builder intersection(Collection<Double> intersection) {
            this.intersection = AddressComponentMatchScoresIntersectionListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Double ... intersection) {
            this.intersection(Arrays.asList(intersection));
            return this;
        }

        public final Double getAddressNumber() {
            return this.addressNumber;
        }

        public final void setAddressNumber(Double addressNumber) {
            this.addressNumber = addressNumber;
        }

        @Override
        public final Builder addressNumber(Double addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final Double getBuilding() {
            return this.building;
        }

        public final void setBuilding(Double building) {
            this.building = building;
        }

        @Override
        public final Builder building(Double building) {
            this.building = building;
            return this;
        }

        public AddressComponentMatchScores build() {
            return new AddressComponentMatchScores(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressComponentMatchScores> {
        public Builder country(Double var1);

        public Builder region(Double var1);

        public Builder subRegion(Double var1);

        public Builder locality(Double var1);

        public Builder district(Double var1);

        public Builder subDistrict(Double var1);

        public Builder postalCode(Double var1);

        public Builder block(Double var1);

        public Builder subBlock(Double var1);

        public Builder intersection(Collection<Double> var1);

        public Builder intersection(Double ... var1);

        public Builder addressNumber(Double var1);

        public Builder building(Double var1);
    }
}

