/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PostalCodeType {
    USPS_ZIP("UspsZip"),
    USPS_ZIP_PLUS4("UspsZipPlus4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PostalCodeType> VALUE_MAP;
    private final String value;

    private PostalCodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PostalCodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PostalCodeType> knownValues() {
        EnumSet<PostalCodeType> knownValues = EnumSet.allOf(PostalCodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PostalCodeType.class, PostalCodeType::toString);
    }
}

