/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Variant {
    DEFAULT("Default"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Variant> VALUE_MAP;
    private final String value;

    private Variant(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Variant fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Variant> knownValues() {
        EnumSet<Variant> knownValues = EnumSet.allOf(Variant.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Variant.class, Variant::toString);
    }
}

