/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geomaps.model.ColorScheme;
import software.amazon.awssdk.services.geomaps.model.ContourDensity;
import software.amazon.awssdk.services.geomaps.model.GeoMapsRequest;
import software.amazon.awssdk.services.geomaps.model.MapStyle;
import software.amazon.awssdk.services.geomaps.model.Terrain;
import software.amazon.awssdk.services.geomaps.model.Traffic;
import software.amazon.awssdk.services.geomaps.model.TravelMode;
import software.amazon.awssdk.services.geomaps.model.TravelModeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStyleDescriptorRequest
extends GeoMapsRequest
implements ToCopyableBuilder<Builder, GetStyleDescriptorRequest> {
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::styleAsString)).setter(GetStyleDescriptorRequest.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Style").build()}).build();
    private static final SdkField<String> COLOR_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorScheme").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::colorSchemeAsString)).setter(GetStyleDescriptorRequest.setter(Builder::colorScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("color-scheme").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::politicalView)).setter(GetStyleDescriptorRequest.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("political-view").build()}).build();
    private static final SdkField<String> TERRAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Terrain").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::terrainAsString)).setter(GetStyleDescriptorRequest.setter(Builder::terrain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("terrain").build()}).build();
    private static final SdkField<String> CONTOUR_DENSITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContourDensity").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::contourDensityAsString)).setter(GetStyleDescriptorRequest.setter(Builder::contourDensity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("contour-density").build()}).build();
    private static final SdkField<String> TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Traffic").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::trafficAsString)).setter(GetStyleDescriptorRequest.setter(Builder::traffic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("traffic").build()}).build();
    private static final SdkField<List<String>> TRAVEL_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TravelModes").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::travelModesAsStrings)).setter(GetStyleDescriptorRequest.setter(Builder::travelModesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("travel-modes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetStyleDescriptorRequest.getter(GetStyleDescriptorRequest::key)).setter(GetStyleDescriptorRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_FIELD, COLOR_SCHEME_FIELD, POLITICAL_VIEW_FIELD, TERRAIN_FIELD, CONTOUR_DENSITY_FIELD, TRAFFIC_FIELD, TRAVEL_MODES_FIELD, KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStyleDescriptorRequest.memberNameToFieldInitializer();
    private final String style;
    private final String colorScheme;
    private final String politicalView;
    private final String terrain;
    private final String contourDensity;
    private final String traffic;
    private final List<String> travelModes;
    private final String key;

    private GetStyleDescriptorRequest(BuilderImpl builder) {
        super(builder);
        this.style = builder.style;
        this.colorScheme = builder.colorScheme;
        this.politicalView = builder.politicalView;
        this.terrain = builder.terrain;
        this.contourDensity = builder.contourDensity;
        this.traffic = builder.traffic;
        this.travelModes = builder.travelModes;
        this.key = builder.key;
    }

    public final MapStyle style() {
        return MapStyle.fromValue(this.style);
    }

    public final String styleAsString() {
        return this.style;
    }

    public final ColorScheme colorScheme() {
        return ColorScheme.fromValue(this.colorScheme);
    }

    public final String colorSchemeAsString() {
        return this.colorScheme;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final Terrain terrain() {
        return Terrain.fromValue(this.terrain);
    }

    public final String terrainAsString() {
        return this.terrain;
    }

    public final ContourDensity contourDensity() {
        return ContourDensity.fromValue(this.contourDensity);
    }

    public final String contourDensityAsString() {
        return this.contourDensity;
    }

    public final Traffic traffic() {
        return Traffic.fromValue(this.traffic);
    }

    public final String trafficAsString() {
        return this.traffic;
    }

    public final List<TravelMode> travelModes() {
        return TravelModeListCopier.copyStringToEnum(this.travelModes);
    }

    public final boolean hasTravelModes() {
        return this.travelModes != null && !(this.travelModes instanceof SdkAutoConstructList);
    }

    public final List<String> travelModesAsStrings() {
        return this.travelModes;
    }

    public final String key() {
        return this.key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.styleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.terrainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contourDensityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTravelModes() ? this.travelModesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStyleDescriptorRequest)) {
            return false;
        }
        GetStyleDescriptorRequest other = (GetStyleDescriptorRequest)((Object)obj);
        return Objects.equals(this.styleAsString(), other.styleAsString()) && Objects.equals(this.colorSchemeAsString(), other.colorSchemeAsString()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.terrainAsString(), other.terrainAsString()) && Objects.equals(this.contourDensityAsString(), other.contourDensityAsString()) && Objects.equals(this.trafficAsString(), other.trafficAsString()) && this.hasTravelModes() == other.hasTravelModes() && Objects.equals(this.travelModesAsStrings(), other.travelModesAsStrings()) && Objects.equals(this.key(), other.key());
    }

    public final String toString() {
        return ToString.builder((String)"GetStyleDescriptorRequest").add("Style", (Object)this.styleAsString()).add("ColorScheme", (Object)this.colorSchemeAsString()).add("PoliticalView", (Object)(this.politicalView() == null ? null : "*** Sensitive Data Redacted ***")).add("Terrain", (Object)this.terrainAsString()).add("ContourDensity", (Object)this.contourDensityAsString()).add("Traffic", (Object)this.trafficAsString()).add("TravelModes", this.hasTravelModes() ? this.travelModesAsStrings() : null).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.styleAsString()));
            }
            case "ColorScheme": {
                return Optional.ofNullable(clazz.cast(this.colorSchemeAsString()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "Terrain": {
                return Optional.ofNullable(clazz.cast(this.terrainAsString()));
            }
            case "ContourDensity": {
                return Optional.ofNullable(clazz.cast(this.contourDensityAsString()));
            }
            case "Traffic": {
                return Optional.ofNullable(clazz.cast(this.trafficAsString()));
            }
            case "TravelModes": {
                return Optional.ofNullable(clazz.cast(this.travelModesAsStrings()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Style", STYLE_FIELD);
        map.put("color-scheme", COLOR_SCHEME_FIELD);
        map.put("political-view", POLITICAL_VIEW_FIELD);
        map.put("terrain", TERRAIN_FIELD);
        map.put("contour-density", CONTOUR_DENSITY_FIELD);
        map.put("traffic", TRAFFIC_FIELD);
        map.put("travel-modes", TRAVEL_MODES_FIELD);
        map.put("key", KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStyleDescriptorRequest, T> g) {
        return obj -> g.apply((GetStyleDescriptorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoMapsRequest.BuilderImpl
    implements Builder {
        private String style;
        private String colorScheme;
        private String politicalView;
        private String terrain;
        private String contourDensity;
        private String traffic;
        private List<String> travelModes = DefaultSdkAutoConstructList.getInstance();
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStyleDescriptorRequest model) {
            super(model);
            this.style(model.style);
            this.colorScheme(model.colorScheme);
            this.politicalView(model.politicalView);
            this.terrain(model.terrain);
            this.contourDensity(model.contourDensity);
            this.traffic(model.traffic);
            this.travelModesWithStrings(model.travelModes);
            this.key(model.key);
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(MapStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public final String getColorScheme() {
            return this.colorScheme;
        }

        public final void setColorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public final Builder colorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public final Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme(colorScheme == null ? null : colorScheme.toString());
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final String getTerrain() {
            return this.terrain;
        }

        public final void setTerrain(String terrain) {
            this.terrain = terrain;
        }

        @Override
        public final Builder terrain(String terrain) {
            this.terrain = terrain;
            return this;
        }

        @Override
        public final Builder terrain(Terrain terrain) {
            this.terrain(terrain == null ? null : terrain.toString());
            return this;
        }

        public final String getContourDensity() {
            return this.contourDensity;
        }

        public final void setContourDensity(String contourDensity) {
            this.contourDensity = contourDensity;
        }

        @Override
        public final Builder contourDensity(String contourDensity) {
            this.contourDensity = contourDensity;
            return this;
        }

        @Override
        public final Builder contourDensity(ContourDensity contourDensity) {
            this.contourDensity(contourDensity == null ? null : contourDensity.toString());
            return this;
        }

        public final String getTraffic() {
            return this.traffic;
        }

        public final void setTraffic(String traffic) {
            this.traffic = traffic;
        }

        @Override
        public final Builder traffic(String traffic) {
            this.traffic = traffic;
            return this;
        }

        @Override
        public final Builder traffic(Traffic traffic) {
            this.traffic(traffic == null ? null : traffic.toString());
            return this;
        }

        public final Collection<String> getTravelModes() {
            if (this.travelModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.travelModes;
        }

        public final void setTravelModes(Collection<String> travelModes) {
            this.travelModes = TravelModeListCopier.copy(travelModes);
        }

        @Override
        public final Builder travelModesWithStrings(Collection<String> travelModes) {
            this.travelModes = TravelModeListCopier.copy(travelModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelModesWithStrings(String ... travelModes) {
            this.travelModesWithStrings(Arrays.asList(travelModes));
            return this;
        }

        @Override
        public final Builder travelModes(Collection<TravelMode> travelModes) {
            this.travelModes = TravelModeListCopier.copyEnumToString(travelModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelModes(TravelMode ... travelModes) {
            this.travelModes(Arrays.asList(travelModes));
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStyleDescriptorRequest build() {
            return new GetStyleDescriptorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoMapsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStyleDescriptorRequest> {
        public Builder style(String var1);

        public Builder style(MapStyle var1);

        public Builder colorScheme(String var1);

        public Builder colorScheme(ColorScheme var1);

        public Builder politicalView(String var1);

        public Builder terrain(String var1);

        public Builder terrain(Terrain var1);

        public Builder contourDensity(String var1);

        public Builder contourDensity(ContourDensity var1);

        public Builder traffic(String var1);

        public Builder traffic(Traffic var1);

        public Builder travelModesWithStrings(Collection<String> var1);

        public Builder travelModesWithStrings(String ... var1);

        public Builder travelModes(Collection<TravelMode> var1);

        public Builder travelModes(TravelMode ... var1);

        public Builder key(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

