/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geomaps.model.GeoMapsException;
import software.amazon.awssdk.services.geomaps.model.ValidationExceptionField;
import software.amazon.awssdk.services.geomaps.model.ValidationExceptionFieldListCopier;
import software.amazon.awssdk.services.geomaps.model.ValidationExceptionReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationException
extends GeoMapsException
implements ToCopyableBuilder<Builder, ValidationException> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(ValidationException.getter(ValidationException::reasonAsString)).setter(ValidationException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<ValidationExceptionField>> FIELD_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldList").getter(ValidationException.getter(ValidationException::fieldList)).setter(ValidationException.setter(Builder::fieldList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationExceptionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, FIELD_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("reason", REASON_FIELD);
            this.put("fieldList", FIELD_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final List<ValidationExceptionField> fieldList;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.fieldList = builder.fieldList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public boolean hasFieldList() {
        return this.fieldList != null && !(this.fieldList instanceof SdkAutoConstructList);
    }

    public List<ValidationExceptionField> fieldList() {
        return this.fieldList;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoMapsException.BuilderImpl
    implements Builder {
        private String reason;
        private List<ValidationExceptionField> fieldList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            this.reason(model.reason);
            this.fieldList(model.fieldList);
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final List<ValidationExceptionField.Builder> getFieldList() {
            List<ValidationExceptionField.Builder> result = ValidationExceptionFieldListCopier.copyToBuilder(this.fieldList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldList(Collection<ValidationExceptionField.BuilderImpl> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copyFromBuilder(fieldList);
        }

        @Override
        public final Builder fieldList(Collection<ValidationExceptionField> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copy(fieldList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(ValidationExceptionField ... fieldList) {
            this.fieldList(Arrays.asList(fieldList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(Consumer<ValidationExceptionField.Builder> ... fieldList) {
            this.fieldList(Stream.of(fieldList).map(c -> (ValidationExceptionField)((ValidationExceptionField.Builder)ValidationExceptionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationException>,
    GeoMapsException.Builder {
        public Builder reason(String var1);

        public Builder reason(ValidationExceptionReason var1);

        public Builder fieldList(Collection<ValidationExceptionField> var1);

        public Builder fieldList(ValidationExceptionField ... var1);

        public Builder fieldList(Consumer<ValidationExceptionField.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

