/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geomaps;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.geomaps.DefaultGeoMapsClientBuilder;
import software.amazon.awssdk.services.geomaps.GeoMapsClientBuilder;
import software.amazon.awssdk.services.geomaps.GeoMapsServiceClientConfiguration;
import software.amazon.awssdk.services.geomaps.model.AccessDeniedException;
import software.amazon.awssdk.services.geomaps.model.GeoMapsException;
import software.amazon.awssdk.services.geomaps.model.GetGlyphsRequest;
import software.amazon.awssdk.services.geomaps.model.GetGlyphsResponse;
import software.amazon.awssdk.services.geomaps.model.GetSpritesRequest;
import software.amazon.awssdk.services.geomaps.model.GetSpritesResponse;
import software.amazon.awssdk.services.geomaps.model.GetStaticMapRequest;
import software.amazon.awssdk.services.geomaps.model.GetStaticMapResponse;
import software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorRequest;
import software.amazon.awssdk.services.geomaps.model.GetStyleDescriptorResponse;
import software.amazon.awssdk.services.geomaps.model.GetTileRequest;
import software.amazon.awssdk.services.geomaps.model.GetTileResponse;
import software.amazon.awssdk.services.geomaps.model.InternalServerException;
import software.amazon.awssdk.services.geomaps.model.ThrottlingException;
import software.amazon.awssdk.services.geomaps.model.ValidationException;

@SdkPublicApi
@ThreadSafe
public interface GeoMapsClient
extends AwsClient {
    public static final String SERVICE_NAME = "geo-maps";
    public static final String SERVICE_METADATA_ID = "geo-maps";

    default public GetGlyphsResponse getGlyphs(GetGlyphsRequest getGlyphsRequest) throws AwsServiceException, SdkClientException, GeoMapsException {
        throw new UnsupportedOperationException();
    }

    default public GetGlyphsResponse getGlyphs(Consumer<GetGlyphsRequest.Builder> getGlyphsRequest) throws AwsServiceException, SdkClientException, GeoMapsException {
        return this.getGlyphs((GetGlyphsRequest)((Object)((GetGlyphsRequest.Builder)GetGlyphsRequest.builder().applyMutation(getGlyphsRequest)).build()));
    }

    default public GetSpritesResponse getSprites(GetSpritesRequest getSpritesRequest) throws AwsServiceException, SdkClientException, GeoMapsException {
        throw new UnsupportedOperationException();
    }

    default public GetSpritesResponse getSprites(Consumer<GetSpritesRequest.Builder> getSpritesRequest) throws AwsServiceException, SdkClientException, GeoMapsException {
        return this.getSprites((GetSpritesRequest)((Object)((GetSpritesRequest.Builder)GetSpritesRequest.builder().applyMutation(getSpritesRequest)).build()));
    }

    default public GetStaticMapResponse getStaticMap(GetStaticMapRequest getStaticMapRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoMapsException {
        throw new UnsupportedOperationException();
    }

    default public GetStaticMapResponse getStaticMap(Consumer<GetStaticMapRequest.Builder> getStaticMapRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoMapsException {
        return this.getStaticMap((GetStaticMapRequest)((Object)((GetStaticMapRequest.Builder)GetStaticMapRequest.builder().applyMutation(getStaticMapRequest)).build()));
    }

    default public GetStyleDescriptorResponse getStyleDescriptor(GetStyleDescriptorRequest getStyleDescriptorRequest) throws AwsServiceException, SdkClientException, GeoMapsException {
        throw new UnsupportedOperationException();
    }

    default public GetStyleDescriptorResponse getStyleDescriptor(Consumer<GetStyleDescriptorRequest.Builder> getStyleDescriptorRequest) throws AwsServiceException, SdkClientException, GeoMapsException {
        return this.getStyleDescriptor((GetStyleDescriptorRequest)((Object)((GetStyleDescriptorRequest.Builder)GetStyleDescriptorRequest.builder().applyMutation(getStyleDescriptorRequest)).build()));
    }

    default public GetTileResponse getTile(GetTileRequest getTileRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoMapsException {
        throw new UnsupportedOperationException();
    }

    default public GetTileResponse getTile(Consumer<GetTileRequest.Builder> getTileRequest) throws InternalServerException, AccessDeniedException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, GeoMapsException {
        return this.getTile((GetTileRequest)((Object)((GetTileRequest.Builder)GetTileRequest.builder().applyMutation(getTileRequest)).build()));
    }

    public static GeoMapsClient create() {
        return (GeoMapsClient)GeoMapsClient.builder().build();
    }

    public static GeoMapsClientBuilder builder() {
        return new DefaultGeoMapsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"geo-maps");
    }

    default public GeoMapsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

