/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportStreamSessionFilesRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, ExportStreamSessionFilesRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(ExportStreamSessionFilesRequest.getter(ExportStreamSessionFilesRequest::identifier)).setter(ExportStreamSessionFilesRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> STREAM_SESSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamSessionIdentifier").getter(ExportStreamSessionFilesRequest.getter(ExportStreamSessionFilesRequest::streamSessionIdentifier)).setter(ExportStreamSessionFilesRequest.setter(Builder::streamSessionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("StreamSessionIdentifier").build()}).build();
    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputUri").getter(ExportStreamSessionFilesRequest.getter(ExportStreamSessionFilesRequest::outputUri)).setter(ExportStreamSessionFilesRequest.setter(Builder::outputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, STREAM_SESSION_IDENTIFIER_FIELD, OUTPUT_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportStreamSessionFilesRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String streamSessionIdentifier;
    private final String outputUri;

    private ExportStreamSessionFilesRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.streamSessionIdentifier = builder.streamSessionIdentifier;
        this.outputUri = builder.outputUri;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String streamSessionIdentifier() {
        return this.streamSessionIdentifier;
    }

    public final String outputUri() {
        return this.outputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSessionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStreamSessionFilesRequest)) {
            return false;
        }
        ExportStreamSessionFilesRequest other = (ExportStreamSessionFilesRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.streamSessionIdentifier(), other.streamSessionIdentifier()) && Objects.equals(this.outputUri(), other.outputUri());
    }

    public final String toString() {
        return ToString.builder((String)"ExportStreamSessionFilesRequest").add("Identifier", (Object)this.identifier()).add("StreamSessionIdentifier", (Object)this.streamSessionIdentifier()).add("OutputUri", (Object)this.outputUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "StreamSessionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.streamSessionIdentifier()));
            }
            case "OutputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("StreamSessionIdentifier", STREAM_SESSION_IDENTIFIER_FIELD);
        map.put("OutputUri", OUTPUT_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportStreamSessionFilesRequest, T> g) {
        return obj -> g.apply((ExportStreamSessionFilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String streamSessionIdentifier;
        private String outputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStreamSessionFilesRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.streamSessionIdentifier(model.streamSessionIdentifier);
            this.outputUri(model.outputUri);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getStreamSessionIdentifier() {
            return this.streamSessionIdentifier;
        }

        public final void setStreamSessionIdentifier(String streamSessionIdentifier) {
            this.streamSessionIdentifier = streamSessionIdentifier;
        }

        @Override
        public final Builder streamSessionIdentifier(String streamSessionIdentifier) {
            this.streamSessionIdentifier = streamSessionIdentifier;
            return this;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportStreamSessionFilesRequest build() {
            return new ExportStreamSessionFilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportStreamSessionFilesRequest> {
        public Builder identifier(String var1);

        public Builder streamSessionIdentifier(String var1);

        public Builder outputUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

