/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gameliftstreams.GameLiftStreamsAsyncClient;
import software.amazon.awssdk.services.gameliftstreams.internal.UserAgentUtils;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.StreamGroupSummary;

public class ListStreamGroupsPublisher
implements SdkPublisher<ListStreamGroupsResponse> {
    private final GameLiftStreamsAsyncClient client;
    private final ListStreamGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamGroupsPublisher(GameLiftStreamsAsyncClient client, ListStreamGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamGroupsPublisher(GameLiftStreamsAsyncClient client, ListStreamGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamGroupSummary> items() {
        Function<ListStreamGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamGroupsResponseFetcher
    implements AsyncPageFetcher<ListStreamGroupsResponse> {
        private ListStreamGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamGroupsResponse> nextPage(ListStreamGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamGroupsPublisher.this.client.listStreamGroups(ListStreamGroupsPublisher.this.firstRequest);
            }
            return ListStreamGroupsPublisher.this.client.listStreamGroups((ListStreamGroupsRequest)((Object)ListStreamGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

