/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gameliftstreams.GameLiftStreamsClient;
import software.amazon.awssdk.services.gameliftstreams.internal.UserAgentUtils;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.StreamSessionSummary;

public class ListStreamSessionsIterable
implements SdkIterable<ListStreamSessionsResponse> {
    private final GameLiftStreamsClient client;
    private final ListStreamSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamSessionsIterable(GameLiftStreamsClient client, ListStreamSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamSessionsResponseFetcher();
    }

    public Iterator<ListStreamSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamSessionSummary> items() {
        Function<ListStreamSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamSessionsResponseFetcher
    implements SyncPageFetcher<ListStreamSessionsResponse> {
        private ListStreamSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamSessionsResponse nextPage(ListStreamSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamSessionsIterable.this.client.listStreamSessions(ListStreamSessionsIterable.this.firstRequest);
            }
            return ListStreamSessionsIterable.this.client.listStreamSessions((ListStreamSessionsRequest)((Object)ListStreamSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

