/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.LocationConfiguration;
import software.amazon.awssdk.services.gameliftstreams.model.LocationConfigurationsCopier;
import software.amazon.awssdk.services.gameliftstreams.model.StreamClass;
import software.amazon.awssdk.services.gameliftstreams.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamGroupRequest
extends GameLiftStreamsRequest
implements ToCopyableBuilder<Builder, CreateStreamGroupRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateStreamGroupRequest.getter(CreateStreamGroupRequest::clientToken)).setter(CreateStreamGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEFAULT_APPLICATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultApplicationIdentifier").getter(CreateStreamGroupRequest.getter(CreateStreamGroupRequest::defaultApplicationIdentifier)).setter(CreateStreamGroupRequest.setter(Builder::defaultApplicationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultApplicationIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateStreamGroupRequest.getter(CreateStreamGroupRequest::description)).setter(CreateStreamGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<LocationConfiguration>> LOCATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationConfigurations").getter(CreateStreamGroupRequest.getter(CreateStreamGroupRequest::locationConfigurations)).setter(CreateStreamGroupRequest.setter(Builder::locationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STREAM_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamClass").getter(CreateStreamGroupRequest.getter(CreateStreamGroupRequest::streamClassAsString)).setter(CreateStreamGroupRequest.setter(Builder::streamClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamClass").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateStreamGroupRequest.getter(CreateStreamGroupRequest::tags)).setter(CreateStreamGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DEFAULT_APPLICATION_IDENTIFIER_FIELD, DESCRIPTION_FIELD, LOCATION_CONFIGURATIONS_FIELD, STREAM_CLASS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStreamGroupRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String defaultApplicationIdentifier;
    private final String description;
    private final List<LocationConfiguration> locationConfigurations;
    private final String streamClass;
    private final Map<String, String> tags;

    private CreateStreamGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.defaultApplicationIdentifier = builder.defaultApplicationIdentifier;
        this.description = builder.description;
        this.locationConfigurations = builder.locationConfigurations;
        this.streamClass = builder.streamClass;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String defaultApplicationIdentifier() {
        return this.defaultApplicationIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasLocationConfigurations() {
        return this.locationConfigurations != null && !(this.locationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LocationConfiguration> locationConfigurations() {
        return this.locationConfigurations;
    }

    public final StreamClass streamClass() {
        return StreamClass.fromValue(this.streamClass);
    }

    public final String streamClassAsString() {
        return this.streamClass;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultApplicationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationConfigurations() ? this.locationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamGroupRequest)) {
            return false;
        }
        CreateStreamGroupRequest other = (CreateStreamGroupRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.defaultApplicationIdentifier(), other.defaultApplicationIdentifier()) && Objects.equals(this.description(), other.description()) && this.hasLocationConfigurations() == other.hasLocationConfigurations() && Objects.equals(this.locationConfigurations(), other.locationConfigurations()) && Objects.equals(this.streamClassAsString(), other.streamClassAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamGroupRequest").add("ClientToken", (Object)this.clientToken()).add("DefaultApplicationIdentifier", (Object)this.defaultApplicationIdentifier()).add("Description", (Object)this.description()).add("LocationConfigurations", this.hasLocationConfigurations() ? this.locationConfigurations() : null).add("StreamClass", (Object)this.streamClassAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DefaultApplicationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.defaultApplicationIdentifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LocationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.locationConfigurations()));
            }
            case "StreamClass": {
                return Optional.ofNullable(clazz.cast(this.streamClassAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DefaultApplicationIdentifier", DEFAULT_APPLICATION_IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LocationConfigurations", LOCATION_CONFIGURATIONS_FIELD);
        map.put("StreamClass", STREAM_CLASS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamGroupRequest, T> g) {
        return obj -> g.apply((CreateStreamGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftStreamsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String defaultApplicationIdentifier;
        private String description;
        private List<LocationConfiguration> locationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String streamClass;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamGroupRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.defaultApplicationIdentifier(model.defaultApplicationIdentifier);
            this.description(model.description);
            this.locationConfigurations(model.locationConfigurations);
            this.streamClass(model.streamClass);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDefaultApplicationIdentifier() {
            return this.defaultApplicationIdentifier;
        }

        public final void setDefaultApplicationIdentifier(String defaultApplicationIdentifier) {
            this.defaultApplicationIdentifier = defaultApplicationIdentifier;
        }

        @Override
        public final Builder defaultApplicationIdentifier(String defaultApplicationIdentifier) {
            this.defaultApplicationIdentifier = defaultApplicationIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocationConfigurations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationsCopier.copyToBuilder(this.locationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationConfigurations(Collection<LocationConfiguration.BuilderImpl> locationConfigurations) {
            this.locationConfigurations = LocationConfigurationsCopier.copyFromBuilder(locationConfigurations);
        }

        @Override
        public final Builder locationConfigurations(Collection<LocationConfiguration> locationConfigurations) {
            this.locationConfigurations = LocationConfigurationsCopier.copy(locationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationConfigurations(LocationConfiguration ... locationConfigurations) {
            this.locationConfigurations(Arrays.asList(locationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationConfigurations(Consumer<LocationConfiguration.Builder> ... locationConfigurations) {
            this.locationConfigurations(Stream.of(locationConfigurations).map(c -> (LocationConfiguration)((LocationConfiguration.Builder)LocationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStreamClass() {
            return this.streamClass;
        }

        public final void setStreamClass(String streamClass) {
            this.streamClass = streamClass;
        }

        @Override
        public final Builder streamClass(String streamClass) {
            this.streamClass = streamClass;
            return this;
        }

        @Override
        public final Builder streamClass(StreamClass streamClass) {
            this.streamClass(streamClass == null ? null : streamClass.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamGroupRequest build() {
            return new CreateStreamGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamGroupRequest> {
        public Builder clientToken(String var1);

        public Builder defaultApplicationIdentifier(String var1);

        public Builder description(String var1);

        public Builder locationConfigurations(Collection<LocationConfiguration> var1);

        public Builder locationConfigurations(LocationConfiguration ... var1);

        public Builder locationConfigurations(Consumer<LocationConfiguration.Builder> ... var1);

        public Builder streamClass(String var1);

        public Builder streamClass(StreamClass var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

