/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGameSessionRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateGameSessionRequest.Builder, UpdateGameSessionRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(UpdateGameSessionRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount")
            .getter(getter(UpdateGameSessionRequest::maximumPlayerSessionCount))
            .setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateGameSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PLAYER_SESSION_CREATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlayerSessionCreationPolicy")
            .getter(getter(UpdateGameSessionRequest::playerSessionCreationPolicyAsString))
            .setter(setter(Builder::playerSessionCreationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionCreationPolicy")
                    .build()).build();

    private static final SdkField<String> PROTECTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectionPolicy").getter(getter(UpdateGameSessionRequest::protectionPolicyAsString))
            .setter(setter(Builder::protectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionPolicy").build()).build();

    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField
            .<List<GameProperty>> builder(MarshallingType.LIST)
            .memberName("GameProperties")
            .getter(getter(UpdateGameSessionRequest::gameProperties))
            .setter(setter(Builder::gameProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD,
            MAXIMUM_PLAYER_SESSION_COUNT_FIELD, NAME_FIELD, PLAYER_SESSION_CREATION_POLICY_FIELD, PROTECTION_POLICY_FIELD,
            GAME_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gameSessionId;

    private final Integer maximumPlayerSessionCount;

    private final String name;

    private final String playerSessionCreationPolicy;

    private final String protectionPolicy;

    private final List<GameProperty> gameProperties;

    private UpdateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.protectionPolicy = builder.protectionPolicy;
        this.gameProperties = builder.gameProperties;
    }

    /**
     * <p>
     * A unique identifier for the game session to update.
     * </p>
     * 
     * @return A unique identifier for the game session to update.
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * The maximum number of players that can be connected simultaneously to the game session.
     * </p>
     * 
     * @return The maximum number of players that can be connected simultaneously to the game session.
     */
    public final Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    /**
     * <p>
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A policy that determines whether the game session is accepting new players.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #playerSessionCreationPolicy} will return {@link PlayerSessionCreationPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #playerSessionCreationPolicyAsString}.
     * </p>
     * 
     * @return A policy that determines whether the game session is accepting new players.
     * @see PlayerSessionCreationPolicy
     */
    public final PlayerSessionCreationPolicy playerSessionCreationPolicy() {
        return PlayerSessionCreationPolicy.fromValue(playerSessionCreationPolicy);
    }

    /**
     * <p>
     * A policy that determines whether the game session is accepting new players.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #playerSessionCreationPolicy} will return {@link PlayerSessionCreationPolicy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #playerSessionCreationPolicyAsString}.
     * </p>
     * 
     * @return A policy that determines whether the game session is accepting new players.
     * @see PlayerSessionCreationPolicy
     */
    public final String playerSessionCreationPolicyAsString() {
        return playerSessionCreationPolicy;
    }

    /**
     * <p>
     * Game session protection policy to apply to this game session only.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     * during a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protectionPolicy}
     * will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protectionPolicyAsString}.
     * </p>
     * 
     * @return Game session protection policy to apply to this game session only.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
     *         terminated during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(protectionPolicy);
    }

    /**
     * <p>
     * Game session protection policy to apply to this game session only.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     * during a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protectionPolicy}
     * will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protectionPolicyAsString}.
     * </p>
     * 
     * @return Game session protection policy to apply to this game session only.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
     *         terminated during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final String protectionPolicyAsString() {
        return protectionPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the GameProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGameProperties() {
        return gameProperties != null && !(gameProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of key-value pairs that can store custom data in a game session. For example:
     * <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game properties in an
     * active game session. This action adds new properties and modifies existing properties. There is no way to delete
     * properties. For an example, see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
     * >Update the value of a game property</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGameProperties} method.
     * </p>
     * 
     * @return A set of key-value pairs that can store custom data in a game session. For example:
     *         <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game
     *         properties in an active game session. This action adds new properties and modifies existing properties.
     *         There is no way to delete properties. For an example, see <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
     *         >Update the value of a game property</a>.
     */
    public final List<GameProperty> gameProperties() {
        return gameProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playerSessionCreationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasGameProperties() ? gameProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionRequest)) {
            return false;
        }
        UpdateGameSessionRequest other = (UpdateGameSessionRequest) obj;
        return Objects.equals(gameSessionId(), other.gameSessionId())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount())
                && Objects.equals(name(), other.name())
                && Objects.equals(playerSessionCreationPolicyAsString(), other.playerSessionCreationPolicyAsString())
                && Objects.equals(protectionPolicyAsString(), other.protectionPolicyAsString())
                && hasGameProperties() == other.hasGameProperties() && Objects.equals(gameProperties(), other.gameProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGameSessionRequest").add("GameSessionId", gameSessionId())
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).add("Name", name())
                .add("PlayerSessionCreationPolicy", playerSessionCreationPolicyAsString())
                .add("ProtectionPolicy", protectionPolicyAsString())
                .add("GameProperties", hasGameProperties() ? gameProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PlayerSessionCreationPolicy":
            return Optional.ofNullable(clazz.cast(playerSessionCreationPolicyAsString()));
        case "ProtectionPolicy":
            return Optional.ofNullable(clazz.cast(protectionPolicyAsString()));
        case "GameProperties":
            return Optional.ofNullable(clazz.cast(gameProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameSessionId", GAME_SESSION_ID_FIELD);
        map.put("MaximumPlayerSessionCount", MAXIMUM_PLAYER_SESSION_COUNT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PlayerSessionCreationPolicy", PLAYER_SESSION_CREATION_POLICY_FIELD);
        map.put("ProtectionPolicy", PROTECTION_POLICY_FIELD);
        map.put("GameProperties", GAME_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameSessionRequest, T> g) {
        return obj -> g.apply((UpdateGameSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGameSessionRequest> {
        /**
         * <p>
         * A unique identifier for the game session to update.
         * </p>
         * 
         * @param gameSessionId
         *        A unique identifier for the game session to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * The maximum number of players that can be connected simultaneously to the game session.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        The maximum number of players that can be connected simultaneously to the game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);

        /**
         * <p>
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a game session. Session names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A policy that determines whether the game session is accepting new players.
         * </p>
         * 
         * @param playerSessionCreationPolicy
         *        A policy that determines whether the game session is accepting new players.
         * @see PlayerSessionCreationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlayerSessionCreationPolicy
         */
        Builder playerSessionCreationPolicy(String playerSessionCreationPolicy);

        /**
         * <p>
         * A policy that determines whether the game session is accepting new players.
         * </p>
         * 
         * @param playerSessionCreationPolicy
         *        A policy that determines whether the game session is accepting new players.
         * @see PlayerSessionCreationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlayerSessionCreationPolicy
         */
        Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy);

        /**
         * <p>
         * Game session protection policy to apply to this game session only.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         * terminated during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protectionPolicy
         *        Game session protection policy to apply to this game session only.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder protectionPolicy(String protectionPolicy);

        /**
         * <p>
         * Game session protection policy to apply to this game session only.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         * terminated during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protectionPolicy
         *        Game session protection policy to apply to this game session only.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NoProtection</code> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FullProtection</code> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder protectionPolicy(ProtectionPolicy protectionPolicy);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game properties
         * in an active game session. This action adds new properties and modifies existing properties. There is no way
         * to delete properties. For an example, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
         * >Update the value of a game property</a>.
         * </p>
         * 
         * @param gameProperties
         *        A set of key-value pairs that can store custom data in a game session. For example:
         *        <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game
         *        properties in an active game session. This action adds new properties and modifies existing
         *        properties. There is no way to delete properties. For an example, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
         *        >Update the value of a game property</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(Collection<GameProperty> gameProperties);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game properties
         * in an active game session. This action adds new properties and modifies existing properties. There is no way
         * to delete properties. For an example, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
         * >Update the value of a game property</a>.
         * </p>
         * 
         * @param gameProperties
         *        A set of key-value pairs that can store custom data in a game session. For example:
         *        <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game
         *        properties in an active game session. This action adds new properties and modifies existing
         *        properties. There is no way to delete properties. For an example, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
         *        >Update the value of a game property</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(GameProperty... gameProperties);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. You can use this parameter to modify game properties
         * in an active game session. This action adds new properties and modifies existing properties. There is no way
         * to delete properties. For an example, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-update"
         * >Update the value of a game property</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.GameProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #gameProperties(List<GameProperty>)}.
         * 
         * @param gameProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameProperties(java.util.Collection<GameProperty>)
         */
        Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameSessionId;

        private Integer maximumPlayerSessionCount;

        private String name;

        private String playerSessionCreationPolicy;

        private String protectionPolicy;

        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionRequest model) {
            super(model);
            gameSessionId(model.gameSessionId);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            name(model.name);
            playerSessionCreationPolicy(model.playerSessionCreationPolicy);
            protectionPolicy(model.protectionPolicy);
            gameProperties(model.gameProperties);
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlayerSessionCreationPolicy() {
            return playerSessionCreationPolicy;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy == null ? null : playerSessionCreationPolicy.toString());
            return this;
        }

        public final String getProtectionPolicy() {
            return protectionPolicy;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy == null ? null : protectionPolicy.toString());
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty... gameProperties) {
            gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties) {
            gameProperties(Stream.of(gameProperties).map(c -> GameProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameSessionRequest build() {
            return new UpdateGameSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
