/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchGameSessionsRequest extends GameLiftRequest implements
        ToCopyableBuilder<SearchGameSessionsRequest.Builder, SearchGameSessionsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(SearchGameSessionsRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(SearchGameSessionsRequest::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(SearchGameSessionsRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterExpression").getter(getter(SearchGameSessionsRequest::filterExpression))
            .setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<String> SORT_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortExpression").getter(getter(SearchGameSessionsRequest::sortExpression))
            .setter(setter(Builder::sortExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortExpression").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(SearchGameSessionsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchGameSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            ALIAS_ID_FIELD, LOCATION_FIELD, FILTER_EXPRESSION_FIELD, SORT_EXPRESSION_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final String aliasId;

    private final String location;

    private final String filterExpression;

    private final String sortExpression;

    private final Integer limit;

    private final String nextToken;

    private SearchGameSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.location = builder.location;
        this.filterExpression = builder.filterExpression;
        this.sortExpression = builder.sortExpression;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN
     * value. Each request must reference either a fleet ID or alias ID, but not both.
     * </p>
     * 
     * @return A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or
     *         ARN value. Each request must reference either a fleet ID or alias ID, but not both.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A unique identifier for the alias associated with the fleet to search for active game sessions. You can use
     * either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
     * </p>
     * 
     * @return A unique identifier for the alias associated with the fleet to search for active game sessions. You can
     *         use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not
     *         both.
     */
    public final String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * A fleet location to search for game sessions. You can specify a fleet's home Region or a remote location. Use the
     * Amazon Web Services Region code format, such as <code>us-west-2</code>.
     * </p>
     * 
     * @return A fleet location to search for game sessions. You can specify a fleet's home Region or a remote location.
     *         Use the Amazon Web Services Region code format, such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * String containing the search criteria for the session search. If no filter expression is included, the request
     * returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * A filter expression can contain one or multiple conditions. Each condition consists of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
     * <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
     * <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>,
     * <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings depending
     * on the operand. String values are case sensitive and must be enclosed in single quotes. Special characters must
     * be escaped. Boolean and string values can only be used with the comparators <code>=</code> and
     * <code>&lt;&gt;</code>. For example, the following filter expression searches on <code>gameSessionName</code>: "
     * <code>FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'"</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>, <code>OR</code>,
     * and <code>NOT</code> and parentheses as needed. For example: <code>x AND y AND NOT z</code>,
     * <code>NOT (x OR y)</code>.
     * </p>
     * <p>
     * Session search evaluates conditions from left to right using the following precedence rules:
     * </p>
     * <ol>
     * <li>
     * <p>
     * <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>,
     * <code>&gt;=</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Parentheses
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT
     * </p>
     * </li>
     * <li>
     * <p>
     * AND
     * </p>
     * </li>
     * <li>
     * <p>
     * OR
     * </p>
     * </li>
     * </ol>
     * <p>
     * For example, this filter expression retrieves game sessions hosting at least ten players that have an open player
     * slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>.
     * </p>
     * 
     * @return String containing the search criteria for the session search. If no filter expression is included, the
     *         request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.</p>
     *         <p>
     *         A filter expression can contain one or multiple conditions. Each condition consists of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
     *         <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
     *         <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>,
     *         <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings
     *         depending on the operand. String values are case sensitive and must be enclosed in single quotes. Special
     *         characters must be escaped. Boolean and string values can only be used with the comparators
     *         <code>=</code> and <code>&lt;&gt;</code>. For example, the following filter expression searches on
     *         <code>gameSessionName</code>: "
     *         <code>FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'"</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>,
     *         <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example:
     *         <code>x AND y AND NOT z</code>, <code>NOT (x OR y)</code>.
     *         </p>
     *         <p>
     *         Session search evaluates conditions from left to right using the following precedence rules:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>,
     *         <code>&gt;=</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Parentheses
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OR
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         For example, this filter expression retrieves game sessions hosting at least ten players that have an
     *         open player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * Instructions on how to sort the search results. If no sort expression is included, the request returns results in
     * random order. A sort expression consists of the following elements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
     * <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
     * <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, this sort expression returns the oldest active sessions first:
     * <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand are
     * returned at the end of the list.
     * </p>
     * 
     * @return Instructions on how to sort the search results. If no sort expression is included, the request returns
     *         results in random order. A sort expression consists of the following elements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
     *         <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
     *         <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, this sort expression returns the oldest active sessions first:
     *         <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand
     *         are returned at the end of the list.
     */
    public final String sortExpression() {
        return sortExpression;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages. The maximum number of results returned is 20, even if this value is not set or is set higher
     * than 20.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages. The maximum number of results returned is 20, even if this value is not set or
     *         is set higher than 20.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(sortExpression());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGameSessionsRequest)) {
            return false;
        }
        SearchGameSessionsRequest other = (SearchGameSessionsRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(aliasId(), other.aliasId())
                && Objects.equals(location(), other.location()) && Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(sortExpression(), other.sortExpression()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchGameSessionsRequest").add("FleetId", fleetId()).add("AliasId", aliasId())
                .add("Location", location()).add("FilterExpression", filterExpression()).add("SortExpression", sortExpression())
                .add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "SortExpression":
            return Optional.ofNullable(clazz.cast(sortExpression()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("AliasId", ALIAS_ID_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("FilterExpression", FILTER_EXPRESSION_FIELD);
        map.put("SortExpression", SORT_EXPRESSION_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchGameSessionsRequest, T> g) {
        return obj -> g.apply((SearchGameSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchGameSessionsRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID or ARN
         * value. Each request must reference either a fleet ID or alias ID, but not both.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to search for active game sessions. You can use either the fleet ID
         *        or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A unique identifier for the alias associated with the fleet to search for active game sessions. You can use
         * either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
         * </p>
         * 
         * @param aliasId
         *        A unique identifier for the alias associated with the fleet to search for active game sessions. You
         *        can use either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID,
         *        but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * A fleet location to search for game sessions. You can specify a fleet's home Region or a remote location. Use
         * the Amazon Web Services Region code format, such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        A fleet location to search for game sessions. You can specify a fleet's home Region or a remote
         *        location. Use the Amazon Web Services Region code format, such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * String containing the search criteria for the session search. If no filter expression is included, the
         * request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.
         * </p>
         * <p>
         * A filter expression can contain one or multiple conditions. Each condition consists of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
         * <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
         * <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>,
         * <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or strings
         * depending on the operand. String values are case sensitive and must be enclosed in single quotes. Special
         * characters must be escaped. Boolean and string values can only be used with the comparators <code>=</code>
         * and <code>&lt;&gt;</code>. For example, the following filter expression searches on
         * <code>gameSessionName</code>: "<code>FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'"</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>,
         * <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example: <code>x AND y AND NOT z</code>,
         * <code>NOT (x OR y)</code>.
         * </p>
         * <p>
         * Session search evaluates conditions from left to right using the following precedence rules:
         * </p>
         * <ol>
         * <li>
         * <p>
         * <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>,
         * <code>&gt;=</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Parentheses
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT
         * </p>
         * </li>
         * <li>
         * <p>
         * AND
         * </p>
         * </li>
         * <li>
         * <p>
         * OR
         * </p>
         * </li>
         * </ol>
         * <p>
         * For example, this filter expression retrieves game sessions hosting at least ten players that have an open
         * player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>.
         * </p>
         * 
         * @param filterExpression
         *        String containing the search criteria for the session search. If no filter expression is included, the
         *        request returns results for all game sessions in the fleet that are in <code>ACTIVE</code> status.</p>
         *        <p>
         *        A filter expression can contain one or multiple conditions. Each condition consists of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
         *        <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
         *        <code>creationTimeMillis</code>, <code>playerSessionCount</code>,
         *        <code>hasAvailablePlayerSessions</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Comparator</b> -- Valid comparators are: <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>,
         *        <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Value</b> -- Value to be searched for. Values may be numbers, boolean values (true/false) or
         *        strings depending on the operand. String values are case sensitive and must be enclosed in single
         *        quotes. Special characters must be escaped. Boolean and string values can only be used with the
         *        comparators <code>=</code> and <code>&lt;&gt;</code>. For example, the following filter expression
         *        searches on <code>gameSessionName</code>: "
         *        <code>FilterExpression": "gameSessionName = 'Matt\\'s Awesome Game 1'"</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To chain multiple conditions in a single expression, use the logical keywords <code>AND</code>,
         *        <code>OR</code>, and <code>NOT</code> and parentheses as needed. For example:
         *        <code>x AND y AND NOT z</code>, <code>NOT (x OR y)</code>.
         *        </p>
         *        <p>
         *        Session search evaluates conditions from left to right using the following precedence rules:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        <code>=</code>, <code>&lt;&gt;</code>, <code>&lt;</code>, <code>&gt;</code>, <code>&lt;=</code>,
         *        <code>&gt;=</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Parentheses
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OR
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        For example, this filter expression retrieves game sessions hosting at least ten players that have an
         *        open player slot: <code>"maximumSessions&gt;=10 AND hasAvailablePlayerSessions=true"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * Instructions on how to sort the search results. If no sort expression is included, the request returns
         * results in random order. A sort expression consists of the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
         * <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
         * <code>creationTimeMillis</code>, <code>playerSessionCount</code>, <code>hasAvailablePlayerSessions</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, this sort expression returns the oldest active sessions first:
         * <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort operand are
         * returned at the end of the list.
         * </p>
         * 
         * @param sortExpression
         *        Instructions on how to sort the search results. If no sort expression is included, the request returns
         *        results in random order. A sort expression consists of the following elements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Operand</b> -- Name of a game session attribute. Valid values are <code>gameSessionName</code>,
         *        <code>gameSessionId</code>, <code>gameSessionProperties</code>, <code>maximumSessions</code>,
         *        <code>creationTimeMillis</code>, <code>playerSessionCount</code>,
         *        <code>hasAvailablePlayerSessions</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Order</b> -- Valid sort orders are <code>ASC</code> (ascending) and <code>DESC</code> (descending).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, this sort expression returns the oldest active sessions first:
         *        <code>"SortExpression": "creationTimeMillis ASC"</code>. Results with a null value for the sort
         *        operand are returned at the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortExpression(String sortExpression);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages. The maximum number of results returned is 20, even if this value is not set or is
         * set higher than 20.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages. The maximum number of results returned is 20, even if this value is not
         *        set or is set higher than 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with
         * a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential page of results. Use the token that is
         *        returned with a previous call to this operation. To start at the beginning of the result set, do not
         *        specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String aliasId;

        private String location;

        private String filterExpression;

        private String sortExpression;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGameSessionsRequest model) {
            super(model);
            fleetId(model.fleetId);
            aliasId(model.aliasId);
            location(model.location);
            filterExpression(model.filterExpression);
            sortExpression(model.sortExpression);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getAliasId() {
            return aliasId;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final String getSortExpression() {
            return sortExpression;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        @Override
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchGameSessionsRequest build() {
            return new SearchGameSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
