/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of a location, which can include its name, ARN (for custom locations), and ping beacon information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocationModel implements SdkPojo, Serializable, ToCopyableBuilder<LocationModel.Builder, LocationModel> {
    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationName").getter(getter(LocationModel::locationName)).setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationName").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(LocationModel::locationArn)).setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<PingBeacon> PING_BEACON_FIELD = SdkField.<PingBeacon> builder(MarshallingType.SDK_POJO)
            .memberName("PingBeacon").getter(getter(LocationModel::pingBeacon)).setter(setter(Builder::pingBeacon))
            .constructor(PingBeacon::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingBeacon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_NAME_FIELD,
            LOCATION_ARN_FIELD, PING_BEACON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String locationName;

    private final String locationArn;

    private final PingBeacon pingBeacon;

    private LocationModel(BuilderImpl builder) {
        this.locationName = builder.locationName;
        this.locationArn = builder.locationArn;
        this.pingBeacon = builder.pingBeacon;
    }

    /**
     * <p>
     * The location's name.
     * </p>
     * 
     * @return The location's name.
     */
    public final String locationName() {
        return locationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a custom location resource and uniquely identifies it. ARNs are unique across all Regions.
     * Format is <code>arn:aws:gamelift:&lt;region&gt;::location/location-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         custom location resource and uniquely identifies it. ARNs are unique across all Regions. Format is
     *         <code>arn:aws:gamelift:&lt;region&gt;::location/location-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Information about the UDP ping beacon for this location.
     * </p>
     * 
     * @return Information about the UDP ping beacon for this location.
     */
    public final PingBeacon pingBeacon() {
        return pingBeacon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(pingBeacon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationModel)) {
            return false;
        }
        LocationModel other = (LocationModel) obj;
        return Objects.equals(locationName(), other.locationName()) && Objects.equals(locationArn(), other.locationArn())
                && Objects.equals(pingBeacon(), other.pingBeacon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LocationModel").add("LocationName", locationName()).add("LocationArn", locationArn())
                .add("PingBeacon", pingBeacon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "PingBeacon":
            return Optional.ofNullable(clazz.cast(pingBeacon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationName", LOCATION_NAME_FIELD);
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("PingBeacon", PING_BEACON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LocationModel, T> g) {
        return obj -> g.apply((LocationModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocationModel> {
        /**
         * <p>
         * The location's name.
         * </p>
         * 
         * @param locationName
         *        The location's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * custom location resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         * <code>arn:aws:gamelift:&lt;region&gt;::location/location-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a custom location resource and uniquely identifies it. ARNs are unique across all Regions. Format is
         *        <code>arn:aws:gamelift:&lt;region&gt;::location/location-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Information about the UDP ping beacon for this location.
         * </p>
         * 
         * @param pingBeacon
         *        Information about the UDP ping beacon for this location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pingBeacon(PingBeacon pingBeacon);

        /**
         * <p>
         * Information about the UDP ping beacon for this location.
         * </p>
         * This is a convenience method that creates an instance of the {@link PingBeacon.Builder} avoiding the need to
         * create one manually via {@link PingBeacon#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PingBeacon.Builder#build()} is called immediately and its result
         * is passed to {@link #pingBeacon(PingBeacon)}.
         * 
         * @param pingBeacon
         *        a consumer that will call methods on {@link PingBeacon.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pingBeacon(PingBeacon)
         */
        default Builder pingBeacon(Consumer<PingBeacon.Builder> pingBeacon) {
            return pingBeacon(PingBeacon.builder().applyMutation(pingBeacon).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String locationName;

        private String locationArn;

        private PingBeacon pingBeacon;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationModel model) {
            locationName(model.locationName);
            locationArn(model.locationArn);
            pingBeacon(model.pingBeacon);
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final PingBeacon.Builder getPingBeacon() {
            return pingBeacon != null ? pingBeacon.toBuilder() : null;
        }

        public final void setPingBeacon(PingBeacon.BuilderImpl pingBeacon) {
            this.pingBeacon = pingBeacon != null ? pingBeacon.build() : null;
        }

        @Override
        public final Builder pingBeacon(PingBeacon pingBeacon) {
            this.pingBeacon = pingBeacon;
            return this;
        }

        @Override
        public LocationModel build() {
            return new LocationModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
