/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContainerGroupDefinitionsResponse extends GameLiftResponse implements
        ToCopyableBuilder<ListContainerGroupDefinitionsResponse.Builder, ListContainerGroupDefinitionsResponse> {
    private static final SdkField<List<ContainerGroupDefinition>> CONTAINER_GROUP_DEFINITIONS_FIELD = SdkField
            .<List<ContainerGroupDefinition>> builder(MarshallingType.LIST)
            .memberName("ContainerGroupDefinitions")
            .getter(getter(ListContainerGroupDefinitionsResponse::containerGroupDefinitions))
            .setter(setter(Builder::containerGroupDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerGroupDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerGroupDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContainerGroupDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTAINER_GROUP_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ContainerGroupDefinition> containerGroupDefinitions;

    private final String nextToken;

    private ListContainerGroupDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.containerGroupDefinitions = builder.containerGroupDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerGroupDefinitions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContainerGroupDefinitions() {
        return containerGroupDefinitions != null && !(containerGroupDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A result set of container group definitions that match the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerGroupDefinitions} method.
     * </p>
     * 
     * @return A result set of container group definitions that match the request.
     */
    public final List<ContainerGroupDefinition> containerGroupDefinitions() {
        return containerGroupDefinitions;
    }

    /**
     * <p>
     * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
     * returned, these results represent the end of the list.
     * </p>
     * 
     * @return A token that indicates where to resume retrieving results on the next call to this operation. If no token
     *         is returned, these results represent the end of the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerGroupDefinitions() ? containerGroupDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerGroupDefinitionsResponse)) {
            return false;
        }
        ListContainerGroupDefinitionsResponse other = (ListContainerGroupDefinitionsResponse) obj;
        return hasContainerGroupDefinitions() == other.hasContainerGroupDefinitions()
                && Objects.equals(containerGroupDefinitions(), other.containerGroupDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContainerGroupDefinitionsResponse")
                .add("ContainerGroupDefinitions", hasContainerGroupDefinitions() ? containerGroupDefinitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerGroupDefinitions":
            return Optional.ofNullable(clazz.cast(containerGroupDefinitions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerGroupDefinitions", CONTAINER_GROUP_DEFINITIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContainerGroupDefinitionsResponse, T> g) {
        return obj -> g.apply((ListContainerGroupDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListContainerGroupDefinitionsResponse> {
        /**
         * <p>
         * A result set of container group definitions that match the request.
         * </p>
         * 
         * @param containerGroupDefinitions
         *        A result set of container group definitions that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitions(Collection<ContainerGroupDefinition> containerGroupDefinitions);

        /**
         * <p>
         * A result set of container group definitions that match the request.
         * </p>
         * 
         * @param containerGroupDefinitions
         *        A result set of container group definitions that match the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitions(ContainerGroupDefinition... containerGroupDefinitions);

        /**
         * <p>
         * A result set of container group definitions that match the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #containerGroupDefinitions(List<ContainerGroupDefinition>)}.
         * 
         * @param containerGroupDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerGroupDefinitions(java.util.Collection<ContainerGroupDefinition>)
         */
        Builder containerGroupDefinitions(Consumer<ContainerGroupDefinition.Builder>... containerGroupDefinitions);

        /**
         * <p>
         * A token that indicates where to resume retrieving results on the next call to this operation. If no token is
         * returned, these results represent the end of the list.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where to resume retrieving results on the next call to this operation. If no
         *        token is returned, these results represent the end of the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<ContainerGroupDefinition> containerGroupDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerGroupDefinitionsResponse model) {
            super(model);
            containerGroupDefinitions(model.containerGroupDefinitions);
            nextToken(model.nextToken);
        }

        public final List<ContainerGroupDefinition.Builder> getContainerGroupDefinitions() {
            List<ContainerGroupDefinition.Builder> result = ContainerGroupDefinitionListCopier
                    .copyToBuilder(this.containerGroupDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerGroupDefinitions(Collection<ContainerGroupDefinition.BuilderImpl> containerGroupDefinitions) {
            this.containerGroupDefinitions = ContainerGroupDefinitionListCopier.copyFromBuilder(containerGroupDefinitions);
        }

        @Override
        public final Builder containerGroupDefinitions(Collection<ContainerGroupDefinition> containerGroupDefinitions) {
            this.containerGroupDefinitions = ContainerGroupDefinitionListCopier.copy(containerGroupDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitions(ContainerGroupDefinition... containerGroupDefinitions) {
            containerGroupDefinitions(Arrays.asList(containerGroupDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitions(Consumer<ContainerGroupDefinition.Builder>... containerGroupDefinitions) {
            containerGroupDefinitions(Stream.of(containerGroupDefinitions)
                    .map(c -> ContainerGroupDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContainerGroupDefinitionsResponse build() {
            return new ListContainerGroupDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
