/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a container fleet deployment with updates to the fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetDeployment implements SdkPojo, Serializable, ToCopyableBuilder<FleetDeployment.Builder, FleetDeployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(FleetDeployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(FleetDeployment::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> GAME_SERVER_BINARY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerBinaryArn").getter(getter(FleetDeployment::gameServerBinaryArn))
            .setter(setter(Builder::gameServerBinaryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerBinaryArn").build())
            .build();

    private static final SdkField<String> ROLLBACK_GAME_SERVER_BINARY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RollbackGameServerBinaryArn")
            .getter(getter(FleetDeployment::rollbackGameServerBinaryArn))
            .setter(setter(Builder::rollbackGameServerBinaryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackGameServerBinaryArn")
                    .build()).build();

    private static final SdkField<String> PER_INSTANCE_BINARY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PerInstanceBinaryArn").getter(getter(FleetDeployment::perInstanceBinaryArn))
            .setter(setter(Builder::perInstanceBinaryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerInstanceBinaryArn").build())
            .build();

    private static final SdkField<String> ROLLBACK_PER_INSTANCE_BINARY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RollbackPerInstanceBinaryArn")
            .getter(getter(FleetDeployment::rollbackPerInstanceBinaryArn))
            .setter(setter(Builder::rollbackPerInstanceBinaryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackPerInstanceBinaryArn")
                    .build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(FleetDeployment::deploymentStatusAsString))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfiguration")
            .getter(getter(FleetDeployment::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(FleetDeployment::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, FLEET_ID_FIELD, GAME_SERVER_BINARY_ARN_FIELD,
                    ROLLBACK_GAME_SERVER_BINARY_ARN_FIELD, PER_INSTANCE_BINARY_ARN_FIELD, ROLLBACK_PER_INSTANCE_BINARY_ARN_FIELD,
                    DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String fleetId;

    private final String gameServerBinaryArn;

    private final String rollbackGameServerBinaryArn;

    private final String perInstanceBinaryArn;

    private final String rollbackPerInstanceBinaryArn;

    private final String deploymentStatus;

    private final DeploymentConfiguration deploymentConfiguration;

    private final Instant creationTime;

    private FleetDeployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.fleetId = builder.fleetId;
        this.gameServerBinaryArn = builder.gameServerBinaryArn;
        this.rollbackGameServerBinaryArn = builder.rollbackGameServerBinaryArn;
        this.perInstanceBinaryArn = builder.perInstanceBinaryArn;
        this.rollbackPerInstanceBinaryArn = builder.rollbackPerInstanceBinaryArn;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * A unique identifier for the deployment.
     * </p>
     * 
     * @return A unique identifier for the deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * A unique identifier for the container fleet.
     * </p>
     * 
     * @return A unique identifier for the container fleet.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The unique identifier for the version of the game server container group definition that is being deployed.
     * </p>
     * 
     * @return The unique identifier for the version of the game server container group definition that is being
     *         deployed.
     */
    public final String gameServerBinaryArn() {
        return gameServerBinaryArn;
    }

    /**
     * <p>
     * The unique identifier for the version of the game server container group definition to roll back to if deployment
     * fails. Amazon GameLift Servers sets this property to the container group definition version that the fleet used
     * when it was last active.
     * </p>
     * 
     * @return The unique identifier for the version of the game server container group definition to roll back to if
     *         deployment fails. Amazon GameLift Servers sets this property to the container group definition version
     *         that the fleet used when it was last active.
     */
    public final String rollbackGameServerBinaryArn() {
        return rollbackGameServerBinaryArn;
    }

    /**
     * <p>
     * The unique identifier for the version of the per-instance container group definition that is being deployed.
     * </p>
     * 
     * @return The unique identifier for the version of the per-instance container group definition that is being
     *         deployed.
     */
    public final String perInstanceBinaryArn() {
        return perInstanceBinaryArn;
    }

    /**
     * <p>
     * The unique identifier for the version of the per-instance container group definition to roll back to if
     * deployment fails. Amazon GameLift Servers sets this property to the container group definition version that the
     * fleet used when it was last active.
     * </p>
     * 
     * @return The unique identifier for the version of the per-instance container group definition to roll back to if
     *         deployment fails. Amazon GameLift Servers sets this property to the container group definition version
     *         that the fleet used when it was last active.
     */
    public final String rollbackPerInstanceBinaryArn() {
        return rollbackPerInstanceBinaryArn;
    }

    /**
     * <p>
     * The status of fleet deployment activity in the location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> -- The deployment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> -- The deployment has completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> -- The deployment was cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of fleet deployment activity in the location. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> -- The deployment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> -- The deployment has completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> -- The deployment was cancelled.
     *         </p>
     *         </li>
     * @see DeploymentStatus
     */
    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(deploymentStatus);
    }

    /**
     * <p>
     * The status of fleet deployment activity in the location.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> -- The deployment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> -- The deployment has completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELLED</code> -- The deployment was cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentStatus}
     * will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentStatusAsString}.
     * </p>
     * 
     * @return The status of fleet deployment activity in the location. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> -- The deployment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> -- The deployment has completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code> -- The deployment was cancelled.
     *         </p>
     *         </li>
     * @see DeploymentStatus
     */
    public final String deploymentStatusAsString() {
        return deploymentStatus;
    }

    /**
     * <p>
     * Instructions for how to deploy updates to a container fleet and what actions to take if the deployment fails.
     * </p>
     * 
     * @return Instructions for how to deploy updates to a container fleet and what actions to take if the deployment
     *         fails.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     * milliseconds (for example <code>"1469498468.057"</code>).
     * </p>
     * 
     * @return A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
     *         milliseconds (for example <code>"1469498468.057"</code>).
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackGameServerBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(perInstanceBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackPerInstanceBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetDeployment)) {
            return false;
        }
        FleetDeployment other = (FleetDeployment) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(gameServerBinaryArn(), other.gameServerBinaryArn())
                && Objects.equals(rollbackGameServerBinaryArn(), other.rollbackGameServerBinaryArn())
                && Objects.equals(perInstanceBinaryArn(), other.perInstanceBinaryArn())
                && Objects.equals(rollbackPerInstanceBinaryArn(), other.rollbackPerInstanceBinaryArn())
                && Objects.equals(deploymentStatusAsString(), other.deploymentStatusAsString())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetDeployment").add("DeploymentId", deploymentId()).add("FleetId", fleetId())
                .add("GameServerBinaryArn", gameServerBinaryArn())
                .add("RollbackGameServerBinaryArn", rollbackGameServerBinaryArn())
                .add("PerInstanceBinaryArn", perInstanceBinaryArn())
                .add("RollbackPerInstanceBinaryArn", rollbackPerInstanceBinaryArn())
                .add("DeploymentStatus", deploymentStatusAsString()).add("DeploymentConfiguration", deploymentConfiguration())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "GameServerBinaryArn":
            return Optional.ofNullable(clazz.cast(gameServerBinaryArn()));
        case "RollbackGameServerBinaryArn":
            return Optional.ofNullable(clazz.cast(rollbackGameServerBinaryArn()));
        case "PerInstanceBinaryArn":
            return Optional.ofNullable(clazz.cast(perInstanceBinaryArn()));
        case "RollbackPerInstanceBinaryArn":
            return Optional.ofNullable(clazz.cast(rollbackPerInstanceBinaryArn()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatusAsString()));
        case "DeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeploymentId", DEPLOYMENT_ID_FIELD);
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("GameServerBinaryArn", GAME_SERVER_BINARY_ARN_FIELD);
        map.put("RollbackGameServerBinaryArn", ROLLBACK_GAME_SERVER_BINARY_ARN_FIELD);
        map.put("PerInstanceBinaryArn", PER_INSTANCE_BINARY_ARN_FIELD);
        map.put("RollbackPerInstanceBinaryArn", ROLLBACK_PER_INSTANCE_BINARY_ARN_FIELD);
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("DeploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetDeployment, T> g) {
        return obj -> g.apply((FleetDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetDeployment> {
        /**
         * <p>
         * A unique identifier for the deployment.
         * </p>
         * 
         * @param deploymentId
         *        A unique identifier for the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * A unique identifier for the container fleet.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The unique identifier for the version of the game server container group definition that is being deployed.
         * </p>
         * 
         * @param gameServerBinaryArn
         *        The unique identifier for the version of the game server container group definition that is being
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerBinaryArn(String gameServerBinaryArn);

        /**
         * <p>
         * The unique identifier for the version of the game server container group definition to roll back to if
         * deployment fails. Amazon GameLift Servers sets this property to the container group definition version that
         * the fleet used when it was last active.
         * </p>
         * 
         * @param rollbackGameServerBinaryArn
         *        The unique identifier for the version of the game server container group definition to roll back to if
         *        deployment fails. Amazon GameLift Servers sets this property to the container group definition version
         *        that the fleet used when it was last active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackGameServerBinaryArn(String rollbackGameServerBinaryArn);

        /**
         * <p>
         * The unique identifier for the version of the per-instance container group definition that is being deployed.
         * </p>
         * 
         * @param perInstanceBinaryArn
         *        The unique identifier for the version of the per-instance container group definition that is being
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perInstanceBinaryArn(String perInstanceBinaryArn);

        /**
         * <p>
         * The unique identifier for the version of the per-instance container group definition to roll back to if
         * deployment fails. Amazon GameLift Servers sets this property to the container group definition version that
         * the fleet used when it was last active.
         * </p>
         * 
         * @param rollbackPerInstanceBinaryArn
         *        The unique identifier for the version of the per-instance container group definition to roll back to
         *        if deployment fails. Amazon GameLift Servers sets this property to the container group definition
         *        version that the fleet used when it was last active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackPerInstanceBinaryArn(String rollbackPerInstanceBinaryArn);

        /**
         * <p>
         * The status of fleet deployment activity in the location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> -- The deployment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> -- The deployment has completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> -- The deployment was cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStatus
         *        The status of fleet deployment activity in the location. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> -- The deployment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> -- The deployment has completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> -- The deployment was cancelled.
         *        </p>
         *        </li>
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The status of fleet deployment activity in the location.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> -- The deployment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> -- The deployment has completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELLED</code> -- The deployment was cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deploymentStatus
         *        The status of fleet deployment activity in the location. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> -- The deployment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> -- The deployment failed and the fleet has some impaired containers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> -- The deployment has completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_PROGRESS</code> -- The deployment failed and rollback has been initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROLLBACK_IN_COMPLETE</code> -- The deployment failed and rollback has been completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code> -- The deployment was cancelled.
         *        </p>
         *        </li>
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder deploymentStatus(DeploymentStatus deploymentStatus);

        /**
         * <p>
         * Instructions for how to deploy updates to a container fleet and what actions to take if the deployment fails.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Instructions for how to deploy updates to a container fleet and what actions to take if the deployment
         *        fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Instructions for how to deploy updates to a container fleet and what actions to take if the deployment fails.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * A time stamp indicating when this data object was created. Format is a number expressed in Unix time as
         * milliseconds (for example <code>"1469498468.057"</code>).
         * </p>
         * 
         * @param creationTime
         *        A time stamp indicating when this data object was created. Format is a number expressed in Unix time
         *        as milliseconds (for example <code>"1469498468.057"</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String fleetId;

        private String gameServerBinaryArn;

        private String rollbackGameServerBinaryArn;

        private String perInstanceBinaryArn;

        private String rollbackPerInstanceBinaryArn;

        private String deploymentStatus;

        private DeploymentConfiguration deploymentConfiguration;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetDeployment model) {
            deploymentId(model.deploymentId);
            fleetId(model.fleetId);
            gameServerBinaryArn(model.gameServerBinaryArn);
            rollbackGameServerBinaryArn(model.rollbackGameServerBinaryArn);
            perInstanceBinaryArn(model.perInstanceBinaryArn);
            rollbackPerInstanceBinaryArn(model.rollbackPerInstanceBinaryArn);
            deploymentStatus(model.deploymentStatus);
            deploymentConfiguration(model.deploymentConfiguration);
            creationTime(model.creationTime);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getGameServerBinaryArn() {
            return gameServerBinaryArn;
        }

        public final void setGameServerBinaryArn(String gameServerBinaryArn) {
            this.gameServerBinaryArn = gameServerBinaryArn;
        }

        @Override
        public final Builder gameServerBinaryArn(String gameServerBinaryArn) {
            this.gameServerBinaryArn = gameServerBinaryArn;
            return this;
        }

        public final String getRollbackGameServerBinaryArn() {
            return rollbackGameServerBinaryArn;
        }

        public final void setRollbackGameServerBinaryArn(String rollbackGameServerBinaryArn) {
            this.rollbackGameServerBinaryArn = rollbackGameServerBinaryArn;
        }

        @Override
        public final Builder rollbackGameServerBinaryArn(String rollbackGameServerBinaryArn) {
            this.rollbackGameServerBinaryArn = rollbackGameServerBinaryArn;
            return this;
        }

        public final String getPerInstanceBinaryArn() {
            return perInstanceBinaryArn;
        }

        public final void setPerInstanceBinaryArn(String perInstanceBinaryArn) {
            this.perInstanceBinaryArn = perInstanceBinaryArn;
        }

        @Override
        public final Builder perInstanceBinaryArn(String perInstanceBinaryArn) {
            this.perInstanceBinaryArn = perInstanceBinaryArn;
            return this;
        }

        public final String getRollbackPerInstanceBinaryArn() {
            return rollbackPerInstanceBinaryArn;
        }

        public final void setRollbackPerInstanceBinaryArn(String rollbackPerInstanceBinaryArn) {
            this.rollbackPerInstanceBinaryArn = rollbackPerInstanceBinaryArn;
        }

        @Override
        public final Builder rollbackPerInstanceBinaryArn(String rollbackPerInstanceBinaryArn) {
            this.rollbackPerInstanceBinaryArn = rollbackPerInstanceBinaryArn;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public FleetDeployment build() {
            return new FleetDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
