/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon GameLift Servers service limits for an Amazon EC2 instance type and current utilization. Amazon GameLift
 * Servers allows Amazon Web Services accounts a maximum number of instances, per instance type, per Amazon Web Services
 * Region or location, for use with Amazon GameLift Servers. You can request an limit increase for your account by using
 * the <b>Service limits</b> page in the Amazon GameLift Servers console.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2InstanceLimit implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2InstanceLimit.Builder, EC2InstanceLimit> {
    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2InstanceType").getter(getter(EC2InstanceLimit::ec2InstanceTypeAsString))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()).build();

    private static final SdkField<Integer> CURRENT_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentInstances").getter(getter(EC2InstanceLimit::currentInstances))
            .setter(setter(Builder::currentInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstances").build()).build();

    private static final SdkField<Integer> INSTANCE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceLimit").getter(getter(EC2InstanceLimit::instanceLimit)).setter(setter(Builder::instanceLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLimit").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(EC2InstanceLimit::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_TYPE_FIELD,
            CURRENT_INSTANCES_FIELD, INSTANCE_LIMIT_FIELD, LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ec2InstanceType;

    private final Integer currentInstances;

    private final Integer instanceLimit;

    private final String location;

    private EC2InstanceLimit(BuilderImpl builder) {
        this.ec2InstanceType = builder.ec2InstanceType;
        this.currentInstances = builder.currentInstances;
        this.instanceLimit = builder.instanceLimit;
        this.location = builder.location;
    }

    /**
     * <p>
     * The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic
     * Compute Cloud Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
     *         Elastic Compute Cloud Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public final EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(ec2InstanceType);
    }

    /**
     * <p>
     * The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic
     * Compute Cloud Instance Types</a> for detailed descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
     *         Elastic Compute Cloud Instance Types</a> for detailed descriptions.
     * @see EC2InstanceType
     */
    public final String ec2InstanceTypeAsString() {
        return ec2InstanceType;
    }

    /**
     * <p>
     * The number of instances for the specified type and location that are currently being used by the Amazon Web
     * Services account.
     * </p>
     * 
     * @return The number of instances for the specified type and location that are currently being used by the Amazon
     *         Web Services account.
     */
    public final Integer currentInstances() {
        return currentInstances;
    }

    /**
     * <p>
     * The number of instances that is allowed for the specified instance type and location.
     * </p>
     * 
     * @return The number of instances that is allowed for the specified instance type and location.
     */
    public final Integer instanceLimit() {
        return instanceLimit;
    }

    /**
     * <p>
     * An Amazon Web Services Region code, such as <code>us-west-2</code>.
     * </p>
     * 
     * @return An Amazon Web Services Region code, such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentInstances());
        hashCode = 31 * hashCode + Objects.hashCode(instanceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceLimit)) {
            return false;
        }
        EC2InstanceLimit other = (EC2InstanceLimit) obj;
        return Objects.equals(ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString())
                && Objects.equals(currentInstances(), other.currentInstances())
                && Objects.equals(instanceLimit(), other.instanceLimit()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2InstanceLimit").add("EC2InstanceType", ec2InstanceTypeAsString())
                .add("CurrentInstances", currentInstances()).add("InstanceLimit", instanceLimit()).add("Location", location())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceTypeAsString()));
        case "CurrentInstances":
            return Optional.ofNullable(clazz.cast(currentInstances()));
        case "InstanceLimit":
            return Optional.ofNullable(clazz.cast(instanceLimit()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EC2InstanceType", EC2_INSTANCE_TYPE_FIELD);
        map.put("CurrentInstances", CURRENT_INSTANCES_FIELD);
        map.put("InstanceLimit", INSTANCE_LIMIT_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceLimit, T> g) {
        return obj -> g.apply((EC2InstanceLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2InstanceLimit> {
        /**
         * <p>
         * The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
         * Elastic Compute Cloud Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param ec2InstanceType
         *        The name of an Amazon EC2 instance type. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
         *        detailed descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * The name of an Amazon EC2 instance type. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
         * Elastic Compute Cloud Instance Types</a> for detailed descriptions.
         * </p>
         * 
         * @param ec2InstanceType
         *        The name of an Amazon EC2 instance type. See <a
         *        href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
         *        detailed descriptions.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(EC2InstanceType ec2InstanceType);

        /**
         * <p>
         * The number of instances for the specified type and location that are currently being used by the Amazon Web
         * Services account.
         * </p>
         * 
         * @param currentInstances
         *        The number of instances for the specified type and location that are currently being used by the
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentInstances(Integer currentInstances);

        /**
         * <p>
         * The number of instances that is allowed for the specified instance type and location.
         * </p>
         * 
         * @param instanceLimit
         *        The number of instances that is allowed for the specified instance type and location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceLimit(Integer instanceLimit);

        /**
         * <p>
         * An Amazon Web Services Region code, such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        An Amazon Web Services Region code, such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String ec2InstanceType;

        private Integer currentInstances;

        private Integer instanceLimit;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceLimit model) {
            ec2InstanceType(model.ec2InstanceType);
            currentInstances(model.currentInstances);
            instanceLimit(model.instanceLimit);
            location(model.location);
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final Integer getCurrentInstances() {
            return currentInstances;
        }

        public final void setCurrentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
        }

        @Override
        public final Builder currentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
            return this;
        }

        public final Integer getInstanceLimit() {
            return instanceLimit;
        }

        public final void setInstanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
        }

        @Override
        public final Builder instanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public EC2InstanceLimit build() {
            return new EC2InstanceLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
