/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Set of rules for processing a deployment for a container fleet update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfiguration.Builder, DeploymentConfiguration> {
    private static final SdkField<String> PROTECTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectionStrategy").getter(getter(DeploymentConfiguration::protectionStrategyAsString))
            .setter(setter(Builder::protectionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionStrategy").build())
            .build();

    private static final SdkField<Integer> MINIMUM_HEALTHY_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumHealthyPercentage").getter(getter(DeploymentConfiguration::minimumHealthyPercentage))
            .setter(setter(Builder::minimumHealthyPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumHealthyPercentage").build())
            .build();

    private static final SdkField<String> IMPAIRMENT_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpairmentStrategy").getter(getter(DeploymentConfiguration::impairmentStrategyAsString))
            .setter(setter(Builder::impairmentStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpairmentStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_STRATEGY_FIELD,
            MINIMUM_HEALTHY_PERCENTAGE_FIELD, IMPAIRMENT_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String protectionStrategy;

    private final Integer minimumHealthyPercentage;

    private final String impairmentStrategy;

    private DeploymentConfiguration(BuilderImpl builder) {
        this.protectionStrategy = builder.protectionStrategy;
        this.minimumHealthyPercentage = builder.minimumHealthyPercentage;
        this.impairmentStrategy = builder.impairmentStrategy;
    }

    /**
     * <p>
     * Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a deployment
     * honors game session protection, and delays actions that would interrupt a protected active game session until the
     * game session ends. Without protection, deployment activity can shut down all running tasks, including active game
     * sessions, regardless of game session protection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #protectionStrategy} will return {@link DeploymentProtectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #protectionStrategyAsString}.
     * </p>
     * 
     * @return Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a
     *         deployment honors game session protection, and delays actions that would interrupt a protected active
     *         game session until the game session ends. Without protection, deployment activity can shut down all
     *         running tasks, including active game sessions, regardless of game session protection.
     * @see DeploymentProtectionStrategy
     */
    public final DeploymentProtectionStrategy protectionStrategy() {
        return DeploymentProtectionStrategy.fromValue(protectionStrategy);
    }

    /**
     * <p>
     * Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a deployment
     * honors game session protection, and delays actions that would interrupt a protected active game session until the
     * game session ends. Without protection, deployment activity can shut down all running tasks, including active game
     * sessions, regardless of game session protection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #protectionStrategy} will return {@link DeploymentProtectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #protectionStrategyAsString}.
     * </p>
     * 
     * @return Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a
     *         deployment honors game session protection, and delays actions that would interrupt a protected active
     *         game session until the game session ends. Without protection, deployment activity can shut down all
     *         running tasks, including active game sessions, regardless of game session protection.
     * @see DeploymentProtectionStrategy
     */
    public final String protectionStrategyAsString() {
        return protectionStrategy;
    }

    /**
     * <p>
     * Sets a minimum level of healthy tasks to maintain during deployment activity.
     * </p>
     * 
     * @return Sets a minimum level of healthy tasks to maintain during deployment activity.
     */
    public final Integer minimumHealthyPercentage() {
        return minimumHealthyPercentage;
    }

    /**
     * <p>
     * Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy applies
     * across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last
     * successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of debugging,
     * while all other tasks return to the last successful deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #impairmentStrategy} will return {@link DeploymentImpairmentStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #impairmentStrategyAsString}.
     * </p>
     * 
     * @return Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy
     *         applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to
     *         the last successful deployment. Alternatively, you can maintain a few impaired containers for the purpose
     *         of debugging, while all other tasks return to the last successful deployment.
     * @see DeploymentImpairmentStrategy
     */
    public final DeploymentImpairmentStrategy impairmentStrategy() {
        return DeploymentImpairmentStrategy.fromValue(impairmentStrategy);
    }

    /**
     * <p>
     * Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy applies
     * across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last
     * successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of debugging,
     * while all other tasks return to the last successful deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #impairmentStrategy} will return {@link DeploymentImpairmentStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #impairmentStrategyAsString}.
     * </p>
     * 
     * @return Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy
     *         applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to
     *         the last successful deployment. Alternatively, you can maintain a few impaired containers for the purpose
     *         of debugging, while all other tasks return to the last successful deployment.
     * @see DeploymentImpairmentStrategy
     */
    public final String impairmentStrategyAsString() {
        return impairmentStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minimumHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(impairmentStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration) obj;
        return Objects.equals(protectionStrategyAsString(), other.protectionStrategyAsString())
                && Objects.equals(minimumHealthyPercentage(), other.minimumHealthyPercentage())
                && Objects.equals(impairmentStrategyAsString(), other.impairmentStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentConfiguration").add("ProtectionStrategy", protectionStrategyAsString())
                .add("MinimumHealthyPercentage", minimumHealthyPercentage())
                .add("ImpairmentStrategy", impairmentStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionStrategy":
            return Optional.ofNullable(clazz.cast(protectionStrategyAsString()));
        case "MinimumHealthyPercentage":
            return Optional.ofNullable(clazz.cast(minimumHealthyPercentage()));
        case "ImpairmentStrategy":
            return Optional.ofNullable(clazz.cast(impairmentStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProtectionStrategy", PROTECTION_STRATEGY_FIELD);
        map.put("MinimumHealthyPercentage", MINIMUM_HEALTHY_PERCENTAGE_FIELD);
        map.put("ImpairmentStrategy", IMPAIRMENT_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfiguration, T> g) {
        return obj -> g.apply((DeploymentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfiguration> {
        /**
         * <p>
         * Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a
         * deployment honors game session protection, and delays actions that would interrupt a protected active game
         * session until the game session ends. Without protection, deployment activity can shut down all running tasks,
         * including active game sessions, regardless of game session protection.
         * </p>
         * 
         * @param protectionStrategy
         *        Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a
         *        deployment honors game session protection, and delays actions that would interrupt a protected active
         *        game session until the game session ends. Without protection, deployment activity can shut down all
         *        running tasks, including active game sessions, regardless of game session protection.
         * @see DeploymentProtectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentProtectionStrategy
         */
        Builder protectionStrategy(String protectionStrategy);

        /**
         * <p>
         * Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a
         * deployment honors game session protection, and delays actions that would interrupt a protected active game
         * session until the game session ends. Without protection, deployment activity can shut down all running tasks,
         * including active game sessions, regardless of game session protection.
         * </p>
         * 
         * @param protectionStrategy
         *        Determines how fleet deployment activity affects active game sessions on the fleet. With protection, a
         *        deployment honors game session protection, and delays actions that would interrupt a protected active
         *        game session until the game session ends. Without protection, deployment activity can shut down all
         *        running tasks, including active game sessions, regardless of game session protection.
         * @see DeploymentProtectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentProtectionStrategy
         */
        Builder protectionStrategy(DeploymentProtectionStrategy protectionStrategy);

        /**
         * <p>
         * Sets a minimum level of healthy tasks to maintain during deployment activity.
         * </p>
         * 
         * @param minimumHealthyPercentage
         *        Sets a minimum level of healthy tasks to maintain during deployment activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyPercentage(Integer minimumHealthyPercentage);

        /**
         * <p>
         * Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy applies
         * across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last
         * successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of
         * debugging, while all other tasks return to the last successful deployment.
         * </p>
         * 
         * @param impairmentStrategy
         *        Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy
         *        applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back
         *        to the last successful deployment. Alternatively, you can maintain a few impaired containers for the
         *        purpose of debugging, while all other tasks return to the last successful deployment.
         * @see DeploymentImpairmentStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentImpairmentStrategy
         */
        Builder impairmentStrategy(String impairmentStrategy);

        /**
         * <p>
         * Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy applies
         * across all fleet locations. With a rollback strategy, updated fleet instances are rolled back to the last
         * successful deployment. Alternatively, you can maintain a few impaired containers for the purpose of
         * debugging, while all other tasks return to the last successful deployment.
         * </p>
         * 
         * @param impairmentStrategy
         *        Determines what actions to take if a deployment fails. If the fleet is multi-location, this strategy
         *        applies across all fleet locations. With a rollback strategy, updated fleet instances are rolled back
         *        to the last successful deployment. Alternatively, you can maintain a few impaired containers for the
         *        purpose of debugging, while all other tasks return to the last successful deployment.
         * @see DeploymentImpairmentStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentImpairmentStrategy
         */
        Builder impairmentStrategy(DeploymentImpairmentStrategy impairmentStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String protectionStrategy;

        private Integer minimumHealthyPercentage;

        private String impairmentStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfiguration model) {
            protectionStrategy(model.protectionStrategy);
            minimumHealthyPercentage(model.minimumHealthyPercentage);
            impairmentStrategy(model.impairmentStrategy);
        }

        public final String getProtectionStrategy() {
            return protectionStrategy;
        }

        public final void setProtectionStrategy(String protectionStrategy) {
            this.protectionStrategy = protectionStrategy;
        }

        @Override
        public final Builder protectionStrategy(String protectionStrategy) {
            this.protectionStrategy = protectionStrategy;
            return this;
        }

        @Override
        public final Builder protectionStrategy(DeploymentProtectionStrategy protectionStrategy) {
            this.protectionStrategy(protectionStrategy == null ? null : protectionStrategy.toString());
            return this;
        }

        public final Integer getMinimumHealthyPercentage() {
            return minimumHealthyPercentage;
        }

        public final void setMinimumHealthyPercentage(Integer minimumHealthyPercentage) {
            this.minimumHealthyPercentage = minimumHealthyPercentage;
        }

        @Override
        public final Builder minimumHealthyPercentage(Integer minimumHealthyPercentage) {
            this.minimumHealthyPercentage = minimumHealthyPercentage;
            return this;
        }

        public final String getImpairmentStrategy() {
            return impairmentStrategy;
        }

        public final void setImpairmentStrategy(String impairmentStrategy) {
            this.impairmentStrategy = impairmentStrategy;
        }

        @Override
        public final Builder impairmentStrategy(String impairmentStrategy) {
            this.impairmentStrategy = impairmentStrategy;
            return this;
        }

        @Override
        public final Builder impairmentStrategy(DeploymentImpairmentStrategy impairmentStrategy) {
            this.impairmentStrategy(impairmentStrategy == null ? null : impairmentStrategy.toString());
            return this;
        }

        @Override
        public DeploymentConfiguration build() {
            return new DeploymentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
