/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerFleetRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateContainerFleetRequest.Builder, CreateContainerFleetRequest> {
    private static final SdkField<String> FLEET_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetRoleArn").getter(getter(CreateContainerFleetRequest::fleetRoleArn))
            .setter(setter(Builder::fleetRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetRoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateContainerFleetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GameServerContainerGroupDefinitionName")
            .getter(getter(CreateContainerFleetRequest::gameServerContainerGroupDefinitionName))
            .setter(setter(Builder::gameServerContainerGroupDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GameServerContainerGroupDefinitionName").build()).build();

    private static final SdkField<String> PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerInstanceContainerGroupDefinitionName")
            .getter(getter(CreateContainerFleetRequest::perInstanceContainerGroupDefinitionName))
            .setter(setter(Builder::perInstanceContainerGroupDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PerInstanceContainerGroupDefinitionName").build()).build();

    private static final SdkField<ConnectionPortRange> INSTANCE_CONNECTION_PORT_RANGE_FIELD = SdkField
            .<ConnectionPortRange> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceConnectionPortRange")
            .getter(getter(CreateContainerFleetRequest::instanceConnectionPortRange))
            .setter(setter(Builder::instanceConnectionPortRange))
            .constructor(ConnectionPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectionPortRange")
                    .build()).build();

    private static final SdkField<List<IpPermission>> INSTANCE_INBOUND_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("InstanceInboundPermissions")
            .getter(getter(CreateContainerFleetRequest::instanceInboundPermissions))
            .setter(setter(Builder::instanceInboundPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInboundPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("GameServerContainerGroupsPerInstance")
            .getter(getter(CreateContainerFleetRequest::gameServerContainerGroupsPerInstance))
            .setter(setter(Builder::gameServerContainerGroupsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GameServerContainerGroupsPerInstance").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateContainerFleetRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> BILLING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingType").getter(getter(CreateContainerFleetRequest::billingTypeAsString))
            .setter(setter(Builder::billingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingType").build()).build();

    private static final SdkField<List<LocationConfiguration>> LOCATIONS_FIELD = SdkField
            .<List<LocationConfiguration>> builder(MarshallingType.LIST)
            .memberName("Locations")
            .getter(getter(CreateContainerFleetRequest::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricGroups")
            .getter(getter(CreateContainerFleetRequest::metricGroups))
            .setter(setter(Builder::metricGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGameSessionProtectionPolicy")
            .getter(getter(CreateContainerFleetRequest::newGameSessionProtectionPolicyAsString))
            .setter(setter(Builder::newGameSessionProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy")
                    .build()).build();

    private static final SdkField<GameSessionCreationLimitPolicy> GAME_SESSION_CREATION_LIMIT_POLICY_FIELD = SdkField
            .<GameSessionCreationLimitPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("GameSessionCreationLimitPolicy")
            .getter(getter(CreateContainerFleetRequest::gameSessionCreationLimitPolicy))
            .setter(setter(Builder::gameSessionCreationLimitPolicy))
            .constructor(GameSessionCreationLimitPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionCreationLimitPolicy")
                    .build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(CreateContainerFleetRequest::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateContainerFleetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ROLE_ARN_FIELD,
            DESCRIPTION_FIELD, GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD,
            PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD, INSTANCE_CONNECTION_PORT_RANGE_FIELD,
            INSTANCE_INBOUND_PERMISSIONS_FIELD, GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD, INSTANCE_TYPE_FIELD,
            BILLING_TYPE_FIELD, LOCATIONS_FIELD, METRIC_GROUPS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD,
            GAME_SESSION_CREATION_LIMIT_POLICY_FIELD, LOG_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetRoleArn;

    private final String description;

    private final String gameServerContainerGroupDefinitionName;

    private final String perInstanceContainerGroupDefinitionName;

    private final ConnectionPortRange instanceConnectionPortRange;

    private final List<IpPermission> instanceInboundPermissions;

    private final Integer gameServerContainerGroupsPerInstance;

    private final String instanceType;

    private final String billingType;

    private final List<LocationConfiguration> locations;

    private final List<String> metricGroups;

    private final String newGameSessionProtectionPolicy;

    private final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;

    private final LogConfiguration logConfiguration;

    private final List<Tag> tags;

    private CreateContainerFleetRequest(BuilderImpl builder) {
        super(builder);
        this.fleetRoleArn = builder.fleetRoleArn;
        this.description = builder.description;
        this.gameServerContainerGroupDefinitionName = builder.gameServerContainerGroupDefinitionName;
        this.perInstanceContainerGroupDefinitionName = builder.perInstanceContainerGroupDefinitionName;
        this.instanceConnectionPortRange = builder.instanceConnectionPortRange;
        this.instanceInboundPermissions = builder.instanceInboundPermissions;
        this.gameServerContainerGroupsPerInstance = builder.gameServerContainerGroupsPerInstance;
        this.instanceType = builder.instanceType;
        this.billingType = builder.billingType;
        this.locations = builder.locations;
        this.metricGroups = builder.metricGroups;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.gameSessionCreationLimitPolicy = builder.gameSessionCreationLimitPolicy;
        this.logConfiguration = builder.logConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for an Identity and Access Management (IAM) role with permissions to run your containers on
     * resources that are managed by Amazon GameLift Servers. Use an IAM service role with the
     * <code>GameLiftContainerFleetPolicy</code> managed policy attached. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM service
     * role</a>. You can't change this fleet property after the fleet is created.
     * </p>
     * <p>
     * IAM role ARN values use the following pattern:
     * <code>arn:aws:iam::[Amazon Web Services account]:role/[role name]</code>.
     * </p>
     * 
     * @return The unique identifier for an Identity and Access Management (IAM) role with permissions to run your
     *         containers on resources that are managed by Amazon GameLift Servers. Use an IAM service role with the
     *         <code>GameLiftContainerFleetPolicy</code> managed policy attached. For more information, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM
     *         service role</a>. You can't change this fleet property after the fleet is created.</p>
     *         <p>
     *         IAM role ARN values use the following pattern:
     *         <code>arn:aws:iam::[Amazon Web Services account]:role/[role name]</code>.
     */
    public final String fleetRoleArn() {
        return fleetRoleArn;
    }

    /**
     * <p>
     * A meaningful description of the container fleet.
     * </p>
     * 
     * @return A meaningful description of the container fleet.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A container group definition resource that describes how to deploy containers with your game server build and
     * support software onto each fleet instance. You can specify the container group definition's name to use the
     * latest version. Alternatively, provide an ARN value with a specific version number.
     * </p>
     * <p>
     * Create a container group definition by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
     * >CreateContainerGroupDefinition</a>. This operation creates a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     * >ContainerGroupDefinition</a> resource.
     * </p>
     * 
     * @return A container group definition resource that describes how to deploy containers with your game server build
     *         and support software onto each fleet instance. You can specify the container group definition's name to
     *         use the latest version. Alternatively, provide an ARN value with a specific version number.</p>
     *         <p>
     *         Create a container group definition by calling <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
     *         >CreateContainerGroupDefinition</a>. This operation creates a <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     *         >ContainerGroupDefinition</a> resource.
     */
    public final String gameServerContainerGroupDefinitionName() {
        return gameServerContainerGroupDefinitionName;
    }

    /**
     * <p>
     * The name of a container group definition resource that describes a set of axillary software. A fleet instance has
     * one process for executables in this container group. A per-instance container group is optional. You can update
     * the fleet to add or remove a per-instance container group at any time. You can specify the container group
     * definition's name to use the latest version. Alternatively, provide an ARN value with a specific version number.
     * </p>
     * <p>
     * Create a container group definition by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
     * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html</a>. This
     * operation creates a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html</a> resource.
     * </p>
     * 
     * @return The name of a container group definition resource that describes a set of axillary software. A fleet
     *         instance has one process for executables in this container group. A per-instance container group is
     *         optional. You can update the fleet to add or remove a per-instance container group at any time. You can
     *         specify the container group definition's name to use the latest version. Alternatively, provide an ARN
     *         value with a specific version number. </p>
     *         <p>
     *         Create a container group definition by calling <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
     *         >https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html</a>.
     *         This operation creates a <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
     *         >https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html</a> resource.
     */
    public final String perInstanceContainerGroupDefinitionName() {
        return perInstanceContainerGroupDefinitionName;
    }

    /**
     * <p>
     * The set of port numbers to open on each fleet instance. A fleet's connection ports map to container ports that
     * are configured in the fleet's container group definitions.
     * </p>
     * <p>
     * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To use
     * the calculated range, don't set this parameter. The values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
     * following formula:
     * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
     * numbers that match the fleet's inbound permissions port range.
     * </p>
     * <note>
     * <p>
     * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you later
     * remove the manual settings.
     * </p>
     * </note>
     * 
     * @return The set of port numbers to open on each fleet instance. A fleet's connection ports map to container ports
     *         that are configured in the fleet's container group definitions. </p>
     *         <p>
     *         By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration.
     *         To use the calculated range, don't set this parameter. The values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses
     *         the following formula:
     *         <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can also choose to manually set this parameter. When manually setting this parameter, you must use
     *         port numbers that match the fleet's inbound permissions port range.
     *         </p>
     *         <note>
     *         <p>
     *         If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if
     *         you later remove the manual settings.
     *         </p>
     */
    public final ConnectionPortRange instanceConnectionPortRange() {
        return instanceConnectionPortRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceInboundPermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstanceInboundPermissions() {
        return instanceInboundPermissions != null && !(instanceInboundPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other
     * processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend opening ports
     * only when you need them and closing them when you're finished.
     * </p>
     * <p>
     * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To use
     * the calculated range, don't set this parameter. The values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Protocol: UDP
     * </p>
     * </li>
     * <li>
     * <p>
     * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
     * following formula:
     * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
     * numbers that match the fleet's connection port range.
     * </p>
     * <note>
     * <p>
     * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you later
     * remove the manual settings.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceInboundPermissions} method.
     * </p>
     * 
     * @return The IP address ranges and port settings that allow inbound traffic to access game server processes and
     *         other processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend
     *         opening ports only when you need them and closing them when you're finished.</p>
     *         <p>
     *         By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration.
     *         To use the calculated range, don't set this parameter. The values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Protocol: UDP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses
     *         the following formula:
     *         <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can also choose to manually set this parameter. When manually setting this parameter, you must use
     *         port numbers that match the fleet's connection port range.
     *         </p>
     *         <note>
     *         <p>
     *         If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if
     *         you later remove the manual settings.
     *         </p>
     */
    public final List<IpPermission> instanceInboundPermissions() {
        return instanceInboundPermissions;
    }

    /**
     * <p>
     * The number of times to replicate the game server container group on each fleet instance.
     * </p>
     * <p>
     * By default, Amazon GameLift Servers calculates the maximum number of game server container groups that can fit on
     * each instance. This calculation is based on the CPU and memory resources of the fleet's instance type). To use
     * the calculated maximum, don't set this parameter. If you set this number manually, Amazon GameLift Servers uses
     * your value as long as it's less than the calculated maximum.
     * </p>
     * 
     * @return The number of times to replicate the game server container group on each fleet instance. </p>
     *         <p>
     *         By default, Amazon GameLift Servers calculates the maximum number of game server container groups that
     *         can fit on each instance. This calculation is based on the CPU and memory resources of the fleet's
     *         instance type). To use the calculated maximum, don't set this parameter. If you set this number manually,
     *         Amazon GameLift Servers uses your value as long as it's less than the calculated maximum.
     */
    public final Integer gameServerContainerGroupsPerInstance() {
        return gameServerContainerGroupsPerInstance;
    }

    /**
     * <p>
     * The Amazon EC2 instance type to use for all instances in the fleet. For multi-location fleets, the instance type
     * must be available in the home region and all remote locations. Instance type determines the computing resources
     * and processing power that's available to host your game servers. This includes including CPU, memory, storage,
     * and networking capacity.
     * </p>
     * <p>
     * By default, Amazon GameLift Servers selects an instance type that fits the needs of your container groups and is
     * available in all selected fleet locations. You can also choose to manually set this parameter. See <a
     * href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed
     * descriptions of Amazon EC2 instance types.
     * </p>
     * <p>
     * You can't update this fleet property later.
     * </p>
     * 
     * @return The Amazon EC2 instance type to use for all instances in the fleet. For multi-location fleets, the
     *         instance type must be available in the home region and all remote locations. Instance type determines the
     *         computing resources and processing power that's available to host your game servers. This includes
     *         including CPU, memory, storage, and networking capacity. </p>
     *         <p>
     *         By default, Amazon GameLift Servers selects an instance type that fits the needs of your container groups
     *         and is available in all selected fleet locations. You can also choose to manually set this parameter. See
     *         <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for
     *         detailed descriptions of Amazon EC2 instance types.
     *         </p>
     *         <p>
     *         You can't update this fleet property later.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     * > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is created.
     * </p>
     * <p>
     * By default, this property is set to <code>ON_DEMAND</code>.
     * </p>
     * <p>
     * You can't update this fleet property later.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingType} will
     * return {@link ContainerFleetBillingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #billingTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a
     *         href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     *         > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is
     *         created.</p>
     *         <p>
     *         By default, this property is set to <code>ON_DEMAND</code>.
     *         </p>
     *         <p>
     *         You can't update this fleet property later.
     * @see ContainerFleetBillingType
     */
    public final ContainerFleetBillingType billingType() {
        return ContainerFleetBillingType.fromValue(billingType);
    }

    /**
     * <p>
     * Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     * > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is created.
     * </p>
     * <p>
     * By default, this property is set to <code>ON_DEMAND</code>.
     * </p>
     * <p>
     * You can't update this fleet property later.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingType} will
     * return {@link ContainerFleetBillingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #billingTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a
     *         href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     *         > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is
     *         created.</p>
     *         <p>
     *         By default, this property is set to <code>ON_DEMAND</code>.
     *         </p>
     *         <p>
     *         You can't update this fleet property later.
     * @see ContainerFleetBillingType
     */
    public final String billingTypeAsString() {
        return billingType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or Local
     * Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services Region codes,
     * such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's home Region, which is the Amazon
     * Web Services Region where the fleet is created. For a list of supported Regions and Local Zones, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift Servers
     * service locations</a> for managed hosting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or
     *         Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services
     *         Region codes, such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's home Region,
     *         which is the Amazon Web Services Region where the fleet is created. For a list of supported Regions and
     *         Local Zones, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     *         Servers service locations</a> for managed hosting.
     */
    public final List<LocationConfiguration> locations() {
        return locations;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricGroups() {
        return metricGroups != null && !(metricGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric group to
     * aggregate metrics for multiple fleets. You can specify an existing metric group name or use a new name to create
     * a new metric group. Each fleet can have only one metric group, but you can change this value at any time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricGroups} method.
     * </p>
     * 
     * @return The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric
     *         group to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a
     *         new name to create a new metric group. Each fleet can have only one metric group, but you can change this
     *         value at any time.
     */
    public final List<String> metricGroups() {
        return metricGroups;
    }

    /**
     * <p>
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and
     * hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or
     * when retiring unhealthy instances. You can also set game session protection for individual game sessions using <a
     * href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, this property is set to <code>NoProtection</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively
     *         running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down
     *         fleet capacity or when retiring unhealthy instances. You can also set game session protection for
     *         individual game sessions using <a
     *         href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         By default, this property is set to <code>NoProtection</code>.
     * @see ProtectionPolicy
     */
    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(newGameSessionProtectionPolicy);
    }

    /**
     * <p>
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and
     * hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or
     * when retiring unhealthy instances. You can also set game session protection for individual game sessions using <a
     * href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, this property is set to <code>NoProtection</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively
     *         running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down
     *         fleet capacity or when retiring unhealthy instances. You can also set game session protection for
     *         individual game sessions using <a
     *         href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         By default, this property is set to <code>NoProtection</code>.
     * @see ProtectionPolicy
     */
    public final String newGameSessionProtectionPolicyAsString() {
        return newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * A policy that limits the number of game sessions that each individual player can create on instances in this
     * fleet. The limit applies for a specified span of time.
     * </p>
     * 
     * @return A policy that limits the number of game sessions that each individual player can create on instances in
     *         this fleet. The limit applies for a specified span of time.
     */
    public final GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy() {
        return gameSessionCreationLimitPolicy;
    }

    /**
     * <p>
     * A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output for each
     * container in logs, including game session logs. You can select from the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a
     * log stream, which is organized in the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> -- Don't collect container logs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, this property is set to <code>CLOUDWATCH</code>.
     * </p>
     * <p>
     * Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your account.
     * These permissions are included in the IAM fleet role for this container fleet (see <code>FleetRoleArn)</code>.
     * </p>
     * 
     * @return A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output
     *         for each container in logs, including game session logs. You can select from the following methods: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container
     *         emits a log stream, which is organized in the log group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> -- Store logs in an Amazon S3 bucket that you define.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> -- Don't collect container logs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         By default, this property is set to <code>CLOUDWATCH</code>.
     *         </p>
     *         <p>
     *         Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your
     *         account. These permissions are included in the IAM fleet role for this container fleet (see
     *         <code>FleetRoleArn)</code>.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon
     * Web Services resources are useful for resource management, access management and cost allocation. For more
     * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web
     * Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
     *         Amazon Web Services resources are useful for resource management, access management and cost allocation.
     *         For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
     *         Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(gameServerContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(perInstanceContainerGroupDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceConnectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceInboundPermissions() ? instanceInboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gameServerContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(billingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricGroups() ? metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerFleetRequest)) {
            return false;
        }
        CreateContainerFleetRequest other = (CreateContainerFleetRequest) obj;
        return Objects.equals(fleetRoleArn(), other.fleetRoleArn()) && Objects.equals(description(), other.description())
                && Objects.equals(gameServerContainerGroupDefinitionName(), other.gameServerContainerGroupDefinitionName())
                && Objects.equals(perInstanceContainerGroupDefinitionName(), other.perInstanceContainerGroupDefinitionName())
                && Objects.equals(instanceConnectionPortRange(), other.instanceConnectionPortRange())
                && hasInstanceInboundPermissions() == other.hasInstanceInboundPermissions()
                && Objects.equals(instanceInboundPermissions(), other.instanceInboundPermissions())
                && Objects.equals(gameServerContainerGroupsPerInstance(), other.gameServerContainerGroupsPerInstance())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(billingTypeAsString(), other.billingTypeAsString()) && hasLocations() == other.hasLocations()
                && Objects.equals(locations(), other.locations()) && hasMetricGroups() == other.hasMetricGroups()
                && Objects.equals(metricGroups(), other.metricGroups())
                && Objects.equals(newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString())
                && Objects.equals(gameSessionCreationLimitPolicy(), other.gameSessionCreationLimitPolicy())
                && Objects.equals(logConfiguration(), other.logConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerFleetRequest").add("FleetRoleArn", fleetRoleArn())
                .add("Description", description())
                .add("GameServerContainerGroupDefinitionName", gameServerContainerGroupDefinitionName())
                .add("PerInstanceContainerGroupDefinitionName", perInstanceContainerGroupDefinitionName())
                .add("InstanceConnectionPortRange", instanceConnectionPortRange())
                .add("InstanceInboundPermissions", hasInstanceInboundPermissions() ? instanceInboundPermissions() : null)
                .add("GameServerContainerGroupsPerInstance", gameServerContainerGroupsPerInstance())
                .add("InstanceType", instanceType()).add("BillingType", billingTypeAsString())
                .add("Locations", hasLocations() ? locations() : null)
                .add("MetricGroups", hasMetricGroups() ? metricGroups() : null)
                .add("NewGameSessionProtectionPolicy", newGameSessionProtectionPolicyAsString())
                .add("GameSessionCreationLimitPolicy", gameSessionCreationLimitPolicy())
                .add("LogConfiguration", logConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetRoleArn":
            return Optional.ofNullable(clazz.cast(fleetRoleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GameServerContainerGroupDefinitionName":
            return Optional.ofNullable(clazz.cast(gameServerContainerGroupDefinitionName()));
        case "PerInstanceContainerGroupDefinitionName":
            return Optional.ofNullable(clazz.cast(perInstanceContainerGroupDefinitionName()));
        case "InstanceConnectionPortRange":
            return Optional.ofNullable(clazz.cast(instanceConnectionPortRange()));
        case "InstanceInboundPermissions":
            return Optional.ofNullable(clazz.cast(instanceInboundPermissions()));
        case "GameServerContainerGroupsPerInstance":
            return Optional.ofNullable(clazz.cast(gameServerContainerGroupsPerInstance()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "BillingType":
            return Optional.ofNullable(clazz.cast(billingTypeAsString()));
        case "Locations":
            return Optional.ofNullable(clazz.cast(locations()));
        case "MetricGroups":
            return Optional.ofNullable(clazz.cast(metricGroups()));
        case "NewGameSessionProtectionPolicy":
            return Optional.ofNullable(clazz.cast(newGameSessionProtectionPolicyAsString()));
        case "GameSessionCreationLimitPolicy":
            return Optional.ofNullable(clazz.cast(gameSessionCreationLimitPolicy()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetRoleArn", FLEET_ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("GameServerContainerGroupDefinitionName", GAME_SERVER_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("PerInstanceContainerGroupDefinitionName", PER_INSTANCE_CONTAINER_GROUP_DEFINITION_NAME_FIELD);
        map.put("InstanceConnectionPortRange", INSTANCE_CONNECTION_PORT_RANGE_FIELD);
        map.put("InstanceInboundPermissions", INSTANCE_INBOUND_PERMISSIONS_FIELD);
        map.put("GameServerContainerGroupsPerInstance", GAME_SERVER_CONTAINER_GROUPS_PER_INSTANCE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("BillingType", BILLING_TYPE_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        map.put("MetricGroups", METRIC_GROUPS_FIELD);
        map.put("NewGameSessionProtectionPolicy", NEW_GAME_SESSION_PROTECTION_POLICY_FIELD);
        map.put("GameSessionCreationLimitPolicy", GAME_SESSION_CREATION_LIMIT_POLICY_FIELD);
        map.put("LogConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerFleetRequest, T> g) {
        return obj -> g.apply((CreateContainerFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContainerFleetRequest> {
        /**
         * <p>
         * The unique identifier for an Identity and Access Management (IAM) role with permissions to run your
         * containers on resources that are managed by Amazon GameLift Servers. Use an IAM service role with the
         * <code>GameLiftContainerFleetPolicy</code> managed policy attached. For more information, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM service
         * role</a>. You can't change this fleet property after the fleet is created.
         * </p>
         * <p>
         * IAM role ARN values use the following pattern:
         * <code>arn:aws:iam::[Amazon Web Services account]:role/[role name]</code>.
         * </p>
         * 
         * @param fleetRoleArn
         *        The unique identifier for an Identity and Access Management (IAM) role with permissions to run your
         *        containers on resources that are managed by Amazon GameLift Servers. Use an IAM service role with the
         *        <code>GameLiftContainerFleetPolicy</code> managed policy attached. For more information, see <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM
         *        service role</a>. You can't change this fleet property after the fleet is created.</p>
         *        <p>
         *        IAM role ARN values use the following pattern:
         *        <code>arn:aws:iam::[Amazon Web Services account]:role/[role name]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetRoleArn(String fleetRoleArn);

        /**
         * <p>
         * A meaningful description of the container fleet.
         * </p>
         * 
         * @param description
         *        A meaningful description of the container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A container group definition resource that describes how to deploy containers with your game server build and
         * support software onto each fleet instance. You can specify the container group definition's name to use the
         * latest version. Alternatively, provide an ARN value with a specific version number.
         * </p>
         * <p>
         * Create a container group definition by calling <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
         * >CreateContainerGroupDefinition</a>. This operation creates a <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         * >ContainerGroupDefinition</a> resource.
         * </p>
         * 
         * @param gameServerContainerGroupDefinitionName
         *        A container group definition resource that describes how to deploy containers with your game server
         *        build and support software onto each fleet instance. You can specify the container group definition's
         *        name to use the latest version. Alternatively, provide an ARN value with a specific version
         *        number.</p>
         *        <p>
         *        Create a container group definition by calling <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
         *        >CreateContainerGroupDefinition</a>. This operation creates a <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         *        >ContainerGroupDefinition</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName);

        /**
         * <p>
         * The name of a container group definition resource that describes a set of axillary software. A fleet instance
         * has one process for executables in this container group. A per-instance container group is optional. You can
         * update the fleet to add or remove a per-instance container group at any time. You can specify the container
         * group definition's name to use the latest version. Alternatively, provide an ARN value with a specific
         * version number.
         * </p>
         * <p>
         * Create a container group definition by calling <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
         * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html</a>. This
         * operation creates a <a
         * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         * >https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html</a> resource.
         * </p>
         * 
         * @param perInstanceContainerGroupDefinitionName
         *        The name of a container group definition resource that describes a set of axillary software. A fleet
         *        instance has one process for executables in this container group. A per-instance container group is
         *        optional. You can update the fleet to add or remove a per-instance container group at any time. You
         *        can specify the container group definition's name to use the latest version. Alternatively, provide an
         *        ARN value with a specific version number. </p>
         *        <p>
         *        Create a container group definition by calling <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html"
         *        >https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateContainerGroupDefinition.html</a>.
         *        This operation creates a <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html"
         *        >https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html</a>
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName);

        /**
         * <p>
         * The set of port numbers to open on each fleet instance. A fleet's connection ports map to container ports
         * that are configured in the fleet's container group definitions.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To
         * use the calculated range, don't set this parameter. The values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
         * following formula:
         * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
         * numbers that match the fleet's inbound permissions port range.
         * </p>
         * <note>
         * <p>
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you
         * later remove the manual settings.
         * </p>
         * </note>
         * 
         * @param instanceConnectionPortRange
         *        The set of port numbers to open on each fleet instance. A fleet's connection ports map to container
         *        ports that are configured in the fleet's container group definitions. </p>
         *        <p>
         *        By default, Amazon GameLift Servers calculates an optimal port range based on your fleet
         *        configuration. To use the calculated range, don't set this parameter. The values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers
         *        uses the following formula:
         *        <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also choose to manually set this parameter. When manually setting this parameter, you must use
         *        port numbers that match the fleet's inbound permissions port range.
         *        </p>
         *        <note>
         *        <p>
         *        If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if
         *        you later remove the manual settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange);

        /**
         * <p>
         * The set of port numbers to open on each fleet instance. A fleet's connection ports map to container ports
         * that are configured in the fleet's container group definitions.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To
         * use the calculated range, don't set this parameter. The values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
         * following formula:
         * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
         * numbers that match the fleet's inbound permissions port range.
         * </p>
         * <note>
         * <p>
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you
         * later remove the manual settings.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ConnectionPortRange.Builder}
         * avoiding the need to create one manually via {@link ConnectionPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConnectionPortRange(ConnectionPortRange)}.
         * 
         * @param instanceConnectionPortRange
         *        a consumer that will call methods on {@link ConnectionPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConnectionPortRange(ConnectionPortRange)
         */
        default Builder instanceConnectionPortRange(Consumer<ConnectionPortRange.Builder> instanceConnectionPortRange) {
            return instanceConnectionPortRange(ConnectionPortRange.builder().applyMutation(instanceConnectionPortRange).build());
        }

        /**
         * <p>
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other
         * processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend opening
         * ports only when you need them and closing them when you're finished.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To
         * use the calculated range, don't set this parameter. The values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Protocol: UDP
         * </p>
         * </li>
         * <li>
         * <p>
         * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
         * following formula:
         * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
         * numbers that match the fleet's connection port range.
         * </p>
         * <note>
         * <p>
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you
         * later remove the manual settings.
         * </p>
         * </note>
         * 
         * @param instanceInboundPermissions
         *        The IP address ranges and port settings that allow inbound traffic to access game server processes and
         *        other processes on this fleet. As a best practice, when remotely accessing a fleet instance, we
         *        recommend opening ports only when you need them and closing them when you're finished.</p>
         *        <p>
         *        By default, Amazon GameLift Servers calculates an optimal port range based on your fleet
         *        configuration. To use the calculated range, don't set this parameter. The values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Protocol: UDP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers
         *        uses the following formula:
         *        <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also choose to manually set this parameter. When manually setting this parameter, you must use
         *        port numbers that match the fleet's connection port range.
         *        </p>
         *        <note>
         *        <p>
         *        If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if
         *        you later remove the manual settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInboundPermissions(Collection<IpPermission> instanceInboundPermissions);

        /**
         * <p>
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other
         * processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend opening
         * ports only when you need them and closing them when you're finished.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To
         * use the calculated range, don't set this parameter. The values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Protocol: UDP
         * </p>
         * </li>
         * <li>
         * <p>
         * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
         * following formula:
         * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
         * numbers that match the fleet's connection port range.
         * </p>
         * <note>
         * <p>
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you
         * later remove the manual settings.
         * </p>
         * </note>
         * 
         * @param instanceInboundPermissions
         *        The IP address ranges and port settings that allow inbound traffic to access game server processes and
         *        other processes on this fleet. As a best practice, when remotely accessing a fleet instance, we
         *        recommend opening ports only when you need them and closing them when you're finished.</p>
         *        <p>
         *        By default, Amazon GameLift Servers calculates an optimal port range based on your fleet
         *        configuration. To use the calculated range, don't set this parameter. The values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Protocol: UDP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers
         *        uses the following formula:
         *        <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can also choose to manually set this parameter. When manually setting this parameter, you must use
         *        port numbers that match the fleet's connection port range.
         *        </p>
         *        <note>
         *        <p>
         *        If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if
         *        you later remove the manual settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInboundPermissions(IpPermission... instanceInboundPermissions);

        /**
         * <p>
         * The IP address ranges and port settings that allow inbound traffic to access game server processes and other
         * processes on this fleet. As a best practice, when remotely accessing a fleet instance, we recommend opening
         * ports only when you need them and closing them when you're finished.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers calculates an optimal port range based on your fleet configuration. To
         * use the calculated range, don't set this parameter. The values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Protocol: UDP
         * </p>
         * </li>
         * <li>
         * <p>
         * Port range: 4192 to a number calculated based on your fleet configuration. Amazon GameLift Servers uses the
         * following formula:
         * <code>4192 + [# of game server container groups per fleet instance] * [# of container ports in the game server container group definition] + [# of container ports in the game server container group definition]</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can also choose to manually set this parameter. When manually setting this parameter, you must use port
         * numbers that match the fleet's connection port range.
         * </p>
         * <note>
         * <p>
         * If you set values manually, Amazon GameLift Servers no longer calculates a port range for you, even if you
         * later remove the manual settings.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceInboundPermissions(List<IpPermission>)}.
         * 
         * @param instanceInboundPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInboundPermissions(java.util.Collection<IpPermission>)
         */
        Builder instanceInboundPermissions(Consumer<IpPermission.Builder>... instanceInboundPermissions);

        /**
         * <p>
         * The number of times to replicate the game server container group on each fleet instance.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers calculates the maximum number of game server container groups that can
         * fit on each instance. This calculation is based on the CPU and memory resources of the fleet's instance
         * type). To use the calculated maximum, don't set this parameter. If you set this number manually, Amazon
         * GameLift Servers uses your value as long as it's less than the calculated maximum.
         * </p>
         * 
         * @param gameServerContainerGroupsPerInstance
         *        The number of times to replicate the game server container group on each fleet instance. </p>
         *        <p>
         *        By default, Amazon GameLift Servers calculates the maximum number of game server container groups that
         *        can fit on each instance. This calculation is based on the CPU and memory resources of the fleet's
         *        instance type). To use the calculated maximum, don't set this parameter. If you set this number
         *        manually, Amazon GameLift Servers uses your value as long as it's less than the calculated maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance);

        /**
         * <p>
         * The Amazon EC2 instance type to use for all instances in the fleet. For multi-location fleets, the instance
         * type must be available in the home region and all remote locations. Instance type determines the computing
         * resources and processing power that's available to host your game servers. This includes including CPU,
         * memory, storage, and networking capacity.
         * </p>
         * <p>
         * By default, Amazon GameLift Servers selects an instance type that fits the needs of your container groups and
         * is available in all selected fleet locations. You can also choose to manually set this parameter. See <a
         * href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed
         * descriptions of Amazon EC2 instance types.
         * </p>
         * <p>
         * You can't update this fleet property later.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type to use for all instances in the fleet. For multi-location fleets, the
         *        instance type must be available in the home region and all remote locations. Instance type determines
         *        the computing resources and processing power that's available to host your game servers. This includes
         *        including CPU, memory, storage, and networking capacity. </p>
         *        <p>
         *        By default, Amazon GameLift Servers selects an instance type that fits the needs of your container
         *        groups and is available in all selected fleet locations. You can also choose to manually set this
         *        parameter. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud
         *        Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         *        </p>
         *        <p>
         *        You can't update this fleet property later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         * > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is created.
         * </p>
         * <p>
         * By default, this property is set to <code>ON_DEMAND</code>.
         * </p>
         * <p>
         * You can't update this fleet property later.
         * </p>
         * 
         * @param billingType
         *        Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a
         *        href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         *        > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is
         *        created.</p>
         *        <p>
         *        By default, this property is set to <code>ON_DEMAND</code>.
         *        </p>
         *        <p>
         *        You can't update this fleet property later.
         * @see ContainerFleetBillingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFleetBillingType
         */
        Builder billingType(String billingType);

        /**
         * <p>
         * Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         * > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is created.
         * </p>
         * <p>
         * By default, this property is set to <code>ON_DEMAND</code>.
         * </p>
         * <p>
         * You can't update this fleet property later.
         * </p>
         * 
         * @param billingType
         *        Indicates whether to use On-Demand or Spot instances for this fleet. Learn more about when to use <a
         *        href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         *        > On-Demand versus Spot Instances</a>. This fleet property can't be changed after the fleet is
         *        created.</p>
         *        <p>
         *        By default, this property is set to <code>ON_DEMAND</code>.
         *        </p>
         *        <p>
         *        You can't update this fleet property later.
         * @see ContainerFleetBillingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFleetBillingType
         */
        Builder billingType(ContainerFleetBillingType billingType);

        /**
         * <p>
         * A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or
         * Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services
         * Region codes, such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's home Region,
         * which is the Amazon Web Services Region where the fleet is created. For a list of supported Regions and Local
         * Zones, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon
         * GameLift Servers service locations</a> for managed hosting.
         * </p>
         * 
         * @param locations
         *        A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region
         *        or Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web
         *        Services Region codes, such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's
         *        home Region, which is the Amazon Web Services Region where the fleet is created. For a list of
         *        supported Regions and Local Zones, see <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon
         *        GameLift Servers service locations</a> for managed hosting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<LocationConfiguration> locations);

        /**
         * <p>
         * A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or
         * Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services
         * Region codes, such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's home Region,
         * which is the Amazon Web Services Region where the fleet is created. For a list of supported Regions and Local
         * Zones, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon
         * GameLift Servers service locations</a> for managed hosting.
         * </p>
         * 
         * @param locations
         *        A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region
         *        or Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web
         *        Services Region codes, such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's
         *        home Region, which is the Amazon Web Services Region where the fleet is created. For a list of
         *        supported Regions and Local Zones, see <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon
         *        GameLift Servers service locations</a> for managed hosting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(LocationConfiguration... locations);

        /**
         * <p>
         * A set of locations to deploy container fleet instances to. You can add any Amazon Web Services Region or
         * Local Zone that's supported by Amazon GameLift Servers. Provide a list of one or more Amazon Web Services
         * Region codes, such as <code>us-west-2</code>, or Local Zone names. Also include the fleet's home Region,
         * which is the Amazon Web Services Region where the fleet is created. For a list of supported Regions and Local
         * Zones, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon
         * GameLift Servers service locations</a> for managed hosting.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #locations(List<LocationConfiguration>)}.
         * 
         * @param locations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(java.util.Collection<LocationConfiguration>)
         */
        Builder locations(Consumer<LocationConfiguration.Builder>... locations);

        /**
         * <p>
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric group
         * to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a new name to
         * create a new metric group. Each fleet can have only one metric group, but you can change this value at any
         * time.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric
         *        group to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a
         *        new name to create a new metric group. Each fleet can have only one metric group, but you can change
         *        this value at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(Collection<String> metricGroups);

        /**
         * <p>
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric group
         * to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a new name to
         * create a new metric group. Each fleet can have only one metric group, but you can change this value at any
         * time.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon Web Services CloudWatch metric group to add this fleet to. You can use a metric
         *        group to aggregate metrics for multiple fleets. You can specify an existing metric group name or use a
         *        new name to create a new metric group. Each fleet can have only one metric group, but you can change
         *        this value at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(String... metricGroups);

        /**
         * <p>
         * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running
         * and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet
         * capacity or when retiring unhealthy instances. You can also set game session protection for individual game
         * sessions using <a href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
         * </p>
         * </li>
         * </ul>
         * <p>
         * By default, this property is set to <code>NoProtection</code>.
         * </p>
         * 
         * @param newGameSessionProtectionPolicy
         *        Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively
         *        running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling
         *        down fleet capacity or when retiring unhealthy instances. You can also set game session protection for
         *        individual game sessions using <a
         *        href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        By default, this property is set to <code>NoProtection</code>.
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy);

        /**
         * <p>
         * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running
         * and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet
         * capacity or when retiring unhealthy instances. You can also set game session protection for individual game
         * sessions using <a href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
         * </p>
         * </li>
         * </ul>
         * <p>
         * By default, this property is set to <code>NoProtection</code>.
         * </p>
         * 
         * @param newGameSessionProtectionPolicy
         *        Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively
         *        running and hosting players. Amazon GameLift Servers might prompt an instance shutdown when scaling
         *        down fleet capacity or when retiring unhealthy instances. You can also set game session protection for
         *        individual game sessions using <a
         *        href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- Game sessions can be shut down during active gameplay.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- Game sessions in <code>ACTIVE</code> status can't be shut down.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        By default, this property is set to <code>NoProtection</code>.
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy);

        /**
         * <p>
         * A policy that limits the number of game sessions that each individual player can create on instances in this
         * fleet. The limit applies for a specified span of time.
         * </p>
         * 
         * @param gameSessionCreationLimitPolicy
         *        A policy that limits the number of game sessions that each individual player can create on instances
         *        in this fleet. The limit applies for a specified span of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy);

        /**
         * <p>
         * A policy that limits the number of game sessions that each individual player can create on instances in this
         * fleet. The limit applies for a specified span of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameSessionCreationLimitPolicy.Builder}
         * avoiding the need to create one manually via {@link GameSessionCreationLimitPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameSessionCreationLimitPolicy.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy)}.
         * 
         * @param gameSessionCreationLimitPolicy
         *        a consumer that will call methods on {@link GameSessionCreationLimitPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy)
         */
        default Builder gameSessionCreationLimitPolicy(
                Consumer<GameSessionCreationLimitPolicy.Builder> gameSessionCreationLimitPolicy) {
            return gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy.builder()
                    .applyMutation(gameSessionCreationLimitPolicy).build());
        }

        /**
         * <p>
         * A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output for
         * each container in logs, including game session logs. You can select from the following methods:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits
         * a log stream, which is organized in the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> -- Don't collect container logs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * By default, this property is set to <code>CLOUDWATCH</code>.
         * </p>
         * <p>
         * Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your account.
         * These permissions are included in the IAM fleet role for this container fleet (see <code>FleetRoleArn)</code>
         * .
         * </p>
         * 
         * @param logConfiguration
         *        A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard
         *        output for each container in logs, including game session logs. You can select from the following
         *        methods: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container
         *        emits a log stream, which is organized in the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> -- Store logs in an Amazon S3 bucket that you define.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> -- Don't collect container logs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        By default, this property is set to <code>CLOUDWATCH</code>.
         *        </p>
         *        <p>
         *        Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your
         *        account. These permissions are included in the IAM fleet role for this container fleet (see
         *        <code>FleetRoleArn)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * A method for collecting container logs for the fleet. Amazon GameLift Servers saves all standard output for
         * each container in logs, including game session logs. You can select from the following methods:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits
         * a log stream, which is organized in the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> -- Store logs in an Amazon S3 bucket that you define.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> -- Don't collect container logs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * By default, this property is set to <code>CLOUDWATCH</code>.
         * </p>
         * <p>
         * Amazon GameLift Servers requires permissions to send logs other Amazon Web Services services in your account.
         * These permissions are included in the IAM fleet role for this container fleet (see <code>FleetRoleArn)</code>
         * .
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
         * Amazon Web Services resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
         * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs.
         *        Tagging Amazon Web Services resources are useful for resource management, access management and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
         * Amazon Web Services resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
         * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs.
         *        Tagging Amazon Web Services resources are useful for resource management, access management and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
         * Amazon Web Services resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
         * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.gamelift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetRoleArn;

        private String description;

        private String gameServerContainerGroupDefinitionName;

        private String perInstanceContainerGroupDefinitionName;

        private ConnectionPortRange instanceConnectionPortRange;

        private List<IpPermission> instanceInboundPermissions = DefaultSdkAutoConstructList.getInstance();

        private Integer gameServerContainerGroupsPerInstance;

        private String instanceType;

        private String billingType;

        private List<LocationConfiguration> locations = DefaultSdkAutoConstructList.getInstance();

        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();

        private String newGameSessionProtectionPolicy;

        private GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy;

        private LogConfiguration logConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerFleetRequest model) {
            super(model);
            fleetRoleArn(model.fleetRoleArn);
            description(model.description);
            gameServerContainerGroupDefinitionName(model.gameServerContainerGroupDefinitionName);
            perInstanceContainerGroupDefinitionName(model.perInstanceContainerGroupDefinitionName);
            instanceConnectionPortRange(model.instanceConnectionPortRange);
            instanceInboundPermissions(model.instanceInboundPermissions);
            gameServerContainerGroupsPerInstance(model.gameServerContainerGroupsPerInstance);
            instanceType(model.instanceType);
            billingType(model.billingType);
            locations(model.locations);
            metricGroups(model.metricGroups);
            newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            gameSessionCreationLimitPolicy(model.gameSessionCreationLimitPolicy);
            logConfiguration(model.logConfiguration);
            tags(model.tags);
        }

        public final String getFleetRoleArn() {
            return fleetRoleArn;
        }

        public final void setFleetRoleArn(String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
        }

        @Override
        public final Builder fleetRoleArn(String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGameServerContainerGroupDefinitionName() {
            return gameServerContainerGroupDefinitionName;
        }

        public final void setGameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
        }

        @Override
        public final Builder gameServerContainerGroupDefinitionName(String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
            return this;
        }

        public final String getPerInstanceContainerGroupDefinitionName() {
            return perInstanceContainerGroupDefinitionName;
        }

        public final void setPerInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
        }

        @Override
        public final Builder perInstanceContainerGroupDefinitionName(String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
            return this;
        }

        public final ConnectionPortRange.Builder getInstanceConnectionPortRange() {
            return instanceConnectionPortRange != null ? instanceConnectionPortRange.toBuilder() : null;
        }

        public final void setInstanceConnectionPortRange(ConnectionPortRange.BuilderImpl instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange != null ? instanceConnectionPortRange.build() : null;
        }

        @Override
        public final Builder instanceConnectionPortRange(ConnectionPortRange instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        public final List<IpPermission.Builder> getInstanceInboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.instanceInboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInboundPermissions(Collection<IpPermission.BuilderImpl> instanceInboundPermissions) {
            this.instanceInboundPermissions = IpPermissionsListCopier.copyFromBuilder(instanceInboundPermissions);
        }

        @Override
        public final Builder instanceInboundPermissions(Collection<IpPermission> instanceInboundPermissions) {
            this.instanceInboundPermissions = IpPermissionsListCopier.copy(instanceInboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissions(IpPermission... instanceInboundPermissions) {
            instanceInboundPermissions(Arrays.asList(instanceInboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInboundPermissions(Consumer<IpPermission.Builder>... instanceInboundPermissions) {
            instanceInboundPermissions(Stream.of(instanceInboundPermissions)
                    .map(c -> IpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getGameServerContainerGroupsPerInstance() {
            return gameServerContainerGroupsPerInstance;
        }

        public final void setGameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
        }

        @Override
        public final Builder gameServerContainerGroupsPerInstance(Integer gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getBillingType() {
            return billingType;
        }

        public final void setBillingType(String billingType) {
            this.billingType = billingType;
        }

        @Override
        public final Builder billingType(String billingType) {
            this.billingType = billingType;
            return this;
        }

        @Override
        public final Builder billingType(ContainerFleetBillingType billingType) {
            this.billingType(billingType == null ? null : billingType.toString());
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<LocationConfiguration.BuilderImpl> locations) {
            this.locations = LocationConfigurationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<LocationConfiguration> locations) {
            this.locations = LocationConfigurationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationConfiguration... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationConfiguration.Builder>... locations) {
            locations(Stream.of(locations).map(c -> LocationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String... metricGroups) {
            metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy
                    .toString());
            return this;
        }

        public final GameSessionCreationLimitPolicy.Builder getGameSessionCreationLimitPolicy() {
            return gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.toBuilder() : null;
        }

        public final void setGameSessionCreationLimitPolicy(
                GameSessionCreationLimitPolicy.BuilderImpl gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy != null ? gameSessionCreationLimitPolicy.build()
                    : null;
        }

        @Override
        public final Builder gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicy gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerFleetRequest build() {
            return new CreateContainerFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
