/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gamelift.model.FleetDeployment;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.LocationalDeployment;
import software.amazon.awssdk.services.gamelift.model.LocationalDeploymentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetDeploymentResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeFleetDeploymentResponse> {
    private static final SdkField<FleetDeployment> FLEET_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FleetDeployment").getter(DescribeFleetDeploymentResponse.getter(DescribeFleetDeploymentResponse::fleetDeployment)).setter(DescribeFleetDeploymentResponse.setter(Builder::fleetDeployment)).constructor(FleetDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetDeployment").build()}).build();
    private static final SdkField<Map<String, LocationalDeployment>> LOCATIONAL_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LocationalDeployments").getter(DescribeFleetDeploymentResponse.getter(DescribeFleetDeploymentResponse::locationalDeployments)).setter(DescribeFleetDeploymentResponse.setter(Builder::locationalDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationalDeployments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationalDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_DEPLOYMENT_FIELD, LOCATIONAL_DEPLOYMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetDeploymentResponse.memberNameToFieldInitializer();
    private final FleetDeployment fleetDeployment;
    private final Map<String, LocationalDeployment> locationalDeployments;

    private DescribeFleetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.fleetDeployment = builder.fleetDeployment;
        this.locationalDeployments = builder.locationalDeployments;
    }

    public final FleetDeployment fleetDeployment() {
        return this.fleetDeployment;
    }

    public final boolean hasLocationalDeployments() {
        return this.locationalDeployments != null && !(this.locationalDeployments instanceof SdkAutoConstructMap);
    }

    public final Map<String, LocationalDeployment> locationalDeployments() {
        return this.locationalDeployments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationalDeployments() ? this.locationalDeployments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetDeploymentResponse)) {
            return false;
        }
        DescribeFleetDeploymentResponse other = (DescribeFleetDeploymentResponse)((Object)obj);
        return Objects.equals(this.fleetDeployment(), other.fleetDeployment()) && this.hasLocationalDeployments() == other.hasLocationalDeployments() && Objects.equals(this.locationalDeployments(), other.locationalDeployments());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetDeploymentResponse").add("FleetDeployment", (Object)this.fleetDeployment()).add("LocationalDeployments", this.hasLocationalDeployments() ? this.locationalDeployments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetDeployment": {
                return Optional.ofNullable(clazz.cast(this.fleetDeployment()));
            }
            case "LocationalDeployments": {
                return Optional.ofNullable(clazz.cast(this.locationalDeployments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FleetDeployment", FLEET_DEPLOYMENT_FIELD);
        map.put("LocationalDeployments", LOCATIONAL_DEPLOYMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetDeploymentResponse, T> g) {
        return obj -> g.apply((DescribeFleetDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private FleetDeployment fleetDeployment;
        private Map<String, LocationalDeployment> locationalDeployments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetDeploymentResponse model) {
            super(model);
            this.fleetDeployment(model.fleetDeployment);
            this.locationalDeployments(model.locationalDeployments);
        }

        public final FleetDeployment.Builder getFleetDeployment() {
            return this.fleetDeployment != null ? this.fleetDeployment.toBuilder() : null;
        }

        public final void setFleetDeployment(FleetDeployment.BuilderImpl fleetDeployment) {
            this.fleetDeployment = fleetDeployment != null ? fleetDeployment.build() : null;
        }

        @Override
        public final Builder fleetDeployment(FleetDeployment fleetDeployment) {
            this.fleetDeployment = fleetDeployment;
            return this;
        }

        public final Map<String, LocationalDeployment.Builder> getLocationalDeployments() {
            Map<String, LocationalDeployment.Builder> result = LocationalDeploymentsCopier.copyToBuilder(this.locationalDeployments);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLocationalDeployments(Map<String, LocationalDeployment.BuilderImpl> locationalDeployments) {
            this.locationalDeployments = LocationalDeploymentsCopier.copyFromBuilder(locationalDeployments);
        }

        @Override
        public final Builder locationalDeployments(Map<String, LocationalDeployment> locationalDeployments) {
            this.locationalDeployments = LocationalDeploymentsCopier.copy(locationalDeployments);
            return this;
        }

        @Override
        public DescribeFleetDeploymentResponse build() {
            return new DescribeFleetDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetDeploymentResponse> {
        public Builder fleetDeployment(FleetDeployment var1);

        default public Builder fleetDeployment(Consumer<FleetDeployment.Builder> fleetDeployment) {
            return this.fleetDeployment((FleetDeployment)((FleetDeployment.Builder)FleetDeployment.builder().applyMutation(fleetDeployment)).build());
        }

        public Builder locationalDeployments(Map<String, LocationalDeployment> var1);
    }
}

