/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerDefinition;
import software.amazon.awssdk.services.gamelift.model.ContainerDefinitionListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionStatus;
import software.amazon.awssdk.services.gamelift.model.ContainerOperatingSystem;
import software.amazon.awssdk.services.gamelift.model.ContainerSchedulingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerGroupDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerGroupDefinition> {
    private static final SdkField<String> CONTAINER_GROUP_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerGroupDefinitionArn").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::containerGroupDefinitionArn)).setter(ContainerGroupDefinition.setter(Builder::containerGroupDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::creationTime)).setter(ContainerGroupDefinition.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::operatingSystemAsString)).setter(ContainerGroupDefinition.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::name)).setter(ContainerGroupDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchedulingStrategy").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::schedulingStrategyAsString)).setter(ContainerGroupDefinition.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingStrategy").build()}).build();
    private static final SdkField<Integer> TOTAL_MEMORY_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalMemoryLimit").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::totalMemoryLimit)).setter(ContainerGroupDefinition.setter(Builder::totalMemoryLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMemoryLimit").build()}).build();
    private static final SdkField<Integer> TOTAL_CPU_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCpuLimit").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::totalCpuLimit)).setter(ContainerGroupDefinition.setter(Builder::totalCpuLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCpuLimit").build()}).build();
    private static final SdkField<List<ContainerDefinition>> CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerDefinitions").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::containerDefinitions)).setter(ContainerGroupDefinition.setter(Builder::containerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::statusAsString)).setter(ContainerGroupDefinition.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ContainerGroupDefinition.getter(ContainerGroupDefinition::statusReason)).setter(ContainerGroupDefinition.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_GROUP_DEFINITION_ARN_FIELD, CREATION_TIME_FIELD, OPERATING_SYSTEM_FIELD, NAME_FIELD, SCHEDULING_STRATEGY_FIELD, TOTAL_MEMORY_LIMIT_FIELD, TOTAL_CPU_LIMIT_FIELD, CONTAINER_DEFINITIONS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContainerGroupDefinitionArn", CONTAINER_GROUP_DEFINITION_ARN_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("SchedulingStrategy", SCHEDULING_STRATEGY_FIELD);
            this.put("TotalMemoryLimit", TOTAL_MEMORY_LIMIT_FIELD);
            this.put("TotalCpuLimit", TOTAL_CPU_LIMIT_FIELD);
            this.put("ContainerDefinitions", CONTAINER_DEFINITIONS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String containerGroupDefinitionArn;
    private final Instant creationTime;
    private final String operatingSystem;
    private final String name;
    private final String schedulingStrategy;
    private final Integer totalMemoryLimit;
    private final Integer totalCpuLimit;
    private final List<ContainerDefinition> containerDefinitions;
    private final String status;
    private final String statusReason;

    private ContainerGroupDefinition(BuilderImpl builder) {
        this.containerGroupDefinitionArn = builder.containerGroupDefinitionArn;
        this.creationTime = builder.creationTime;
        this.operatingSystem = builder.operatingSystem;
        this.name = builder.name;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.totalMemoryLimit = builder.totalMemoryLimit;
        this.totalCpuLimit = builder.totalCpuLimit;
        this.containerDefinitions = builder.containerDefinitions;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String containerGroupDefinitionArn() {
        return this.containerGroupDefinitionArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ContainerOperatingSystem operatingSystem() {
        return ContainerOperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerSchedulingStrategy schedulingStrategy() {
        return ContainerSchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public final String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    public final Integer totalMemoryLimit() {
        return this.totalMemoryLimit;
    }

    public final Integer totalCpuLimit() {
        return this.totalCpuLimit;
    }

    public final boolean hasContainerDefinitions() {
        return this.containerDefinitions != null && !(this.containerDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ContainerDefinition> containerDefinitions() {
        return this.containerDefinitions;
    }

    public final ContainerGroupDefinitionStatus status() {
        return ContainerGroupDefinitionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerGroupDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMemoryLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCpuLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerDefinitions() ? this.containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupDefinition)) {
            return false;
        }
        ContainerGroupDefinition other = (ContainerGroupDefinition)obj;
        return Objects.equals(this.containerGroupDefinitionArn(), other.containerGroupDefinitionArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString()) && Objects.equals(this.totalMemoryLimit(), other.totalMemoryLimit()) && Objects.equals(this.totalCpuLimit(), other.totalCpuLimit()) && this.hasContainerDefinitions() == other.hasContainerDefinitions() && Objects.equals(this.containerDefinitions(), other.containerDefinitions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerGroupDefinition").add("ContainerGroupDefinitionArn", (Object)this.containerGroupDefinitionArn()).add("CreationTime", (Object)this.creationTime()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("Name", (Object)this.name()).add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).add("TotalMemoryLimit", (Object)this.totalMemoryLimit()).add("TotalCpuLimit", (Object)this.totalCpuLimit()).add("ContainerDefinitions", this.hasContainerDefinitions() ? this.containerDefinitions() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerGroupDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.containerGroupDefinitionArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SchedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
            case "TotalMemoryLimit": {
                return Optional.ofNullable(clazz.cast(this.totalMemoryLimit()));
            }
            case "TotalCpuLimit": {
                return Optional.ofNullable(clazz.cast(this.totalCpuLimit()));
            }
            case "ContainerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerDefinitions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupDefinition, T> g) {
        return obj -> g.apply((ContainerGroupDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerGroupDefinitionArn;
        private Instant creationTime;
        private String operatingSystem;
        private String name;
        private String schedulingStrategy;
        private Integer totalMemoryLimit;
        private Integer totalCpuLimit;
        private List<ContainerDefinition> containerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupDefinition model) {
            this.containerGroupDefinitionArn(model.containerGroupDefinitionArn);
            this.creationTime(model.creationTime);
            this.operatingSystem(model.operatingSystem);
            this.name(model.name);
            this.schedulingStrategy(model.schedulingStrategy);
            this.totalMemoryLimit(model.totalMemoryLimit);
            this.totalCpuLimit(model.totalCpuLimit);
            this.containerDefinitions(model.containerDefinitions);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getContainerGroupDefinitionArn() {
            return this.containerGroupDefinitionArn;
        }

        public final void setContainerGroupDefinitionArn(String containerGroupDefinitionArn) {
            this.containerGroupDefinitionArn = containerGroupDefinitionArn;
        }

        @Override
        public final Builder containerGroupDefinitionArn(String containerGroupDefinitionArn) {
            this.containerGroupDefinitionArn = containerGroupDefinitionArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(ContainerOperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchedulingStrategy() {
            return this.schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final Integer getTotalMemoryLimit() {
            return this.totalMemoryLimit;
        }

        public final void setTotalMemoryLimit(Integer totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
        }

        @Override
        public final Builder totalMemoryLimit(Integer totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
            return this;
        }

        public final Integer getTotalCpuLimit() {
            return this.totalCpuLimit;
        }

        public final void setTotalCpuLimit(Integer totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
        }

        @Override
        public final Builder totalCpuLimit(Integer totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
            return this;
        }

        public final List<ContainerDefinition.Builder> getContainerDefinitions() {
            List<ContainerDefinition.Builder> result = ContainerDefinitionListCopier.copyToBuilder(this.containerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinition.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionListCopier.copyFromBuilder(containerDefinitions);
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionListCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinition ... containerDefinitions) {
            this.containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... containerDefinitions) {
            this.containerDefinitions(Stream.of(containerDefinitions).map(c -> (ContainerDefinition)((ContainerDefinition.Builder)ContainerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerGroupDefinitionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public ContainerGroupDefinition build() {
            return new ContainerGroupDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerGroupDefinition> {
        public Builder containerGroupDefinitionArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(ContainerOperatingSystem var1);

        public Builder name(String var1);

        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(ContainerSchedulingStrategy var1);

        public Builder totalMemoryLimit(Integer var1);

        public Builder totalCpuLimit(Integer var1);

        public Builder containerDefinitions(Collection<ContainerDefinition> var1);

        public Builder containerDefinitions(ContainerDefinition ... var1);

        public Builder containerDefinitions(Consumer<ContainerDefinition.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ContainerGroupDefinitionStatus var1);

        public Builder statusReason(String var1);
    }
}

