/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerSessionCreationPolicy;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGameSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, UpdateGameSessionRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(UpdateGameSessionRequest.getter(UpdateGameSessionRequest::gameSessionId)).setter(UpdateGameSessionRequest.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount").getter(UpdateGameSessionRequest.getter(UpdateGameSessionRequest::maximumPlayerSessionCount)).setter(UpdateGameSessionRequest.setter(Builder::maximumPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateGameSessionRequest.getter(UpdateGameSessionRequest::name)).setter(UpdateGameSessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PLAYER_SESSION_CREATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerSessionCreationPolicy").getter(UpdateGameSessionRequest.getter(UpdateGameSessionRequest::playerSessionCreationPolicyAsString)).setter(UpdateGameSessionRequest.setter(Builder::playerSessionCreationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionCreationPolicy").build()}).build();
    private static final SdkField<String> PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectionPolicy").getter(UpdateGameSessionRequest.getter(UpdateGameSessionRequest::protectionPolicyAsString)).setter(UpdateGameSessionRequest.setter(Builder::protectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionPolicy").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameProperties").getter(UpdateGameSessionRequest.getter(UpdateGameSessionRequest::gameProperties)).setter(UpdateGameSessionRequest.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, NAME_FIELD, PLAYER_SESSION_CREATION_POLICY_FIELD, PROTECTION_POLICY_FIELD, GAME_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GameSessionId", GAME_SESSION_ID_FIELD);
            this.put("MaximumPlayerSessionCount", MAXIMUM_PLAYER_SESSION_COUNT_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("PlayerSessionCreationPolicy", PLAYER_SESSION_CREATION_POLICY_FIELD);
            this.put("ProtectionPolicy", PROTECTION_POLICY_FIELD);
            this.put("GameProperties", GAME_PROPERTIES_FIELD);
        }
    });
    private final String gameSessionId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final String playerSessionCreationPolicy;
    private final String protectionPolicy;
    private final List<GameProperty> gameProperties;

    private UpdateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.playerSessionCreationPolicy = builder.playerSessionCreationPolicy;
        this.protectionPolicy = builder.protectionPolicy;
        this.gameProperties = builder.gameProperties;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public final String name() {
        return this.name;
    }

    public final PlayerSessionCreationPolicy playerSessionCreationPolicy() {
        return PlayerSessionCreationPolicy.fromValue(this.playerSessionCreationPolicy);
    }

    public final String playerSessionCreationPolicyAsString() {
        return this.playerSessionCreationPolicy;
    }

    public final ProtectionPolicy protectionPolicy() {
        return ProtectionPolicy.fromValue(this.protectionPolicy);
    }

    public final String protectionPolicyAsString() {
        return this.protectionPolicy;
    }

    public final boolean hasGameProperties() {
        return this.gameProperties != null && !(this.gameProperties instanceof SdkAutoConstructList);
    }

    public final List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerSessionCreationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameProperties() ? this.gameProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGameSessionRequest)) {
            return false;
        }
        UpdateGameSessionRequest other = (UpdateGameSessionRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.playerSessionCreationPolicyAsString(), other.playerSessionCreationPolicyAsString()) && Objects.equals(this.protectionPolicyAsString(), other.protectionPolicyAsString()) && this.hasGameProperties() == other.hasGameProperties() && Objects.equals(this.gameProperties(), other.gameProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGameSessionRequest").add("GameSessionId", (Object)this.gameSessionId()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("Name", (Object)this.name()).add("PlayerSessionCreationPolicy", (Object)this.playerSessionCreationPolicyAsString()).add("ProtectionPolicy", (Object)this.protectionPolicyAsString()).add("GameProperties", this.hasGameProperties() ? this.gameProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PlayerSessionCreationPolicy": {
                return Optional.ofNullable(clazz.cast(this.playerSessionCreationPolicyAsString()));
            }
            case "ProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.protectionPolicyAsString()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGameSessionRequest, T> g) {
        return obj -> g.apply((UpdateGameSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private String playerSessionCreationPolicy;
        private String protectionPolicy;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGameSessionRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.name(model.name);
            this.playerSessionCreationPolicy(model.playerSessionCreationPolicy);
            this.protectionPolicy(model.protectionPolicy);
            this.gameProperties(model.gameProperties);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlayerSessionCreationPolicy() {
            return this.playerSessionCreationPolicy;
        }

        public final void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
        }

        @Override
        public final Builder playerSessionCreationPolicy(String playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy = playerSessionCreationPolicy;
            return this;
        }

        @Override
        public final Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
            this.playerSessionCreationPolicy(playerSessionCreationPolicy == null ? null : playerSessionCreationPolicy.toString());
            return this;
        }

        public final String getProtectionPolicy() {
            return this.protectionPolicy;
        }

        public final void setProtectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
        }

        @Override
        public final Builder protectionPolicy(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        @Override
        public final Builder protectionPolicy(ProtectionPolicy protectionPolicy) {
            this.protectionPolicy(protectionPolicy == null ? null : protectionPolicy.toString());
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGameSessionRequest build() {
            return new UpdateGameSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGameSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder playerSessionCreationPolicy(String var1);

        public Builder playerSessionCreationPolicy(PlayerSessionCreationPolicy var1);

        public Builder protectionPolicy(String var1);

        public Builder protectionPolicy(ProtectionPolicy var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

