/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration;

public class DescribeMatchmakingConfigurationsPublisher
implements SdkPublisher<DescribeMatchmakingConfigurationsResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeMatchmakingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMatchmakingConfigurationsPublisher(GameLiftAsyncClient client, DescribeMatchmakingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMatchmakingConfigurationsPublisher(GameLiftAsyncClient client, DescribeMatchmakingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMatchmakingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMatchmakingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MatchmakingConfiguration> configurations() {
        Function<DescribeMatchmakingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurations() != null) {
                return response.configurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMatchmakingConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMatchmakingConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeMatchmakingConfigurationsResponse> {
        private DescribeMatchmakingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMatchmakingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMatchmakingConfigurationsResponse> nextPage(DescribeMatchmakingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMatchmakingConfigurationsPublisher.this.client.describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsPublisher.this.firstRequest);
            }
            return DescribeMatchmakingConfigurationsPublisher.this.client.describeMatchmakingConfigurations((DescribeMatchmakingConfigurationsRequest)((Object)DescribeMatchmakingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

