/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerOperatingSystem {
    AMAZON_LINUX_2023("AMAZON_LINUX_2023"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerOperatingSystem> VALUE_MAP;
    private final String value;

    private ContainerOperatingSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerOperatingSystem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerOperatingSystem> knownValues() {
        EnumSet<ContainerOperatingSystem> knownValues = EnumSet.allOf(ContainerOperatingSystem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerOperatingSystem.class, ContainerOperatingSystem::toString);
    }
}

