/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.GameSession;

public class DescribeGameSessionsPublisher
implements SdkPublisher<DescribeGameSessionsResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeGameSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGameSessionsPublisher(GameLiftAsyncClient client, DescribeGameSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGameSessionsPublisher(GameLiftAsyncClient client, DescribeGameSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGameSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGameSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameSession> gameSessions() {
        Function<DescribeGameSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessions() != null) {
                return response.gameSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGameSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGameSessionsResponseFetcher
    implements AsyncPageFetcher<DescribeGameSessionsResponse> {
        private DescribeGameSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeGameSessionsResponse> nextPage(DescribeGameSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameSessionsPublisher.this.client.describeGameSessions(DescribeGameSessionsPublisher.this.firstRequest);
            }
            return DescribeGameSessionsPublisher.this.client.describeGameSessions((DescribeGameSessionsRequest)((Object)DescribeGameSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

