/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BalancingStrategy {
    SPOT_ONLY("SPOT_ONLY"),
    SPOT_PREFERRED("SPOT_PREFERRED"),
    ON_DEMAND_ONLY("ON_DEMAND_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BalancingStrategy> VALUE_MAP;
    private final String value;

    private BalancingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BalancingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BalancingStrategy> knownValues() {
        EnumSet<BalancingStrategy> knownValues = EnumSet.allOf(BalancingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BalancingStrategy.class, BalancingStrategy::toString);
    }
}

