/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBuildResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeBuildResponse.Builder, DescribeBuildResponse> {
    private static final SdkField<Build> BUILD_FIELD = SdkField.<Build> builder(MarshallingType.SDK_POJO).memberName("Build")
            .getter(getter(DescribeBuildResponse::build)).setter(setter(Builder::build)).constructor(Build::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Build").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILD_FIELD));

    private final Build build;

    private DescribeBuildResponse(BuilderImpl builder) {
        super(builder);
        this.build = builder.build;
    }

    /**
     * <p>
     * Set of properties describing the requested build.
     * </p>
     * 
     * @return Set of properties describing the requested build.
     */
    public final Build build() {
        return build;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(build());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBuildResponse)) {
            return false;
        }
        DescribeBuildResponse other = (DescribeBuildResponse) obj;
        return Objects.equals(build(), other.build());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBuildResponse").add("Build", build()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Build":
            return Optional.ofNullable(clazz.cast(build()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBuildResponse, T> g) {
        return obj -> g.apply((DescribeBuildResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBuildResponse> {
        /**
         * <p>
         * Set of properties describing the requested build.
         * </p>
         * 
         * @param build
         *        Set of properties describing the requested build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder build(Build build);

        /**
         * <p>
         * Set of properties describing the requested build.
         * </p>
         * This is a convenience method that creates an instance of the {@link Build.Builder} avoiding the need to
         * create one manually via {@link Build#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Build.Builder#build()} is called immediately and its result is
         * passed to {@link #build(Build)}.
         * 
         * @param build
         *        a consumer that will call methods on {@link Build.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #build(Build)
         */
        default Builder build(Consumer<Build.Builder> build) {
            return build(Build.builder().applyMutation(build).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private Build build;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBuildResponse model) {
            super(model);
            build(model.build);
        }

        public final Build.Builder getBuild() {
            return build != null ? build.toBuilder() : null;
        }

        public final void setBuild(Build.BuilderImpl build) {
            this.build = build != null ? build.build() : null;
        }

        @Override
        public final Builder build(Build build) {
            this.build = build;
            return this;
        }

        @Override
        public DescribeBuildResponse build() {
            return new DescribeBuildResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
