/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gamelift.model.AttributeValue;
import software.amazon.awssdk.services.gamelift.model.LatencyMapCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerAttributeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Player
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Player> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(Player.getter(Player::playerId)).setter(Player.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> PLAYER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PlayerAttributes").getter(Player.getter(Player::playerAttributes)).setter(Player.setter(Builder::playerAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Team").getter(Player.getter(Player::team)).setter(Player.setter(Builder::team)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Team").build()}).build();
    private static final SdkField<Map<String, Integer>> LATENCY_IN_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LatencyInMs").getter(Player.getter(Player::latencyInMs)).setter(Player.setter(Builder::latencyInMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatencyInMs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD, PLAYER_ATTRIBUTES_FIELD, TEAM_FIELD, LATENCY_IN_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String playerId;
    private final Map<String, AttributeValue> playerAttributes;
    private final String team;
    private final Map<String, Integer> latencyInMs;

    private Player(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.playerAttributes = builder.playerAttributes;
        this.team = builder.team;
        this.latencyInMs = builder.latencyInMs;
    }

    public final String playerId() {
        return this.playerId;
    }

    public final boolean hasPlayerAttributes() {
        return this.playerAttributes != null && !(this.playerAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> playerAttributes() {
        return this.playerAttributes;
    }

    public final String team() {
        return this.team;
    }

    public final boolean hasLatencyInMs() {
        return this.latencyInMs != null && !(this.latencyInMs instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> latencyInMs() {
        return this.latencyInMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlayerAttributes() ? this.playerAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.team());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatencyInMs() ? this.latencyInMs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Player)) {
            return false;
        }
        Player other = (Player)obj;
        return Objects.equals(this.playerId(), other.playerId()) && this.hasPlayerAttributes() == other.hasPlayerAttributes() && Objects.equals(this.playerAttributes(), other.playerAttributes()) && Objects.equals(this.team(), other.team()) && this.hasLatencyInMs() == other.hasLatencyInMs() && Objects.equals(this.latencyInMs(), other.latencyInMs());
    }

    public final String toString() {
        return ToString.builder((String)"Player").add("PlayerId", (Object)this.playerId()).add("PlayerAttributes", this.hasPlayerAttributes() ? this.playerAttributes() : null).add("Team", (Object)this.team()).add("LatencyInMs", this.hasLatencyInMs() ? this.latencyInMs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerAttributes": {
                return Optional.ofNullable(clazz.cast(this.playerAttributes()));
            }
            case "Team": {
                return Optional.ofNullable(clazz.cast(this.team()));
            }
            case "LatencyInMs": {
                return Optional.ofNullable(clazz.cast(this.latencyInMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Player, T> g) {
        return obj -> g.apply((Player)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private Map<String, AttributeValue> playerAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String team;
        private Map<String, Integer> latencyInMs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Player model) {
            this.playerId(model.playerId);
            this.playerAttributes(model.playerAttributes);
            this.team(model.team);
            this.latencyInMs(model.latencyInMs);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        @Transient
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getPlayerAttributes() {
            Map<String, AttributeValue.Builder> result = PlayerAttributeMapCopier.copyToBuilder(this.playerAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPlayerAttributes(Map<String, AttributeValue.BuilderImpl> playerAttributes) {
            this.playerAttributes = PlayerAttributeMapCopier.copyFromBuilder(playerAttributes);
        }

        @Override
        @Transient
        public final Builder playerAttributes(Map<String, AttributeValue> playerAttributes) {
            this.playerAttributes = PlayerAttributeMapCopier.copy(playerAttributes);
            return this;
        }

        public final String getTeam() {
            return this.team;
        }

        public final void setTeam(String team) {
            this.team = team;
        }

        @Override
        @Transient
        public final Builder team(String team) {
            this.team = team;
            return this;
        }

        public final Map<String, Integer> getLatencyInMs() {
            if (this.latencyInMs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.latencyInMs;
        }

        public final void setLatencyInMs(Map<String, Integer> latencyInMs) {
            this.latencyInMs = LatencyMapCopier.copy(latencyInMs);
        }

        @Override
        @Transient
        public final Builder latencyInMs(Map<String, Integer> latencyInMs) {
            this.latencyInMs = LatencyMapCopier.copy(latencyInMs);
            return this;
        }

        public Player build() {
            return new Player(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Player> {
        public Builder playerId(String var1);

        public Builder playerAttributes(Map<String, AttributeValue> var1);

        public Builder team(String var1);

        public Builder latencyInMs(Map<String, Integer> var1);
    }
}

