/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePlayerSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreatePlayerSessionRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(CreatePlayerSessionRequest.getter(CreatePlayerSessionRequest::gameSessionId)).setter(CreatePlayerSessionRequest.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerId").getter(CreatePlayerSessionRequest.getter(CreatePlayerSessionRequest::playerId)).setter(CreatePlayerSessionRequest.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<String> PLAYER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlayerData").getter(CreatePlayerSessionRequest.getter(CreatePlayerSessionRequest::playerData)).setter(CreatePlayerSessionRequest.setter(Builder::playerData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD, PLAYER_ID_FIELD, PLAYER_DATA_FIELD));
    private final String gameSessionId;
    private final String playerId;
    private final String playerData;

    private CreatePlayerSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final String playerId() {
        return this.playerId;
    }

    public final String playerData() {
        return this.playerData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionRequest)) {
            return false;
        }
        CreatePlayerSessionRequest other = (CreatePlayerSessionRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerData(), other.playerData());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePlayerSessionRequest").add("GameSessionId", (Object)this.gameSessionId()).add("PlayerId", (Object)this.playerId()).add("PlayerData", (Object)this.playerData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "PlayerData": {
                return Optional.ofNullable(clazz.cast(this.playerData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlayerSessionRequest, T> g) {
        return obj -> g.apply((CreatePlayerSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionRequest model) {
            super(model);
            this.gameSessionId(model.gameSessionId);
            this.playerId(model.playerId);
            this.playerData(model.playerData);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        @Transient
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        @Transient
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        @Override
        @Transient
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlayerSessionRequest build() {
            return new CreatePlayerSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePlayerSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

