/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterConfiguration> {
    private static final SdkField<List<String>> ALLOWED_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedLocations").getter(FilterConfiguration.getter(FilterConfiguration::allowedLocations)).setter(FilterConfiguration.setter(Builder::allowedLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_LOCATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedLocations;

    private FilterConfiguration(BuilderImpl builder) {
        this.allowedLocations = builder.allowedLocations;
    }

    public final boolean hasAllowedLocations() {
        return this.allowedLocations != null && !(this.allowedLocations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedLocations() {
        return this.allowedLocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedLocations() ? this.allowedLocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterConfiguration)) {
            return false;
        }
        FilterConfiguration other = (FilterConfiguration)obj;
        return this.hasAllowedLocations() == other.hasAllowedLocations() && Objects.equals(this.allowedLocations(), other.allowedLocations());
    }

    public final String toString() {
        return ToString.builder((String)"FilterConfiguration").add("AllowedLocations", this.hasAllowedLocations() ? this.allowedLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedLocations": {
                return Optional.ofNullable(clazz.cast(this.allowedLocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterConfiguration, T> g) {
        return obj -> g.apply((FilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterConfiguration model) {
            this.allowedLocations(model.allowedLocations);
        }

        public final Collection<String> getAllowedLocations() {
            if (this.allowedLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedLocations;
        }

        public final void setAllowedLocations(Collection<String> allowedLocations) {
            this.allowedLocations = LocationListCopier.copy(allowedLocations);
        }

        @Override
        @Transient
        public final Builder allowedLocations(Collection<String> allowedLocations) {
            this.allowedLocations = LocationListCopier.copy(allowedLocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowedLocations(String ... allowedLocations) {
            this.allowedLocations(Arrays.asList(allowedLocations));
            return this;
        }

        public FilterConfiguration build() {
            return new FilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterConfiguration> {
        public Builder allowedLocations(Collection<String> var1);

        public Builder allowedLocations(String ... var1);
    }
}

