/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.gamelift.model.StringDoubleMapCopier;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S").getter(AttributeValue.getter(AttributeValue::s)).setter(AttributeValue.setter(Builder::s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()}).build();
    private static final SdkField<Double> N_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("N").getter(AttributeValue.getter(AttributeValue::n)).setter(AttributeValue.setter(Builder::n)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()}).build();
    private static final SdkField<List<String>> SL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SL").getter(AttributeValue.getter(AttributeValue::sl)).setter(AttributeValue.setter(Builder::sl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SL").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Double>> SDM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SDM").getter(AttributeValue.getter(AttributeValue::sdm)).setter(AttributeValue.setter(Builder::sdm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SDM").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, SL_FIELD, SDM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s;
    private final Double n;
    private final List<String> sl;
    private final Map<String, Double> sdm;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.sl = builder.sl;
        this.sdm = builder.sdm;
    }

    public final String s() {
        return this.s;
    }

    public final Double n() {
        return this.n;
    }

    public final boolean hasSl() {
        return this.sl != null && !(this.sl instanceof SdkAutoConstructList);
    }

    public final List<String> sl() {
        return this.sl;
    }

    public final boolean hasSdm() {
        return this.sdm != null && !(this.sdm instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> sdm() {
        return this.sdm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSl() ? this.sl() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSdm() ? this.sdm() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.s(), other.s()) && Objects.equals(this.n(), other.n()) && this.hasSl() == other.hasSl() && Objects.equals(this.sl(), other.sl()) && this.hasSdm() == other.hasSdm() && Objects.equals(this.sdm(), other.sdm());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeValue").add("S", (Object)this.s()).add("N", (Object)this.n()).add("SL", this.hasSl() ? this.sl() : null).add("SDM", this.hasSdm() ? this.sdm() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S": {
                return Optional.ofNullable(clazz.cast(this.s()));
            }
            case "N": {
                return Optional.ofNullable(clazz.cast(this.n()));
            }
            case "SL": {
                return Optional.ofNullable(clazz.cast(this.sl()));
            }
            case "SDM": {
                return Optional.ofNullable(clazz.cast(this.sdm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s;
        private Double n;
        private List<String> sl = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Double> sdm = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.s(model.s);
            this.n(model.n);
            this.sl(model.sl);
            this.sdm(model.sdm);
        }

        public final String getS() {
            return this.s;
        }

        public final void setS(String s) {
            this.s = s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final Double getN() {
            return this.n;
        }

        public final void setN(Double n) {
            this.n = n;
        }

        @Override
        public final Builder n(Double n) {
            this.n = n;
            return this;
        }

        public final Collection<String> getSl() {
            if (this.sl instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sl;
        }

        public final void setSl(Collection<String> sl) {
            this.sl = StringListCopier.copy(sl);
        }

        @Override
        public final Builder sl(Collection<String> sl) {
            this.sl = StringListCopier.copy(sl);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sl(String ... sl) {
            this.sl(Arrays.asList(sl));
            return this;
        }

        public final Map<String, Double> getSdm() {
            if (this.sdm instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sdm;
        }

        public final void setSdm(Map<String, Double> sdm) {
            this.sdm = StringDoubleMapCopier.copy(sdm);
        }

        @Override
        public final Builder sdm(Map<String, Double> sdm) {
            this.sdm = StringDoubleMapCopier.copy(sdm);
            return this;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValue> {
        public Builder s(String var1);

        public Builder n(Double var1);

        public Builder sl(Collection<String> var1);

        public Builder sl(String ... var1);

        public Builder sdm(Map<String, Double> var1);
    }
}

