/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.gamelift.model.ScalingPolicy;

public class DescribeScalingPoliciesIterable
implements SdkIterable<DescribeScalingPoliciesResponse> {
    private final GameLiftClient client;
    private final DescribeScalingPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScalingPoliciesIterable(GameLiftClient client, DescribeScalingPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScalingPoliciesResponseFetcher();
    }

    public Iterator<DescribeScalingPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScalingPolicy> scalingPolicies() {
        Function<DescribeScalingPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalingPolicies() != null) {
                return response.scalingPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScalingPoliciesResponseFetcher
    implements SyncPageFetcher<DescribeScalingPoliciesResponse> {
        private DescribeScalingPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalingPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScalingPoliciesResponse nextPage(DescribeScalingPoliciesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalingPoliciesIterable.this.client.describeScalingPolicies(DescribeScalingPoliciesIterable.this.firstRequest);
            }
            return DescribeScalingPoliciesIterable.this.client.describeScalingPolicies((DescribeScalingPoliciesRequest)((Object)DescribeScalingPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

