/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetAttributes;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.LocationState;
import software.amazon.awssdk.services.gamelift.model.LocationStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, CreateFleetResponse> {
    private static final SdkField<FleetAttributes> FLEET_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FleetAttributes").getter(CreateFleetResponse.getter(CreateFleetResponse::fleetAttributes)).setter(CreateFleetResponse.setter(Builder::fleetAttributes)).constructor(FleetAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetAttributes").build()}).build();
    private static final SdkField<List<LocationState>> LOCATION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationStates").getter(CreateFleetResponse.getter(CreateFleetResponse::locationStates)).setter(CreateFleetResponse.setter(Builder::locationStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ATTRIBUTES_FIELD, LOCATION_STATES_FIELD));
    private final FleetAttributes fleetAttributes;
    private final List<LocationState> locationStates;

    private CreateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetAttributes = builder.fleetAttributes;
        this.locationStates = builder.locationStates;
    }

    public final FleetAttributes fleetAttributes() {
        return this.fleetAttributes;
    }

    public final boolean hasLocationStates() {
        return this.locationStates != null && !(this.locationStates instanceof SdkAutoConstructList);
    }

    public final List<LocationState> locationStates() {
        return this.locationStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationStates() ? this.locationStates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetResponse)) {
            return false;
        }
        CreateFleetResponse other = (CreateFleetResponse)((Object)obj);
        return Objects.equals(this.fleetAttributes(), other.fleetAttributes()) && this.hasLocationStates() == other.hasLocationStates() && Objects.equals(this.locationStates(), other.locationStates());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFleetResponse").add("FleetAttributes", (Object)this.fleetAttributes()).add("LocationStates", this.hasLocationStates() ? this.locationStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetAttributes": {
                return Optional.ofNullable(clazz.cast(this.fleetAttributes()));
            }
            case "LocationStates": {
                return Optional.ofNullable(clazz.cast(this.locationStates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetResponse, T> g) {
        return obj -> g.apply((CreateFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private FleetAttributes fleetAttributes;
        private List<LocationState> locationStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetResponse model) {
            super(model);
            this.fleetAttributes(model.fleetAttributes);
            this.locationStates(model.locationStates);
        }

        public final FleetAttributes.Builder getFleetAttributes() {
            return this.fleetAttributes != null ? this.fleetAttributes.toBuilder() : null;
        }

        public final void setFleetAttributes(FleetAttributes.BuilderImpl fleetAttributes) {
            this.fleetAttributes = fleetAttributes != null ? fleetAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder fleetAttributes(FleetAttributes fleetAttributes) {
            this.fleetAttributes = fleetAttributes;
            return this;
        }

        public final List<LocationState.Builder> getLocationStates() {
            List<LocationState.Builder> result = LocationStateListCopier.copyToBuilder(this.locationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationStates(Collection<LocationState.BuilderImpl> locationStates) {
            this.locationStates = LocationStateListCopier.copyFromBuilder(locationStates);
        }

        @Override
        @Transient
        public final Builder locationStates(Collection<LocationState> locationStates) {
            this.locationStates = LocationStateListCopier.copy(locationStates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder locationStates(LocationState ... locationStates) {
            this.locationStates(Arrays.asList(locationStates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder locationStates(Consumer<LocationState.Builder> ... locationStates) {
            this.locationStates(Stream.of(locationStates).map(c -> (LocationState)((LocationState.Builder)LocationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFleetResponse build() {
            return new CreateFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetResponse> {
        public Builder fleetAttributes(FleetAttributes var1);

        default public Builder fleetAttributes(Consumer<FleetAttributes.Builder> fleetAttributes) {
            return this.fleetAttributes((FleetAttributes)((FleetAttributes.Builder)FleetAttributes.builder().applyMutation(fleetAttributes)).build());
        }

        public Builder locationStates(Collection<LocationState> var1);

        public Builder locationStates(LocationState ... var1);

        public Builder locationStates(Consumer<LocationState.Builder> ... var1);
    }
}

