/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceLimit;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceLimitListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEc2InstanceLimitsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeEc2InstanceLimitsResponse> {
    private static final SdkField<List<EC2InstanceLimit>> EC2_INSTANCE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2InstanceLimits").getter(DescribeEc2InstanceLimitsResponse.getter(DescribeEc2InstanceLimitsResponse::ec2InstanceLimits)).setter(DescribeEc2InstanceLimitsResponse.setter(Builder::ec2InstanceLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2InstanceLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_LIMITS_FIELD));
    private final List<EC2InstanceLimit> ec2InstanceLimits;

    private DescribeEc2InstanceLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceLimits = builder.ec2InstanceLimits;
    }

    public final boolean hasEc2InstanceLimits() {
        return this.ec2InstanceLimits != null && !(this.ec2InstanceLimits instanceof SdkAutoConstructList);
    }

    public final List<EC2InstanceLimit> ec2InstanceLimits() {
        return this.ec2InstanceLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceLimits() ? this.ec2InstanceLimits() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEc2InstanceLimitsResponse)) {
            return false;
        }
        DescribeEc2InstanceLimitsResponse other = (DescribeEc2InstanceLimitsResponse)((Object)obj);
        return this.hasEc2InstanceLimits() == other.hasEc2InstanceLimits() && Objects.equals(this.ec2InstanceLimits(), other.ec2InstanceLimits());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEc2InstanceLimitsResponse").add("EC2InstanceLimits", this.hasEc2InstanceLimits() ? this.ec2InstanceLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceLimits": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceLimits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEc2InstanceLimitsResponse, T> g) {
        return obj -> g.apply((DescribeEc2InstanceLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<EC2InstanceLimit> ec2InstanceLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEc2InstanceLimitsResponse model) {
            super(model);
            this.ec2InstanceLimits(model.ec2InstanceLimits);
        }

        public final List<EC2InstanceLimit.Builder> getEc2InstanceLimits() {
            List<EC2InstanceLimit.Builder> result = EC2InstanceLimitListCopier.copyToBuilder(this.ec2InstanceLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceLimits(Collection<EC2InstanceLimit.BuilderImpl> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copyFromBuilder(ec2InstanceLimits);
        }

        @Override
        @Transient
        public final Builder ec2InstanceLimits(Collection<EC2InstanceLimit> ec2InstanceLimits) {
            this.ec2InstanceLimits = EC2InstanceLimitListCopier.copy(ec2InstanceLimits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2InstanceLimits(EC2InstanceLimit ... ec2InstanceLimits) {
            this.ec2InstanceLimits(Arrays.asList(ec2InstanceLimits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder> ... ec2InstanceLimits) {
            this.ec2InstanceLimits(Stream.of(ec2InstanceLimits).map(c -> (EC2InstanceLimit)((EC2InstanceLimit.Builder)EC2InstanceLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEc2InstanceLimitsResponse build() {
            return new DescribeEc2InstanceLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEc2InstanceLimitsResponse> {
        public Builder ec2InstanceLimits(Collection<EC2InstanceLimit> var1);

        public Builder ec2InstanceLimits(EC2InstanceLimit ... var1);

        public Builder ec2InstanceLimits(Consumer<EC2InstanceLimit.Builder> ... var1);
    }
}

