/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameServer;
import software.amazon.awssdk.services.gamelift.model.GameServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGameServersResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListGameServersResponse> {
    private static final SdkField<List<GameServer>> GAME_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameServers").getter(ListGameServersResponse.getter(ListGameServersResponse::gameServers)).setter(ListGameServersResponse.setter(Builder::gameServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGameServersResponse.getter(ListGameServersResponse::nextToken)).setter(ListGameServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GameServer> gameServers;
    private final String nextToken;

    private ListGameServersResponse(BuilderImpl builder) {
        super(builder);
        this.gameServers = builder.gameServers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGameServers() {
        return this.gameServers != null && !(this.gameServers instanceof SdkAutoConstructList);
    }

    public final List<GameServer> gameServers() {
        return this.gameServers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameServers() ? this.gameServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGameServersResponse)) {
            return false;
        }
        ListGameServersResponse other = (ListGameServersResponse)((Object)obj);
        return this.hasGameServers() == other.hasGameServers() && Objects.equals(this.gameServers(), other.gameServers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGameServersResponse").add("GameServers", this.hasGameServers() ? this.gameServers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameServers": {
                return Optional.ofNullable(clazz.cast(this.gameServers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGameServersResponse, T> g) {
        return obj -> g.apply((ListGameServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameServer> gameServers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGameServersResponse model) {
            super(model);
            this.gameServers(model.gameServers);
            this.nextToken(model.nextToken);
        }

        public final List<GameServer.Builder> getGameServers() {
            List<GameServer.Builder> result = GameServersCopier.copyToBuilder(this.gameServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameServers(Collection<GameServer.BuilderImpl> gameServers) {
            this.gameServers = GameServersCopier.copyFromBuilder(gameServers);
        }

        @Override
        @Transient
        public final Builder gameServers(Collection<GameServer> gameServers) {
            this.gameServers = GameServersCopier.copy(gameServers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gameServers(GameServer ... gameServers) {
            this.gameServers(Arrays.asList(gameServers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gameServers(Consumer<GameServer.Builder> ... gameServers) {
            this.gameServers(Stream.of(gameServers).map(c -> (GameServer)((GameServer.Builder)GameServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGameServersResponse build() {
            return new ListGameServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGameServersResponse> {
        public Builder gameServers(Collection<GameServer> var1);

        public Builder gameServers(GameServer ... var1);

        public Builder gameServers(Consumer<GameServer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

