/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Script
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Script> {
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptId").getter(Script.getter(Script::scriptId)).setter(Script.setter(Builder::scriptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()}).build();
    private static final SdkField<String> SCRIPT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptArn").getter(Script.getter(Script::scriptArn)).setter(Script.setter(Builder::scriptArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Script.getter(Script::name)).setter(Script.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Script.getter(Script::version)).setter(Script.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Long> SIZE_ON_DISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeOnDisk").getter(Script.getter(Script::sizeOnDisk)).setter(Script.setter(Builder::sizeOnDisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeOnDisk").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Script.getter(Script::creationTime)).setter(Script.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLocation").getter(Script.getter(Script::storageLocation)).setter(Script.setter(Builder::storageLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_ID_FIELD, SCRIPT_ARN_FIELD, NAME_FIELD, VERSION_FIELD, SIZE_ON_DISK_FIELD, CREATION_TIME_FIELD, STORAGE_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scriptId;
    private final String scriptArn;
    private final String name;
    private final String version;
    private final Long sizeOnDisk;
    private final Instant creationTime;
    private final S3Location storageLocation;

    private Script(BuilderImpl builder) {
        this.scriptId = builder.scriptId;
        this.scriptArn = builder.scriptArn;
        this.name = builder.name;
        this.version = builder.version;
        this.sizeOnDisk = builder.sizeOnDisk;
        this.creationTime = builder.creationTime;
        this.storageLocation = builder.storageLocation;
    }

    public final String scriptId() {
        return this.scriptId;
    }

    public final String scriptArn() {
        return this.scriptArn;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final Long sizeOnDisk() {
        return this.sizeOnDisk;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final S3Location storageLocation() {
        return this.storageLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeOnDisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Script)) {
            return false;
        }
        Script other = (Script)obj;
        return Objects.equals(this.scriptId(), other.scriptId()) && Objects.equals(this.scriptArn(), other.scriptArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.sizeOnDisk(), other.sizeOnDisk()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.storageLocation(), other.storageLocation());
    }

    public final String toString() {
        return ToString.builder((String)"Script").add("ScriptId", (Object)this.scriptId()).add("ScriptArn", (Object)this.scriptArn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("SizeOnDisk", (Object)this.sizeOnDisk()).add("CreationTime", (Object)this.creationTime()).add("StorageLocation", (Object)this.storageLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScriptId": {
                return Optional.ofNullable(clazz.cast(this.scriptId()));
            }
            case "ScriptArn": {
                return Optional.ofNullable(clazz.cast(this.scriptArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "SizeOnDisk": {
                return Optional.ofNullable(clazz.cast(this.sizeOnDisk()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StorageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Script, T> g) {
        return obj -> g.apply((Script)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scriptId;
        private String scriptArn;
        private String name;
        private String version;
        private Long sizeOnDisk;
        private Instant creationTime;
        private S3Location storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(Script model) {
            this.scriptId(model.scriptId);
            this.scriptArn(model.scriptArn);
            this.name(model.name);
            this.version(model.version);
            this.sizeOnDisk(model.sizeOnDisk);
            this.creationTime(model.creationTime);
            this.storageLocation(model.storageLocation);
        }

        public final String getScriptId() {
            return this.scriptId;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        @Override
        @Transient
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final String getScriptArn() {
            return this.scriptArn;
        }

        public final void setScriptArn(String scriptArn) {
            this.scriptArn = scriptArn;
        }

        @Override
        @Transient
        public final Builder scriptArn(String scriptArn) {
            this.scriptArn = scriptArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Long getSizeOnDisk() {
            return this.sizeOnDisk;
        }

        public final void setSizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
        }

        @Override
        @Transient
        public final Builder sizeOnDisk(Long sizeOnDisk) {
            this.sizeOnDisk = sizeOnDisk;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final S3Location.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public Script build() {
            return new Script(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Script> {
        public Builder scriptId(String var1);

        public Builder scriptArn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder sizeOnDisk(Long var1);

        public Builder creationTime(Instant var1);

        public Builder storageLocation(S3Location var1);

        default public Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return this.storageLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(storageLocation)).build());
        }
    }
}

