/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.PlayerSession;

public class DescribePlayerSessionsPublisher
implements SdkPublisher<DescribePlayerSessionsResponse> {
    private final GameLiftAsyncClient client;
    private final DescribePlayerSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePlayerSessionsPublisher(GameLiftAsyncClient client, DescribePlayerSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePlayerSessionsPublisher(GameLiftAsyncClient client, DescribePlayerSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePlayerSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePlayerSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PlayerSession> playerSessions() {
        Function<DescribePlayerSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.playerSessions() != null) {
                return response.playerSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePlayerSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePlayerSessionsResponseFetcher
    implements AsyncPageFetcher<DescribePlayerSessionsResponse> {
        private DescribePlayerSessionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePlayerSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePlayerSessionsResponse> nextPage(DescribePlayerSessionsResponse previousPage) {
            if (previousPage == null) {
                return DescribePlayerSessionsPublisher.this.client.describePlayerSessions(DescribePlayerSessionsPublisher.this.firstRequest);
            }
            return DescribePlayerSessionsPublisher.this.client.describePlayerSessions((DescribePlayerSessionsRequest)((Object)DescribePlayerSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

