/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetPortSettingsRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateFleetPortSettingsRequest.Builder, UpdateFleetPortSettingsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(UpdateFleetPortSettingsRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<List<IpPermission>> INBOUND_PERMISSION_AUTHORIZATIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("InboundPermissionAuthorizations")
            .getter(getter(UpdateFleetPortSettingsRequest::inboundPermissionAuthorizations))
            .setter(setter(Builder::inboundPermissionAuthorizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissionAuthorizations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<IpPermission>> INBOUND_PERMISSION_REVOCATIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("InboundPermissionRevocations")
            .getter(getter(UpdateFleetPortSettingsRequest::inboundPermissionRevocations))
            .setter(setter(Builder::inboundPermissionRevocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundPermissionRevocations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            INBOUND_PERMISSION_AUTHORIZATIONS_FIELD, INBOUND_PERMISSION_REVOCATIONS_FIELD));

    private final String fleetId;

    private final List<IpPermission> inboundPermissionAuthorizations;

    private final List<IpPermission> inboundPermissionRevocations;

    private UpdateFleetPortSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.inboundPermissionAuthorizations = builder.inboundPermissionAuthorizations;
        this.inboundPermissionRevocations = builder.inboundPermissionRevocations;
    }

    /**
     * <p>
     * A unique identifier for a fleet to update port settings for. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for a fleet to update port settings for. You can use either the fleet ID or ARN
     *         value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * Returns true if the InboundPermissionAuthorizations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasInboundPermissionAuthorizations() {
        return inboundPermissionAuthorizations != null && !(inboundPermissionAuthorizations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of port settings to be added to the fleet resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInboundPermissionAuthorizations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of port settings to be added to the fleet resource.
     */
    public final List<IpPermission> inboundPermissionAuthorizations() {
        return inboundPermissionAuthorizations;
    }

    /**
     * Returns true if the InboundPermissionRevocations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasInboundPermissionRevocations() {
        return inboundPermissionRevocations != null && !(inboundPermissionRevocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of port settings to be removed from the fleet resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInboundPermissionRevocations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of port settings to be removed from the fleet resource.
     */
    public final List<IpPermission> inboundPermissionRevocations() {
        return inboundPermissionRevocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasInboundPermissionAuthorizations() ? inboundPermissionAuthorizations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInboundPermissionRevocations() ? inboundPermissionRevocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetPortSettingsRequest)) {
            return false;
        }
        UpdateFleetPortSettingsRequest other = (UpdateFleetPortSettingsRequest) obj;
        return Objects.equals(fleetId(), other.fleetId())
                && hasInboundPermissionAuthorizations() == other.hasInboundPermissionAuthorizations()
                && Objects.equals(inboundPermissionAuthorizations(), other.inboundPermissionAuthorizations())
                && hasInboundPermissionRevocations() == other.hasInboundPermissionRevocations()
                && Objects.equals(inboundPermissionRevocations(), other.inboundPermissionRevocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateFleetPortSettingsRequest")
                .add("FleetId", fleetId())
                .add("InboundPermissionAuthorizations",
                        hasInboundPermissionAuthorizations() ? inboundPermissionAuthorizations() : null)
                .add("InboundPermissionRevocations", hasInboundPermissionRevocations() ? inboundPermissionRevocations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "InboundPermissionAuthorizations":
            return Optional.ofNullable(clazz.cast(inboundPermissionAuthorizations()));
        case "InboundPermissionRevocations":
            return Optional.ofNullable(clazz.cast(inboundPermissionRevocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetPortSettingsRequest, T> g) {
        return obj -> g.apply((UpdateFleetPortSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetPortSettingsRequest> {
        /**
         * <p>
         * A unique identifier for a fleet to update port settings for. You can use either the fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for a fleet to update port settings for. You can use either the fleet ID or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A collection of port settings to be added to the fleet resource.
         * </p>
         * 
         * @param inboundPermissionAuthorizations
         *        A collection of port settings to be added to the fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissionAuthorizations(Collection<IpPermission> inboundPermissionAuthorizations);

        /**
         * <p>
         * A collection of port settings to be added to the fleet resource.
         * </p>
         * 
         * @param inboundPermissionAuthorizations
         *        A collection of port settings to be added to the fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissionAuthorizations(IpPermission... inboundPermissionAuthorizations);

        /**
         * <p>
         * A collection of port settings to be added to the fleet resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundPermissionAuthorizations(List<IpPermission>)}.
         * 
         * @param inboundPermissionAuthorizations
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundPermissionAuthorizations(List<IpPermission>)
         */
        Builder inboundPermissionAuthorizations(Consumer<IpPermission.Builder>... inboundPermissionAuthorizations);

        /**
         * <p>
         * A collection of port settings to be removed from the fleet resource.
         * </p>
         * 
         * @param inboundPermissionRevocations
         *        A collection of port settings to be removed from the fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissionRevocations(Collection<IpPermission> inboundPermissionRevocations);

        /**
         * <p>
         * A collection of port settings to be removed from the fleet resource.
         * </p>
         * 
         * @param inboundPermissionRevocations
         *        A collection of port settings to be removed from the fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundPermissionRevocations(IpPermission... inboundPermissionRevocations);

        /**
         * <p>
         * A collection of port settings to be removed from the fleet resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpPermission>.Builder} avoiding the need to
         * create one manually via {@link List<IpPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpPermission>.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundPermissionRevocations(List<IpPermission>)}.
         * 
         * @param inboundPermissionRevocations
         *        a consumer that will call methods on {@link List<IpPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundPermissionRevocations(List<IpPermission>)
         */
        Builder inboundPermissionRevocations(Consumer<IpPermission.Builder>... inboundPermissionRevocations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private List<IpPermission> inboundPermissionAuthorizations = DefaultSdkAutoConstructList.getInstance();

        private List<IpPermission> inboundPermissionRevocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetPortSettingsRequest model) {
            super(model);
            fleetId(model.fleetId);
            inboundPermissionAuthorizations(model.inboundPermissionAuthorizations);
            inboundPermissionRevocations(model.inboundPermissionRevocations);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Collection<IpPermission.Builder> getInboundPermissionAuthorizations() {
            if (inboundPermissionAuthorizations instanceof SdkAutoConstructList) {
                return null;
            }
            return inboundPermissionAuthorizations != null ? inboundPermissionAuthorizations.stream()
                    .map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionAuthorizations(Collection<IpPermission> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copy(inboundPermissionAuthorizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionAuthorizations(IpPermission... inboundPermissionAuthorizations) {
            inboundPermissionAuthorizations(Arrays.asList(inboundPermissionAuthorizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionAuthorizations(Consumer<IpPermission.Builder>... inboundPermissionAuthorizations) {
            inboundPermissionAuthorizations(Stream.of(inboundPermissionAuthorizations)
                    .map(c -> IpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInboundPermissionAuthorizations(Collection<IpPermission.BuilderImpl> inboundPermissionAuthorizations) {
            this.inboundPermissionAuthorizations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionAuthorizations);
        }

        public final Collection<IpPermission.Builder> getInboundPermissionRevocations() {
            if (inboundPermissionRevocations instanceof SdkAutoConstructList) {
                return null;
            }
            return inboundPermissionRevocations != null ? inboundPermissionRevocations.stream().map(IpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inboundPermissionRevocations(Collection<IpPermission> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copy(inboundPermissionRevocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionRevocations(IpPermission... inboundPermissionRevocations) {
            inboundPermissionRevocations(Arrays.asList(inboundPermissionRevocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundPermissionRevocations(Consumer<IpPermission.Builder>... inboundPermissionRevocations) {
            inboundPermissionRevocations(Stream.of(inboundPermissionRevocations)
                    .map(c -> IpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInboundPermissionRevocations(Collection<IpPermission.BuilderImpl> inboundPermissionRevocations) {
            this.inboundPermissionRevocations = IpPermissionsListCopier.copyFromBuilder(inboundPermissionRevocations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetPortSettingsRequest build() {
            return new UpdateFleetPortSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
