/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlayerSessionsRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreatePlayerSessionsRequest.Builder, CreatePlayerSessionsRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(CreatePlayerSessionsRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<List<String>> PLAYER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PlayerIds")
            .getter(getter(CreatePlayerSessionsRequest::playerIds))
            .setter(setter(Builder::playerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PLAYER_DATA_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PlayerDataMap")
            .getter(getter(CreatePlayerSessionsRequest::playerDataMap))
            .setter(setter(Builder::playerDataMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerDataMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD,
            PLAYER_IDS_FIELD, PLAYER_DATA_MAP_FIELD));

    private final String gameSessionId;

    private final List<String> playerIds;

    private final Map<String, String> playerDataMap;

    private CreatePlayerSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerIds = builder.playerIds;
        this.playerDataMap = builder.playerDataMap;
    }

    /**
     * <p>
     * A unique identifier for the game session to add players to.
     * </p>
     * 
     * @return A unique identifier for the game session to add players to.
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * Returns true if the PlayerIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPlayerIds() {
        return playerIds != null && !(playerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of unique identifiers for the players to be added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlayerIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of unique identifiers for the players to be added.
     */
    public final List<String> playerIds() {
        return playerIds;
    }

    /**
     * Returns true if the PlayerDataMap property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPlayerDataMap() {
        return playerDataMap != null && !(playerDataMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of string pairs, each specifying a player ID and a set of developer-defined information related to the
     * player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. Player data
     * strings for player IDs not included in the <code>PlayerIds</code> parameter are ignored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlayerDataMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Map of string pairs, each specifying a player ID and a set of developer-defined information related to
     *         the player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game.
     *         Player data strings for player IDs not included in the <code>PlayerIds</code> parameter are ignored.
     */
    public final Map<String, String> playerDataMap() {
        return playerDataMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlayerIds() ? playerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlayerDataMap() ? playerDataMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsRequest)) {
            return false;
        }
        CreatePlayerSessionsRequest other = (CreatePlayerSessionsRequest) obj;
        return Objects.equals(gameSessionId(), other.gameSessionId()) && hasPlayerIds() == other.hasPlayerIds()
                && Objects.equals(playerIds(), other.playerIds()) && hasPlayerDataMap() == other.hasPlayerDataMap()
                && Objects.equals(playerDataMap(), other.playerDataMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlayerSessionsRequest").add("GameSessionId", gameSessionId())
                .add("PlayerIds", hasPlayerIds() ? playerIds() : null)
                .add("PlayerDataMap", hasPlayerDataMap() ? playerDataMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "PlayerIds":
            return Optional.ofNullable(clazz.cast(playerIds()));
        case "PlayerDataMap":
            return Optional.ofNullable(clazz.cast(playerDataMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlayerSessionsRequest, T> g) {
        return obj -> g.apply((CreatePlayerSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlayerSessionsRequest> {
        /**
         * <p>
         * A unique identifier for the game session to add players to.
         * </p>
         * 
         * @param gameSessionId
         *        A unique identifier for the game session to add players to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * List of unique identifiers for the players to be added.
         * </p>
         * 
         * @param playerIds
         *        List of unique identifiers for the players to be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerIds(Collection<String> playerIds);

        /**
         * <p>
         * List of unique identifiers for the players to be added.
         * </p>
         * 
         * @param playerIds
         *        List of unique identifiers for the players to be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerIds(String... playerIds);

        /**
         * <p>
         * Map of string pairs, each specifying a player ID and a set of developer-defined information related to the
         * player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the game. Player
         * data strings for player IDs not included in the <code>PlayerIds</code> parameter are ignored.
         * </p>
         * 
         * @param playerDataMap
         *        Map of string pairs, each specifying a player ID and a set of developer-defined information related to
         *        the player. Amazon GameLift does not use this data, so it can be formatted as needed for use in the
         *        game. Player data strings for player IDs not included in the <code>PlayerIds</code> parameter are
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerDataMap(Map<String, String> playerDataMap);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameSessionId;

        private List<String> playerIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> playerDataMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionsRequest model) {
            super(model);
            gameSessionId(model.gameSessionId);
            playerIds(model.playerIds);
            playerDataMap(model.playerDataMap);
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final Collection<String> getPlayerIds() {
            if (playerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return playerIds;
        }

        @Override
        public final Builder playerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerIds(String... playerIds) {
            playerIds(Arrays.asList(playerIds));
            return this;
        }

        public final void setPlayerIds(Collection<String> playerIds) {
            this.playerIds = PlayerIdListCopier.copy(playerIds);
        }

        public final Map<String, String> getPlayerDataMap() {
            if (playerDataMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return playerDataMap;
        }

        @Override
        public final Builder playerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
            return this;
        }

        public final void setPlayerDataMap(Map<String, String> playerDataMap) {
            this.playerDataMap = PlayerDataMapCopier.copy(playerDataMap);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlayerSessionsRequest build() {
            return new CreatePlayerSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
