/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;

public class SearchGameSessionsPublisher
implements SdkPublisher<SearchGameSessionsResponse> {
    private final GameLiftAsyncClient client;
    private final SearchGameSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchGameSessionsPublisher(GameLiftAsyncClient client, SearchGameSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchGameSessionsPublisher(GameLiftAsyncClient client, SearchGameSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchGameSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchGameSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameSession> gameSessions() {
        Function<SearchGameSessionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessions() != null) {
                return response.gameSessions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchGameSessionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchGameSessionsResponseFetcher
    implements AsyncPageFetcher<SearchGameSessionsResponse> {
        private SearchGameSessionsResponseFetcher() {
        }

        public boolean hasNextPage(SearchGameSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchGameSessionsResponse> nextPage(SearchGameSessionsResponse previousPage) {
            if (previousPage == null) {
                return SearchGameSessionsPublisher.this.client.searchGameSessions(SearchGameSessionsPublisher.this.firstRequest);
            }
            return SearchGameSessionsPublisher.this.client.searchGameSessions((SearchGameSessionsRequest)((Object)SearchGameSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

